/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.impl;

import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.impl.Slot;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Util {
    public static HashMap<String, String> getCommonHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", String.valueOf(0));
        headers.put("odps-tunnel-date-transform", "v1");
        headers.put("x-odps-tunnel-version", String.valueOf(5));
        headers.put("odps-tunnel-sdk-support-schema-evolution", "true");
        return headers;
    }

    public static RestClient newRestClient(Configuration conf, String projectName) throws TunnelException {
        return Util.newRestClient(conf, conf.getEndpoint(projectName));
    }

    public static RestClient newRestClient(Configuration conf, URI endpoint) {
        RestClient odpsServiceClient = conf.getOdps().clone().getRestClient();
        odpsServiceClient.setReadTimeout(conf.getSocketTimeout());
        odpsServiceClient.setConnectTimeout(conf.getSocketConnectTimeout());
        odpsServiceClient.setEndpoint(endpoint.toString());
        return odpsServiceClient;
    }

    public static List<Slot> parseSlots(JsonArray slotElements) throws TunnelException {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (JsonElement slot : slotElements) {
            if (!slot.isJsonArray()) {
                throw new TunnelException("Invalid slot routes");
            }
            JsonArray slotInfo = slot.getAsJsonArray();
            if (slotInfo.size() != 2) {
                throw new TunnelException("Invalid slot routes");
            }
            slots.add(new Slot(slotInfo.get(0).getAsString(), slotInfo.get(1).getAsString()));
        }
        return slots;
    }
}

