/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.hasher;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.IntervalDayTime;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.tunnel.hasher.DecimalHashObject;
import com.aliyun.odps.tunnel.hasher.HasherFactory;
import com.aliyun.odps.tunnel.hasher.OdpsHasher;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class DefaultHashFactory
implements HasherFactory {
    private static Map<OdpsType, OdpsHasher> factoryMap = new HashMap<OdpsType, OdpsHasher>();

    DefaultHashFactory() {
    }

    @Override
    public OdpsHasher getHasher(OdpsType type) {
        return factoryMap.get(type);
    }

    public String getName() {
        return "default";
    }

    static int basicLongHasher(long val) {
        long l = val;
        l = (l ^ 0xFFFFFFFFFFFFFFFFL) + (l << 18);
        l ^= l >> 31;
        l *= 21L;
        l ^= l >> 11;
        l += l << 6;
        l ^= l >> 22;
        return (int)l;
    }

    static {
        factoryMap.put(OdpsType.TINYINT, new TinyIntHasher());
        factoryMap.put(OdpsType.SMALLINT, new SmallIntHasher());
        factoryMap.put(OdpsType.INT, new IntHasher());
        factoryMap.put(OdpsType.BIGINT, new BigintHasher());
        factoryMap.put(OdpsType.DATETIME, new DateTimeHasher());
        factoryMap.put(OdpsType.DATE, new DateHasher());
        factoryMap.put(OdpsType.FLOAT, new FloatHasher());
        factoryMap.put(OdpsType.DOUBLE, new DoubleHasher());
        factoryMap.put(OdpsType.BOOLEAN, new BooleanHasher());
        factoryMap.put(OdpsType.CHAR, new CharHasher());
        factoryMap.put(OdpsType.VARCHAR, new VarcharHasher());
        factoryMap.put(OdpsType.STRING, new StringHasher());
        factoryMap.put(OdpsType.BINARY, new BinaryHasher());
        factoryMap.put(OdpsType.TIMESTAMP, new TimestampHasher());
        factoryMap.put(OdpsType.TIMESTAMP_NTZ, new TimestampHasher());
        factoryMap.put(OdpsType.INTERVAL_DAY_TIME, new IntervalDayTimeHasher());
        factoryMap.put(OdpsType.DECIMAL, new DecimalHasher());
    }

    private static class DecimalHasher
    implements OdpsHasher<DecimalHashObject> {
        private DecimalHasher() {
        }

        @Override
        public int hash(DecimalHashObject obj) {
            if (obj == null) {
                return 0;
            }
            BigDecimal val = obj.val();
            int precision = obj.precision();
            int scale = obj.scale();
            BigInteger bi = this.castBigDecimal2BigInteger(val.toString(), precision, scale);
            if (this.isDecimal128(precision)) {
                return DefaultHashFactory.basicLongHasher(bi.longValue()) + DefaultHashFactory.basicLongHasher(bi.shiftRight(64).longValue());
            }
            return DefaultHashFactory.basicLongHasher(bi.longValue());
        }

        private boolean isDecimal128(int precision) {
            return precision > 18;
        }

        private BigInteger castBigDecimal2BigInteger(String input, int resultPrecision, int resultScale) throws IllegalArgumentException {
            String numberWithoutExponent;
            input = input.trim();
            int len = input.length();
            int ptr = 0;
            boolean isNegative = false;
            if (len > 0) {
                if (input.charAt(ptr) == '-') {
                    isNegative = true;
                    ++ptr;
                    --len;
                } else if (input.charAt(ptr) == '+') {
                    ++ptr;
                    --len;
                }
            }
            while (len > 0 && input.charAt(ptr) == '0') {
                ++ptr;
                --len;
            }
            int valueScale = 0;
            boolean foundDot = false;
            boolean foundExponent = false;
            for (int i = 0; i < len; ++i) {
                char c = input.charAt(ptr + i);
                if (Character.isDigit(c)) {
                    if (!foundDot) continue;
                    ++valueScale;
                    continue;
                }
                if (c == '.' && !foundDot) {
                    foundDot = true;
                    continue;
                }
                if ((c == 'e' || c == 'E') && i + 1 < len) {
                    foundExponent = true;
                    int exponent = Integer.parseInt(input.substring(ptr + i + 1));
                    valueScale -= exponent;
                    len = ptr + i;
                    break;
                }
                throw new IllegalArgumentException("Invalid decimal format: " + input);
            }
            String string = numberWithoutExponent = foundExponent ? input.substring(ptr, len) : input.substring(ptr);
            if (foundDot) {
                numberWithoutExponent = numberWithoutExponent.replace(".", "");
            }
            if (numberWithoutExponent.isEmpty()) {
                return BigInteger.ZERO;
            }
            BigInteger tmpResult = new BigInteger(numberWithoutExponent);
            if (valueScale > resultScale) {
                tmpResult = tmpResult.divide(BigInteger.TEN.pow(valueScale - resultScale));
                if (numberWithoutExponent.charAt(numberWithoutExponent.length() - (valueScale - resultScale)) >= '5') {
                    tmpResult = tmpResult.add(BigInteger.ONE);
                }
            } else if (valueScale < resultScale) {
                tmpResult = tmpResult.multiply(BigInteger.TEN.pow(resultScale - valueScale));
            }
            if (isNegative) {
                tmpResult = tmpResult.negate();
            }
            return tmpResult;
        }
    }

    private static class IntervalDayTimeHasher
    implements OdpsHasher<IntervalDayTime> {
        private IntervalDayTimeHasher() {
        }

        @Override
        public int hash(IntervalDayTime val) {
            if (val == null) {
                return 0;
            }
            long totalSec = val.getTotalSeconds();
            int nanos = val.getNanos();
            totalSec <<= 30;
            return DefaultHashFactory.basicLongHasher(totalSec |= (long)nanos);
        }
    }

    private static class TimestampHasher
    implements OdpsHasher<Instant> {
        private TimestampHasher() {
        }

        @Override
        public Instant normalizeType(Object value) {
            if (value instanceof Timestamp) {
                return ((Timestamp)value).toInstant();
            }
            if (value instanceof LocalDateTime) {
                return ((LocalDateTime)value).toInstant(ZoneOffset.UTC);
            }
            return (Instant)OdpsHasher.super.normalizeType(value);
        }

        @Override
        public int hash(Instant val) {
            if (val == null) {
                return 0;
            }
            long seconds = val.getEpochSecond();
            int nanos = val.getNano();
            seconds <<= 30;
            return DefaultHashFactory.basicLongHasher(seconds |= (long)nanos);
        }
    }

    private static class DateTimeHasher
    implements OdpsHasher<ZonedDateTime> {
        private DateTimeHasher() {
        }

        @Override
        public ZonedDateTime normalizeType(Object value) {
            if (value instanceof Date) {
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(((Date)value).getTime()), ZoneId.of("UTC"));
            }
            return (ZonedDateTime)OdpsHasher.super.normalizeType(value);
        }

        @Override
        public int hash(ZonedDateTime val) {
            long epochMilli;
            if (val == null) {
                return 0;
            }
            Instant instant = val.toInstant();
            try {
                epochMilli = instant.toEpochMilli();
            }
            catch (ArithmeticException e) {
                epochMilli = this.toEpochMilli(instant.getEpochSecond(), instant.getNano());
            }
            return ((OdpsHasher)factoryMap.get(OdpsType.BIGINT)).hash(epochMilli);
        }

        private long toEpochMilli(long seconds, int nanos) {
            if (seconds < 0L && nanos > 0) {
                long millis = Math.multiplyExact(seconds + 1L, 1000L);
                long adjustment = nanos / 1000000 - 1000;
                return Math.addExact(millis, adjustment);
            }
            long millis = Math.multiplyExact(seconds, 1000L);
            return Math.addExact(millis, (long)(nanos / 1000000));
        }
    }

    private static class DateHasher
    implements OdpsHasher<LocalDate> {
        private DateHasher() {
        }

        @Override
        public LocalDate normalizeType(Object value) {
            if (value instanceof Date) {
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(((Date)value).getTime()), ZoneId.of("UTC")).toLocalDate();
            }
            return (LocalDate)OdpsHasher.super.normalizeType(value);
        }

        @Override
        public int hash(LocalDate val) {
            if (val == null) {
                return 0;
            }
            return ((OdpsHasher)factoryMap.get(OdpsType.BIGINT)).hash(val.atStartOfDay(ZoneOffset.UTC).toEpochSecond());
        }
    }

    private static class VarcharHasher
    implements OdpsHasher<Varchar> {
        private VarcharHasher() {
        }

        @Override
        public int hash(Varchar val) {
            if (val == null) {
                return 0;
            }
            return ((OdpsHasher)factoryMap.get(OdpsType.STRING)).hash(val.getValue());
        }
    }

    private static class CharHasher
    implements OdpsHasher<Char> {
        private CharHasher() {
        }

        @Override
        public int hash(Char val) {
            if (val == null) {
                return 0;
            }
            return ((OdpsHasher)factoryMap.get(OdpsType.STRING)).hash(val.getValue());
        }
    }

    private static class BinaryHasher
    implements OdpsHasher<Binary> {
        private BinaryHasher() {
        }

        @Override
        public int hash(Binary val) {
            if (val == null) {
                return 0;
            }
            return ((OdpsHasher)factoryMap.get(OdpsType.STRING)).hash(val.toString());
        }
    }

    private static class StringHasher
    implements OdpsHasher<String> {
        private static final Charset UTF8 = Charset.forName("UTF8");

        private StringHasher() {
        }

        @Override
        public int hash(String val) {
            if (val == null) {
                return 0;
            }
            byte[] chars = val.getBytes(UTF8);
            int hashVal = 0;
            for (int i = 0; i < chars.length; ++i) {
                hashVal += chars[i];
                hashVal += hashVal << 10;
                hashVal ^= hashVal >> 6;
            }
            hashVal += hashVal << 3;
            hashVal ^= hashVal >> 11;
            hashVal += hashVal << 15;
            return hashVal;
        }
    }

    private static class BooleanHasher
    implements OdpsHasher<Boolean> {
        private BooleanHasher() {
        }

        @Override
        public int hash(Boolean val) {
            if (val == null) {
                return 0;
            }
            if (val.booleanValue()) {
                return 388737479;
            }
            return -978963218;
        }
    }

    private static class DoubleHasher
    implements OdpsHasher<Double> {
        private DoubleHasher() {
        }

        @Override
        public int hash(Double val) {
            if (val == null) {
                return 0;
            }
            return DefaultHashFactory.basicLongHasher(Double.doubleToLongBits(val));
        }
    }

    private static class FloatHasher
    implements OdpsHasher<Float> {
        private FloatHasher() {
        }

        @Override
        public int hash(Float val) {
            if (val == null) {
                return 0;
            }
            return DefaultHashFactory.basicLongHasher(Float.floatToIntBits(val.floatValue()));
        }
    }

    private static class BigintHasher
    implements OdpsHasher<Long> {
        private BigintHasher() {
        }

        @Override
        public int hash(Long val) {
            if (val == null) {
                return 0;
            }
            return DefaultHashFactory.basicLongHasher(val);
        }
    }

    private static class IntHasher
    implements OdpsHasher<Integer> {
        private IntHasher() {
        }

        @Override
        public int hash(Integer val) {
            if (val == null) {
                return 0;
            }
            return DefaultHashFactory.basicLongHasher(val.longValue());
        }
    }

    private static class SmallIntHasher
    implements OdpsHasher<Short> {
        private SmallIntHasher() {
        }

        @Override
        public int hash(Short val) {
            if (val == null) {
                return 0;
            }
            return DefaultHashFactory.basicLongHasher(val.longValue());
        }
    }

    private static class TinyIntHasher
    implements OdpsHasher<Byte> {
        private TinyIntHasher() {
        }

        @Override
        public int hash(Byte val) {
            if (val == null) {
                return 0;
            }
            return DefaultHashFactory.basicLongHasher(val.longValue());
        }
    }
}

