/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.accessor;

import com.aliyun.odps.table.arrow.accessor.ArrowMapAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowVectorAccessor;
import com.aliyun.odps.table.record.accessor.ArrowToRecordConverter;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;

public class ArrowMapAccessorImpl {

    public static class ArrowMapAccessorForRecord
    extends ArrowMapAccessor<Map<Object, Object>> {
        private final boolean isExtension;
        private final TypeInfo keyTypeInfo;
        private final TypeInfo valueTypeInfo;
        private final ArrowVectorAccessor keyAccessor;
        private final ArrowVectorAccessor valueAccessor;

        public ArrowMapAccessorForRecord(MapVector mapVector, TypeInfo typeInfo, boolean isExtension) {
            super(mapVector);
            this.isExtension = isExtension;
            this.keyTypeInfo = ((MapTypeInfo)typeInfo).getKeyTypeInfo();
            this.valueTypeInfo = ((MapTypeInfo)typeInfo).getValueTypeInfo();
            StructVector entries = (StructVector)mapVector.getDataVector();
            this.keyAccessor = ArrowToRecordConverter.createColumnVectorAccessor((ValueVector)entries.getChild("key"), this.keyTypeInfo, isExtension);
            this.valueAccessor = ArrowToRecordConverter.createColumnVectorAccessor((ValueVector)entries.getChild("value"), this.valueTypeInfo, isExtension);
        }

        @Override
        protected Map<Object, Object> getMapData(int offset, int numElements) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            try {
                for (int i = 0; i < numElements; ++i) {
                    map.put(ArrowToRecordConverter.getData(this.keyAccessor, this.keyTypeInfo, offset + i, this.isExtension), ArrowToRecordConverter.getData(this.valueAccessor, this.valueTypeInfo, offset + i, this.isExtension));
                }
                return map;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get the map", e);
            }
        }
    }
}

