/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.v2;

import com.aliyun.odps.Instance;
import com.aliyun.odps.LogView;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Quota;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.sqa.ExecuteMode;
import com.aliyun.odps.sqa.QueryInfo;
import com.aliyun.odps.sqa.SQLExecutor;
import com.aliyun.odps.sqa.SQLExecutorBuilder;
import com.aliyun.odps.sqa.SQLExecutorPool;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.sqa.commandapi.utils.SqlParserUtil;
import com.aliyun.odps.sqa.v2.InMemoryRecordIterator;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.utils.CSVRecordParser;
import com.aliyun.odps.utils.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class SQLExecutorImpl
implements SQLExecutor {
    private static final String DEFAULT_TASK_NAME = "AnonymousMCQATask";
    private final Odps odps;
    private InstanceTunnel instanceTunnel;
    private final List<String> log;
    private final boolean useInstanceTunnel;
    private final String id;
    private String defaultQuotaName;
    Map<String, String> quotaHeaderMap = new ConcurrentHashMap<String, String>();
    QueryInfo queryInfo = null;
    private final boolean useCommandApi;
    private boolean parseSuccess = false;
    private final boolean odpsNamespaceSchema;
    private final String taskName;
    private final SQLExecutorPool pool;
    private final int logviewVersion;

    public SQLExecutorImpl(SQLExecutorBuilder builder) throws OdpsException {
        this.defaultQuotaName = builder.getQuotaName();
        this.odps = builder.getOdps().clone();
        this.odps.setTunnelEndpoint(builder.getTunnelEndpoint());
        this.useInstanceTunnel = builder.isUseInstanceTunnel();
        if (this.useInstanceTunnel) {
            this.instanceTunnel = new InstanceTunnel(this.odps);
            if (builder.getTunnelSocketTimeout() >= 0) {
                this.instanceTunnel.getConfig().setSocketConnectTimeout(builder.getTunnelSocketTimeout());
            }
            if (builder.getTunnelReadTimeout() >= 0) {
                this.instanceTunnel.getConfig().setSocketTimeout(builder.getTunnelReadTimeout());
            }
        }
        this.log = new ArrayList<String>();
        this.id = UUID.randomUUID().toString();
        if (StringUtils.isNotBlank((String)builder.getQuotaName())) {
            this.loadQuota(this.defaultQuotaName, builder.getRegionId(), builder.getQuota());
        }
        this.log.add("Init MCQA 2.0 successfully, default quota name: " + this.defaultQuotaName);
        this.odpsNamespaceSchema = builder.isOdpsNamespaceSchema();
        this.useCommandApi = builder.isUseCommandApi();
        this.taskName = StringUtils.isNullOrEmpty((String)builder.getTaskName()) ? DEFAULT_TASK_NAME : builder.getTaskName();
        this.pool = builder.getPool();
        this.logviewVersion = builder.getLogviewVersion();
        if (builder.getRecoverInstance() != null) {
            this.queryInfo = new QueryInfo("unknown", null, ExecuteMode.INTERACTIVE);
            this.queryInfo.setInstance(builder.getRecoverInstance(), ExecuteMode.INTERACTIVE, null, null);
            this.queryInfo.setSelect(true);
        }
    }

    private void loadQuota(String quotaNickName, String regionId, Quota quota) throws OdpsException {
        if (this.quotaHeaderMap.containsKey(quotaNickName)) {
            return;
        }
        if (quota == null) {
            quota = this.odps.quotas().getWlmQuota(this.odps.getDefaultProject(), quotaNickName, regionId);
        }
        if (!quota.isInteractiveQuota()) {
            throw new OdpsException("Quota name: " + quotaNickName + " , is not interactive quota.");
        }
        String mcqaConnectionHeader = quota.getMcqaConnHeader();
        this.quotaHeaderMap.put(quotaNickName, mcqaConnectionHeader);
    }

    @Override
    public void run(String sql, Map<String, String> hint) throws OdpsException {
        Command command;
        String useQuotaName = this.defaultQuotaName;
        if (hint == null) {
            hint = new HashMap<String, String>();
        } else if ((hint = new HashMap<String, String>(hint)).containsKey("odps.task.wlm.quota")) {
            useQuotaName = hint.get("odps.task.wlm.quota");
            this.loadQuota(useQuotaName, null, null);
        }
        if (useQuotaName == null || !this.quotaHeaderMap.containsKey(useQuotaName)) {
            throw new IllegalArgumentException("Interactive quota must be set, you can use hint 'odps.task.wlm.quota=xxx' or init SQLExecutor with quota name.");
        }
        String mcqaQueryHeader = this.quotaHeaderMap.get(useQuotaName);
        this.queryInfo = new QueryInfo(sql, hint, ExecuteMode.INTERACTIVE);
        this.queryInfo.setCommandInfo(new CommandInfo(sql, hint));
        if (this.useCommandApi && (command = CommandUtil.parseCommand(sql)) != null) {
            this.queryInfo.getCommandInfo().setCommand(command);
            this.queryInfo.getCommandInfo().setOdpsNamespaceSchema(this.odpsNamespaceSchema);
            if (!command.isSync()) {
                command.run(this.odps, this.queryInfo.getCommandInfo());
            }
            this.parseSuccess = true;
            return;
        }
        this.parseSuccess = false;
        Instance currentInstance = SQLTask.run(this.odps, this.odps.getDefaultProject(), sql, this.taskName, hint, null, null, mcqaQueryHeader);
        this.queryInfo.setInstance(currentInstance, ExecuteMode.INTERACTIVE, null, null);
        this.queryInfo.setSelect(this.isSelect(sql));
        this.log.add("Successfully submitted MCQA 2.0 Job, ID: " + currentInstance.getId() + ", Quota name: " + useQuotaName);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public String getQueryId() {
        if (this.queryInfo != null) {
            return this.queryInfo.getInstance().getId();
        }
        return null;
    }

    @Override
    public int getSubqueryId() {
        return -1;
    }

    @Override
    public String getLogView() {
        try {
            if (this.queryInfo != null && this.queryInfo.getInstance() != null) {
                return new LogView(this.odps, this.logviewVersion).generateLogView(this.queryInfo.getInstance(), 168L);
            }
        }
        catch (OdpsException e) {
            return null;
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void cancel() throws OdpsException {
        block3: {
            if (this.queryInfo != null) {
                Instance instance = this.queryInfo.getInstance();
                try {
                    instance.stop();
                }
                catch (OdpsException e) {
                    if ("InvalidStateSetting".equals(e.getErrorCode())) break block3;
                    throw e;
                }
            }
        }
    }

    @Override
    public Instance getInstance() {
        if (this.queryInfo != null) {
            return this.queryInfo.getInstance();
        }
        return null;
    }

    @Override
    public List<Instance.StageProgress> getProgress() throws OdpsException {
        if (this.queryInfo != null) {
            return this.queryInfo.getInstance().getTaskProgress(this.taskName);
        }
        return null;
    }

    @Override
    public List<String> getExecutionLog() {
        ArrayList<String> executionLog = new ArrayList<String>(this.log);
        this.log.clear();
        return executionLog;
    }

    @Override
    public String getSummary() throws OdpsException {
        if (this.queryInfo == null || this.queryInfo.getInstance() == null) {
            return null;
        }
        try {
            return SQLExecutorImpl.getTaskSummaryV1(this.odps, this.queryInfo.getInstance(), this.taskName);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    private static String getTaskSummaryV1(Odps odps, Instance i, String taskName) throws Exception {
        RestClient client = odps.getRestClient();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("summary", null);
        params.put("taskname", taskName);
        String queryString = "/projects/" + i.getProject() + "/instances/" + i.getId();
        Response result = client.request(queryString, "GET", params, null, null);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(new String(result.getBody(), StandardCharsets.UTF_8));
        return rootNode.path("mapReduce").path("summary").asText();
    }

    @Override
    public List<Record> getResult() throws OdpsException, IOException {
        return this.getResult(null);
    }

    @Override
    public List<Record> getResult(Long countLimit) throws OdpsException, IOException {
        return this.getResult(countLimit, null);
    }

    @Override
    public List<Record> getResult(Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        return this.getResult(null, countLimit, sizeLimit);
    }

    @Override
    public List<Record> getResult(Long offset, Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        return this.getResult(offset, countLimit, sizeLimit, false);
    }

    @Override
    public List<Record> getResult(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (this.parseSuccess) {
            return this.getCommandResult(offset, countLimit, sizeLimit, limitEnabled);
        }
        if (!this.useInstanceTunnel && offset != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (this.useInstanceTunnel) {
            return this.getResultByInstanceTunnel(offset, countLimit, sizeLimit, limitEnabled);
        }
        return this.getResultDirectly();
    }

    private List<Record> getCommandResult(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("illegal argument. offset = " + offset);
        }
        if (countLimit != null && countLimit < 0L) {
            throw new IllegalArgumentException("illegal argument. countLimit = " + countLimit);
        }
        Command command = this.queryInfo.getCommandInfo().getCommand();
        if (command.isSync()) {
            RecordIter recordIterator = command.run(this.odps, this.queryInfo.getCommandInfo());
            if (recordIterator == null) {
                return Collections.emptyList();
            }
            recordIterator.setCountLimit(countLimit == null ? -1L : countLimit);
            recordIterator.setOffset(offset == null ? 0L : offset);
            ArrayList<Record> records = new ArrayList<Record>();
            while (recordIterator.hasNext()) {
                Record record = recordIterator.next();
                records.add(record);
            }
            return records;
        }
        Instance instance = this.queryInfo.getCommandInfo().getInstance();
        instance.waitForSuccess();
        instance = this.queryInfo.getCommandInfo().getInstance();
        String res = instance.getTaskResults().get(this.queryInfo.getCommandInfo().getTaskName());
        return CommandUtil.toRecord(res, command.getResultHeaders().get(0));
    }

    private List<Record> getResultByInstanceTunnel(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        ResultSet resultSet = this.getResultSetByInstanceTunnel(offset, countLimit, sizeLimit, limitEnabled);
        ArrayList<Record> records = new ArrayList<Record>();
        while (resultSet.hasNext()) {
            records.add(resultSet.next());
        }
        return records;
    }

    private List<Record> getResultDirectly() throws OdpsException {
        String resultStr = this.getResultString();
        if (resultStr != null) {
            if (this.queryInfo.isSelect()) {
                try {
                    return SQLTask.parseCsvRecord(resultStr);
                }
                catch (Exception e) {
                    throw new OdpsException(resultStr, e);
                }
            }
            return CommandUtil.toRecord(resultStr, "Info");
        }
        return new ArrayList<Record>();
    }

    private String getResultString() throws OdpsException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        Instance currentInstance = this.queryInfo.getInstance();
        if (currentInstance.isSync()) {
            return this.getSyncResultStr();
        }
        return currentInstance.waitForTerminatedAndGetResult();
    }

    private String getSyncResultStr() throws OdpsException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        Instance currentInstance = this.queryInfo.getInstance();
        Instance.InstanceResultModel.TaskResult taskResult = currentInstance.getRawTaskResults().get(0);
        Instance.TaskStatus.Status taskStatus = Instance.TaskStatus.Status.valueOf(taskResult.getStatus().toUpperCase());
        if (taskStatus == Instance.TaskStatus.Status.FAILED) {
            throw new OdpsException(taskResult.getResult().getString());
        }
        if (taskStatus != Instance.TaskStatus.Status.SUCCESS) {
            throw new OdpsException("Status=" + taskResult.getStatus() + ", Result=" + taskResult.getResult().getString());
        }
        return taskResult.getResult().getString();
    }

    @Override
    public ResultSet getResultSet() throws OdpsException, IOException {
        return this.getResultSet(null);
    }

    @Override
    public ResultSet getResultSet(Long countLimit) throws OdpsException, IOException {
        return this.getResultSet(countLimit, null);
    }

    @Override
    public ResultSet getResultSet(Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        return this.getResultSet(null, countLimit, sizeLimit);
    }

    @Override
    public ResultSet getResultSet(Long offset, Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        return this.getResultSet(offset, countLimit, sizeLimit, false);
    }

    @Override
    public ResultSet getResultSet(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (this.parseSuccess) {
            return this.getCommandResultSet(offset, countLimit, sizeLimit, limitEnabled);
        }
        if (!this.useInstanceTunnel && offset != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (this.useInstanceTunnel) {
            return this.getResultSetByInstanceTunnel(offset, countLimit, sizeLimit, limitEnabled);
        }
        return this.getResultSetDirectly();
    }

    private ResultSet getCommandResultSet(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("illegal argument. offset = " + offset);
        }
        if (countLimit != null && countLimit < 0L) {
            throw new IllegalArgumentException("illegal argument. countLimit = " + countLimit);
        }
        Command command = this.queryInfo.getCommandInfo().getCommand();
        if (command.isSync()) {
            RecordIter recordIterator = command.run(this.odps, this.queryInfo.getCommandInfo());
            if (recordIterator == null) {
                return new ResultSet(new InMemoryRecordIterator(new ArrayList<Record>()), new TableSchema(), 0L);
            }
            recordIterator.setCountLimit(countLimit == null ? -1L : countLimit);
            recordIterator.setOffset(offset == null ? 0L : offset);
            TableSchema schema = new TableSchema();
            schema.setColumns(Arrays.asList(recordIterator.getColumns()));
            return new ResultSet(recordIterator, schema, -1L);
        }
        Instance instance = this.queryInfo.getCommandInfo().getInstance();
        instance.waitForSuccess();
        instance = this.queryInfo.getCommandInfo().getInstance();
        String res = instance.getTaskResults().get(this.queryInfo.getCommandInfo().getTaskName());
        List<Record> records = CommandUtil.toRecord(res, command.getResultHeaders().get(0));
        TableSchema schema = new TableSchema();
        schema.setColumns(Arrays.asList(records.get(0).getColumns()));
        return new ResultSet(records.iterator(), schema, records.size());
    }

    private ResultSet getResultSetDirectly() throws OdpsException {
        String resultStr = this.getResultString();
        if (!StringUtils.isNullOrEmpty((String)resultStr)) {
            if (this.queryInfo.isSelect()) {
                CSVRecordParser.ParseResult parseResult;
                try {
                    parseResult = CSVRecordParser.parse(resultStr);
                }
                catch (Exception e) {
                    throw new OdpsException(resultStr);
                }
                List<Record> records = parseResult.getRecords();
                return new ResultSet(new InMemoryRecordIterator(records), parseResult.getSchema(), records.size());
            }
            List<Record> records = CommandUtil.toRecord(resultStr, "Info");
            TableSchema schema = new TableSchema();
            schema.setColumns(Arrays.asList(records.get(0).getColumns()));
            return new ResultSet(new InMemoryRecordIterator(records), schema, records.size());
        }
        return new ResultSet(new InMemoryRecordIterator(new ArrayList<Record>()), new TableSchema(), 0L);
    }

    private ResultSet getResultSetByInstanceTunnel(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        if (this.queryInfo.isSelect()) {
            this.queryInfo.getInstance().waitForTerminated(100L, true);
            InstanceTunnel.DownloadSession downloadSession = null;
            try {
                downloadSession = this.instanceTunnel.createDownloadSession(this.odps.getDefaultProject(), this.queryInfo.getInstance().getId(), limitEnabled);
            }
            catch (TunnelException e) {
                if (e.getErrorCode().equals("InstanceTypeNotSupported") || e.getErrorMsg().contains("Non select query not supported")) {
                    this.queryInfo.setSelect(false);
                    return this.getResultSetByInstanceTunnel(offset, countLimit, sizeLimit, limitEnabled);
                }
                if (e.getErrorCode().equals("TaskFailed")) {
                    this.queryInfo.getInstance().waitForSuccess();
                }
                throw e;
            }
            ArrayList<Record> records = new ArrayList<Record>();
            TableSchema schema = downloadSession.getSchema();
            if (downloadSession.getRecordCount() == 0L) {
                return new ResultSet(new InMemoryRecordIterator(records), schema, 0L);
            }
            try (TunnelRecordReader reader = downloadSession.openRecordReader(offset == null ? 0L : offset, countLimit == null ? downloadSession.getRecordCount() : countLimit.longValue(), sizeLimit == null ? Long.MAX_VALUE : sizeLimit);){
                while (true) {
                    Record record = reader.read();
                    if (sizeLimit != null && sizeLimit > 0L && reader.getTotalBytes() > sizeLimit) {
                        throw new IllegalArgumentException("InvalidArgument: sizeLimit, fetched data is larger than limit size");
                    }
                    if (record == null) {
                        break;
                    }
                    records.add(record);
                }
            }
            return new ResultSet(new InMemoryRecordIterator(records), schema, records.size());
        }
        this.queryInfo.getInstance().waitForSuccess();
        Map<String, String> results = this.queryInfo.getInstance().getTaskResults();
        String selectResult = results.get(this.taskName);
        if (StringUtils.isNullOrEmpty((String)selectResult)) {
            return new ResultSet(new InMemoryRecordIterator(new ArrayList<Record>()), new TableSchema(), 0L);
        }
        List<Record> records = CommandUtil.toRecord(selectResult, "Info");
        TableSchema schema = new TableSchema();
        schema.setColumns(Arrays.asList(records.get(0).getColumns()));
        return new ResultSet(new InMemoryRecordIterator(records), schema, records.size());
    }

    @Override
    public boolean hasResultSet() {
        return SqlParserUtil.hasResultSet(this.queryInfo.getSql());
    }

    @Override
    public boolean isRunningInInteractiveMode() {
        return true;
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.releaseExecutor(this);
        }
    }

    @Override
    public boolean isUseInstanceTunnel() {
        return this.useInstanceTunnel;
    }

    public boolean isSelect(String sql) throws OdpsException {
        try {
            return SqlParserUtil.isSelect(sql);
        }
        catch (SQLException e) {
            throw new OdpsException("Sql isSelect failed", e);
        }
    }
}

