/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CommandApi {
    Odps odps;
    CommandInfo commandInfo;
    boolean parseSuccess;

    public CommandApi(Odps odps) {
        this.odps = odps;
    }

    public void init() {
        this.commandInfo = null;
        this.parseSuccess = false;
    }

    public void run(String commandText) throws OdpsException {
        this.run(commandText, new HashMap<String, String>(), false);
    }

    public void run(String commandText, boolean odpsNamespaceSchema) throws OdpsException {
        this.run(commandText, new HashMap<String, String>(), odpsNamespaceSchema);
    }

    public void run(String commandText, Map<String, String> settings, boolean odpsNamespaceSchema) throws OdpsException {
        this.commandInfo = new CommandInfo(commandText, settings);
        Command command = CommandUtil.parseCommand(commandText);
        if (command != null) {
            this.commandInfo.setCommand(command);
            this.commandInfo.setOdpsNamespaceSchema(odpsNamespaceSchema);
            if (!command.isSync()) {
                command.run(this.odps, this.commandInfo);
            }
            this.parseSuccess = true;
        } else {
            this.parseSuccess = false;
        }
    }

    public boolean isParseSuccess() {
        return this.parseSuccess;
    }

    public boolean isOdpsCommand(String commandText) {
        return CommandUtil.parseCommand(commandText) != null;
    }

    public boolean hasResultSet() {
        return this.parseSuccess;
    }

    public ResultSet getResultSet() throws OdpsException {
        return this.getCommandResultSet(null, null);
    }

    public ResultSet getResultSet(Long countLimit) throws OdpsException {
        return this.getCommandResultSet(null, countLimit);
    }

    public ResultSet getResultSet(Long offset, Long countLimit) throws OdpsException {
        return this.getCommandResultSet(offset, countLimit);
    }

    private ResultSet getCommandResultSet(Long offset, Long countLimit) throws OdpsException {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("illegal argument. offset = " + offset);
        }
        if (countLimit != null && countLimit < 0L) {
            throw new IllegalArgumentException("illegal argument. countLimit = " + countLimit);
        }
        Command command = this.commandInfo.getCommand();
        if (command.isSync()) {
            RecordIter recordIterator = command.run(this.odps, this.commandInfo);
            if (recordIterator == null) {
                return this.newEmptyResultSet();
            }
            recordIterator.setCountLimit(countLimit == null ? -1L : countLimit);
            recordIterator.setOffset(offset == null ? 0L : offset);
            TableSchema schema = new TableSchema();
            schema.setColumns(Arrays.asList(recordIterator.getColumns()));
            return new ResultSet(recordIterator, schema, -1L);
        }
        Instance instance = this.commandInfo.getInstance();
        instance.waitForSuccess();
        instance = this.commandInfo.getInstance();
        String res = instance.getTaskResults().get(this.commandInfo.getTaskName());
        List<Record> records = CommandUtil.toRecord(res, command.getResultHeaders().get(0));
        TableSchema schema = new TableSchema();
        schema.setColumns(Arrays.asList(records.get(0).getColumns()));
        return new ResultSet(records.iterator(), schema, records.size());
    }

    public List<Record> getResult() throws OdpsException {
        return this.getCommandResult(null, null);
    }

    public List<Record> getResult(Long countLimit) throws OdpsException {
        return this.getCommandResult(null, countLimit);
    }

    public List<Record> getResult(Long offset, Long countLimit) throws OdpsException {
        return this.getCommandResult(offset, countLimit);
    }

    private List<Record> getCommandResult(Long offset, Long countLimit) throws OdpsException {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("illegal argument. offset = " + offset);
        }
        if (countLimit != null && countLimit < 0L) {
            throw new IllegalArgumentException("illegal argument. countLimit = " + countLimit);
        }
        Command command = this.commandInfo.getCommand();
        if (command.isSync()) {
            RecordIter recordIterator = command.run(this.odps, this.commandInfo);
            if (recordIterator == null) {
                return Collections.emptyList();
            }
            recordIterator.setCountLimit(countLimit == null ? -1L : countLimit);
            recordIterator.setOffset(offset == null ? 0L : offset);
            ArrayList<Record> records = new ArrayList<Record>();
            while (recordIterator.hasNext()) {
                Record record = recordIterator.next();
                records.add(record);
            }
            return records;
        }
        Instance instance = this.commandInfo.getInstance();
        instance.waitForSuccess();
        instance = this.commandInfo.getInstance();
        String res = instance.getTaskResults().get(this.commandInfo.getTaskName());
        return CommandUtil.toRecord(res, command.getResultHeaders().get(0));
    }

    private ResultSet newEmptyResultSet() {
        return new ResultSet(new EmptyRecordSetIterator(), new TableSchema(), 0L);
    }

    class EmptyRecordSetIterator
    implements Iterator<Record> {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Record next() {
            return null;
        }
    }
}

