/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.core.Instance;
import com.aliyun.odps.simpleframework.xml.strategy.Value;
import com.aliyun.odps.simpleframework.xml.util.Cache;
import com.aliyun.odps.simpleframework.xml.util.ConcurrentCache;
import java.lang.reflect.Constructor;

class InstanceFactory {
    private final Cache<Constructor> cache = new ConcurrentCache<Constructor>();

    public Instance getInstance(Value value) {
        return new ValueInstance(value);
    }

    public Instance getInstance(Class type) {
        return new ClassInstance(type);
    }

    protected Object getObject(Class type) throws Exception {
        Constructor method = this.cache.fetch(type);
        if (method == null) {
            method = type.getDeclaredConstructor(new Class[0]);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            this.cache.cache(type, method);
        }
        return method.newInstance(new Object[0]);
    }

    private class ClassInstance
    implements Instance {
        private Object value;
        private Class type;

        public ClassInstance(Class type) {
            this.type = type;
        }

        @Override
        public Object getInstance() throws Exception {
            if (this.value == null) {
                this.value = InstanceFactory.this.getObject(this.type);
            }
            return this.value;
        }

        @Override
        public Object setInstance(Object value) throws Exception {
            this.value = value;
            return this.value;
        }

        @Override
        public Class getType() {
            return this.type;
        }

        @Override
        public boolean isReference() {
            return false;
        }
    }

    private class ValueInstance
    implements Instance {
        private final Value value;
        private final Class type;

        public ValueInstance(Value value) {
            this.type = value.getType();
            this.value = value;
        }

        @Override
        public Object getInstance() throws Exception {
            if (this.value.isReference()) {
                return this.value.getValue();
            }
            Object object = InstanceFactory.this.getObject(this.type);
            if (this.value != null) {
                this.value.setValue(object);
            }
            return object;
        }

        @Override
        public Object setInstance(Object object) {
            if (this.value != null) {
                this.value.setValue(object);
            }
            return object;
        }

        @Override
        public boolean isReference() {
            return this.value.isReference();
        }

        @Override
        public Class getType() {
            return this.type;
        }
    }
}

