/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.expression;

import com.aliyun.odps.data.GenerateExpression;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.table.utils.Preconditions;
import com.aliyun.odps.utils.OdpsCommonUtils;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class TruncTime
implements GenerateExpression {
    public static final String NAME = "trunc_time";
    private static final String NULL_VALUE = "__NULL__";
    private static final long MIN_EPOCH_MILLIS = -315619200000L;
    private final String dateColumnName;
    private final DatePart datePart;
    private DateTimeFormatter formatter;

    public TruncTime(String dateColumnName, DatePart datePart) {
        Preconditions.checkString(dateColumnName, "dateColumnName in trunc_time expression");
        this.dateColumnName = dateColumnName;
        this.datePart = datePart;
        this.initFormatter();
    }

    public TruncTime(String dateColumnName, String constant) {
        Preconditions.checkString(constant, "dateColumnName in trunc_time expression");
        Preconditions.checkString(dateColumnName, "dateColumnName in trunc_time expression");
        this.dateColumnName = dateColumnName;
        this.datePart = DatePart.valueOf(constant.toUpperCase());
        this.initFormatter();
    }

    private void initFormatter() {
        switch (this.datePart) {
            case YEAR: {
                this.formatter = DateTimeFormatter.ofPattern("yyyy");
                break;
            }
            case MONTH: {
                this.formatter = DateTimeFormatter.ofPattern("yyyy-MM");
                break;
            }
            case DAY: {
                this.formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                break;
            }
            case HOUR: {
                this.formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown date part: " + (Object)((Object)this.datePart));
            }
        }
    }

    public String toString() {
        return "trunc_time(" + OdpsCommonUtils.quoteRef(this.dateColumnName) + ", '" + this.datePart.name() + "')";
    }

    public String generate(Record record) {
        Object data = record.get(this.dateColumnName);
        if (data == null) {
            return NULL_VALUE;
        }
        if (data instanceof Timestamp) {
            return this.truncEpochMillis(((Timestamp)data).getTime());
        }
        if (data instanceof Instant) {
            return this.truncEpochMillis(((Instant)data).toEpochMilli());
        }
        if (data instanceof LocalDateTime) {
            return this.truncEpochMillis(((LocalDateTime)data).toEpochSecond(ZoneOffset.UTC) * 1000L);
        }
        if (data instanceof ZonedDateTime) {
            return this.truncEpochMillis(((ZonedDateTime)data).toEpochSecond() * 1000L);
        }
        if (data instanceof java.sql.Date) {
            return this.truncEpochMillis(((java.sql.Date)data).getTime());
        }
        if (data instanceof Date) {
            return this.truncEpochMillis(((Date)data).getTime());
        }
        if (data instanceof LocalDate) {
            return this.truncEpochMillis(((LocalDate)data).toEpochDay() * 86400L * 1000L);
        }
        throw new IllegalArgumentException("Unknown data type: " + data.getClass());
    }

    private String truncEpochMillis(long epochMillis) {
        if (epochMillis < -315619200000L) {
            return this.minGenerateValue();
        }
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(epochMillis / 1000L, 0, ZoneOffset.UTC);
        localDateTime = localDateTime.withMinute(0).withSecond(0);
        return localDateTime.format(this.formatter);
    }

    private String minGenerateValue() {
        switch (this.datePart) {
            case YEAR: {
                return "1959";
            }
            case MONTH: {
                return "1959-12";
            }
            case DAY: {
                return "1959-12-31";
            }
            case HOUR: {
                return "1959-12-31 23:00:00";
            }
        }
        throw new IllegalArgumentException("Unknown date part: " + (Object)((Object)this.datePart));
    }

    public static enum DatePart {
        YEAR,
        MONTH,
        DAY,
        HOUR;

    }
}

