/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Volume;
import com.aliyun.odps.VolumeFilter;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Volumes
implements Iterable<Volume> {
    public static final String EXTERNAL_VOLUME_LOCATION_KEY = "external.location";
    public static final String EXTERNAL_VOLUME_ROLEARN_KEY = "odps.properties.rolearn";
    private RestClient client;

    Volumes(RestClient client) {
        this.client = client;
    }

    public Volume get(String volumeName) {
        return this.get(this.getDefaultProjectName(), volumeName);
    }

    public Volume get(String projectName, String volumeName) {
        Volume.VolumeModel model = new Volume.VolumeModel();
        model.name = volumeName;
        Volume t = new Volume(model, projectName, this.client);
        return t;
    }

    public boolean exists(String volumeName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), volumeName);
    }

    public boolean exists(String projectName, String volumeName) throws OdpsException {
        try {
            Volume v = this.get(projectName, volumeName);
            v.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    public Iterator<Volume> iterator() {
        return this.iterator(this.getDefaultProjectName(), null);
    }

    public Iterator<Volume> iterator(String projectName) {
        return this.iterator(projectName, null);
    }

    public Iterator<Volume> iterator(VolumeFilter filter) {
        return this.iterator(this.getDefaultProjectName(), filter);
    }

    public Iterator<Volume> iterator(final String projectName, final VolumeFilter filter) {
        return new ListIterator<Volume>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<Volume> list() {
                ArrayList<Volume> volumes = new ArrayList<Volume>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                if (filter != null && filter.getName() != null) {
                    this.params.put("name", filter.getName());
                }
                String resource = ResourceBuilder.buildVolumesResource(projectName);
                try {
                    ListVolumesResponse resp = Volumes.this.client.request(ListVolumesResponse.class, resource, "GET", this.params);
                    for (Volume.VolumeModel model : resp.volumes) {
                        Volume t = new Volume(model, projectName, Volumes.this.client);
                        volumes.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return volumes;
            }
        };
    }

    @Deprecated
    public void create(String volumeName, String comment) throws OdpsException {
        this.create(this.client.getDefaultProject(), volumeName, comment);
    }

    @Deprecated
    public void create(String projectName, String volumeName, String comment) throws OdpsException {
        if (projectName == null || volumeName == null) {
            throw new IllegalArgumentException();
        }
        String resource = ResourceBuilder.buildVolumesResource(projectName);
        Volume.VolumeModel model = new Volume.VolumeModel();
        model.name = volumeName;
        model.comment = comment;
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(model);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.client.stringRequest(resource, "POST", null, headers, xml);
    }

    public void create(String volumeName, String comment, Volume.Type type) throws OdpsException {
        this.create(this.client.getDefaultProject(), volumeName, comment, type);
    }

    public void create(String projectName, String volumeName, String comment, Volume.Type type) throws OdpsException {
        this.create(projectName, volumeName, comment, type, null);
    }

    public void create(String projectName, String volumeName, String comment, Volume.Type type, Long lifecycle) throws OdpsException {
        if (projectName == null || volumeName == null) {
            throw new IllegalArgumentException();
        }
        String resource = ResourceBuilder.buildVolumesResource(projectName);
        Volume.VolumeModel model = new Volume.VolumeModel();
        model.name = volumeName;
        model.comment = comment;
        if (type != null) {
            model.type = type.name().toLowerCase();
        }
        if (lifecycle != null) {
            model.lifecycle = lifecycle;
        }
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(model);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.client.stringRequest(resource, "POST", null, headers, xml);
    }

    public void update(Volume volume) throws OdpsException {
        this.update(this.getDefaultProjectName(), volume);
    }

    public void update(String projectName, Volume volume) throws OdpsException {
        if (projectName == null || volume == null) {
            throw new IllegalArgumentException();
        }
        String resource = ResourceBuilder.buildVolumeResource(projectName, volume.getName());
        String xml = null;
        Volume.VolumeModel model = new Volume.VolumeModel();
        model.lifecycle = volume.getLifecycle();
        try {
            xml = SimpleXmlUtils.marshal(model);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.client.stringRequest(resource, "PUT", null, headers, xml);
    }

    public void delete(String volumeName) throws OdpsException {
        this.delete(this.client.getDefaultProject(), volumeName);
    }

    public void delete(String projectName, String volumeName) throws OdpsException {
        if (projectName == null || volumeName == null) {
            throw new IllegalArgumentException();
        }
        String resource = ResourceBuilder.buildVolumeResource(projectName, volumeName);
        this.client.request(resource, "DELETE", null, null, null);
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    public void create(VolumeBuilder builder) throws OdpsException {
        if (builder.type == null || StringUtils.isNullOrEmpty((String)builder.model.name)) {
            throw new IllegalArgumentException("Volume type or volume name is empty.");
        }
        if (Volume.Type.EXTERNAL == builder.type && StringUtils.isNullOrEmpty((String)builder.extLocation)) {
            throw new IllegalArgumentException("External location is empty for external volume.");
        }
        if (StringUtils.isNullOrEmpty((String)builder.projectName)) {
            builder.projectName = this.getDefaultProjectName();
        }
        String resource = ResourceBuilder.buildVolumesResource(builder.projectName);
        Volume.VolumeModel model = builder.model;
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(model);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        HashMap<String, String> params = null;
        if (builder.autoMkdir != null && builder.autoMkdir.booleanValue()) {
            params = new HashMap<String, String>();
            params.put("autoMkDir", null);
        }
        if (builder.accelerate != null && builder.accelerate.booleanValue()) {
            params = new HashMap();
            params.put("accelerate", null);
        }
        this.client.stringRequest(resource, "POST", params, headers, xml);
    }

    public static class VolumeBuilder {
        Volume.VolumeModel model = new Volume.VolumeModel();
        String projectName;
        Volume.Type type;
        String extLocation;
        Boolean autoMkdir;
        Boolean accelerate;

        public VolumeBuilder project(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public VolumeBuilder volumeName(String volumeName) {
            this.model.name = volumeName;
            return this;
        }

        public VolumeBuilder type(Volume.Type type) {
            this.model.type = type.name().toLowerCase();
            this.type = type;
            return this;
        }

        public VolumeBuilder comment(String comment) {
            this.model.comment = comment;
            return this;
        }

        public VolumeBuilder lifecycle(long lifecycle) {
            this.model.lifecycle = lifecycle;
            return this;
        }

        public VolumeBuilder extLocation(String location) {
            this.extLocation = location;
            this.addProperty(Volumes.EXTERNAL_VOLUME_LOCATION_KEY, location);
            return this;
        }

        public VolumeBuilder properties(Map<String, String> props) {
            this.model.properties = props;
            return this;
        }

        public VolumeBuilder autoMkDir(boolean autoMkdir) {
            this.autoMkdir = autoMkdir;
            return this;
        }

        public VolumeBuilder accelerate(boolean accelerate) {
            this.accelerate = accelerate;
            return this;
        }

        public VolumeBuilder addProperty(String key, String value) {
            if (this.model.properties == null) {
                this.model.properties = new HashMap<String, String>();
            }
            this.model.properties.put(key, value);
            return this;
        }
    }

    @Root(name="Volumes", strict=false)
    private static class ListVolumesResponse {
        @ElementList(entry="Volume", inline=true, required=false)
        private List<Volume.VolumeModel> volumes = new ArrayList<Volume.VolumeModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;

        private ListVolumesResponse() {
        }
    }
}

