/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.VolumeFile;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VolumePartition
extends LazyLoad {
    private VolumePartitionModel model;
    private String project;
    private String volume;
    private String name;
    private RestClient client;

    VolumePartition(VolumePartitionModel model, String project, String volume, RestClient client) {
        this.model = model;
        this.project = project;
        this.volume = volume;
        this.name = model.name;
        this.client = client;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildVolumePartitionResource(this.project, this.volume, this.name);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("meta", null);
        Response resp = this.client.request(resource, "GET", params, null, null);
        try {
            this.model = SimpleXmlUtils.unmarshal(resp, VolumePartitionModel.class);
            this.model.lastModifiedTime = DateUtils.parseRfc822Date(resp.getHeader("Last_Modified"));
            this.model.createdTime = DateUtils.parseRfc822Date(resp.getHeader("x-odps-creation-time"));
            this.model.owner = resp.getHeader("x-odps-owner");
        }
        catch (Exception e) {
            throw new OdpsException("Can't bind xml to " + VolumePartitionModel.class, e);
        }
        this.setLoaded(true);
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        if (this.model.comment == null) {
            this.lazyLoad();
        }
        return this.model.comment;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getCreatedTime() {
        if (this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public Date getLastModifiedTime() {
        if (this.model.lastModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastModifiedTime;
    }

    public long getLength() {
        if (this.model.length == null) {
            this.lazyLoad();
        }
        return this.model.length;
    }

    public int getFileCount() {
        if (this.model.fileNumber == null) {
            this.lazyLoad();
        }
        return this.model.fileNumber;
    }

    public Iterator<VolumeFile> getFileIterator() {
        return this.getFileIterator(null);
    }

    public Iterator<VolumeFile> getFileIterator(String path) {
        return new PathListIterator(path);
    }

    class PathListIterator
    extends ListIterator<VolumeFile> {
        String path;
        Map<String, String> params = new HashMap<String, String>();

        PathListIterator(String path) {
            this.path = path;
        }

        @Override
        protected List<VolumeFile> list() {
            ArrayList<VolumeFile> files = new ArrayList<VolumeFile>();
            this.params.put("expectmarker", "true");
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                return null;
            }
            if (this.path != null) {
                this.params.put("path", this.path);
            }
            String resource = ResourceBuilder.buildVolumePartitionResource(VolumePartition.this.project, VolumePartition.this.volume, VolumePartition.this.name);
            try {
                ListFilesResponse resp = VolumePartition.this.client.request(ListFilesResponse.class, resource, "GET", this.params);
                for (VolumeFile.VolumeFileModel item : resp.items) {
                    VolumeFile t = new VolumeFile(item);
                    files.add(t);
                }
                this.params.put("marker", resp.marker);
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return files;
        }
    }

    @Root(name="Items", strict=false)
    private static class ListFilesResponse {
        @ElementList(entry="Item", inline=true, required=false)
        private List<VolumeFile.VolumeFileModel> items = new ArrayList<VolumeFile.VolumeFileModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;

        private ListFilesResponse() {
        }
    }

    @Root(name="Meta", strict=false)
    static class VolumePartitionModel {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="Comment", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String comment;
        @Element(name="Length", required=false)
        Long length;
        @Element(name="FileNumber", required=false)
        Integer fileNumber;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createdTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastModifiedTime;

        VolumePartitionModel() {
        }
    }
}

