/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.odps.utils.StringUtils;
import java.util.HashMap;

public class LogView {
    private static final String POLICY_TYPE = "BEARER";
    private static final String HOST_DEFAULT = "http://logview.aliyun.com";
    private String logViewHost = "";
    private static final String HOST_DEFAULT_V2 = "https://maxcompute.console.aliyun.com";
    private int version = 1;
    Odps odps;

    public LogView(Odps odps) {
        this(odps, 1);
    }

    public LogView(Odps odps, int version) {
        this.odps = odps;
        this.version = version;
    }

    private String getLogviewHost() {
        if (2 == this.version) {
            return HOST_DEFAULT_V2;
        }
        if (this.odps.getLogViewHost() != null) {
            return this.odps.getLogViewHost();
        }
        RestClient restClient = this.odps.clone().getRestClient();
        try {
            String resource = "/logview/host";
            HashMap<String, String> params = new HashMap<String, String>();
            Response resp = restClient.request(resource, "GET", params, null, null);
            String logViewHost = new String(resp.getBody());
            if (StringUtils.isNullOrEmpty((String)logViewHost)) {
                return HOST_DEFAULT;
            }
            return logViewHost;
        }
        catch (Exception e) {
            return HOST_DEFAULT;
        }
    }

    public String getLogViewHost() {
        if (StringUtils.isNullOrEmpty((String)this.logViewHost)) {
            this.logViewHost = this.getLogviewHost();
        }
        return this.logViewHost;
    }

    public void setLogViewHost(String logViewHost) {
        this.logViewHost = logViewHost;
    }

    public String generateLogView(Instance instance, long hours) throws OdpsException {
        return this.generateLogView(instance, hours, null, null);
    }

    public String generateSubQueryLogView(Instance instance, int queryId, long hours) throws OdpsException {
        return this.generateLogView(instance, hours, queryId, null);
    }

    public String generateSubQueryLogView(Instance instance, int queryId, String token) throws OdpsException {
        return this.generateLogView(instance, 24L, queryId, token);
    }

    private String generateLogView(Instance instance, long hours, Integer queryId, String token) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)this.logViewHost)) {
            this.logViewHost = this.getLogviewHost();
        }
        if (1 == this.version) {
            StringBuilder urlBuilder = new StringBuilder(this.logViewHost);
            urlBuilder.append("/logview/?h=").append(this.odps.getEndpoint()).append("&p=").append(instance.getProject()).append("&i=").append(instance.getId());
            if (queryId != null) {
                urlBuilder.append("&subQuery=").append(queryId);
            }
            if (token == null) {
                token = this.generateInstanceToken(instance, hours);
            }
            urlBuilder.append("&token=").append(token);
            return urlBuilder.toString();
        }
        if (2 == this.version) {
            String url = this.logViewHost + "/" + this.odps.projects().get().getRegionId() + "/job-insights?h=" + this.odps.getEndpoint() + "&p=" + this.odps.getDefaultProject() + "&i=" + instance.getId();
            if (queryId != null) {
                url = url + "&subQuery=" + queryId;
            }
            return url;
        }
        throw new IllegalArgumentException("logview version must be 1 or 2");
    }

    public String generateInstanceToken(Instance instance, long hours) throws OdpsException {
        SecurityManager sm = this.odps.projects().get(instance.getProject()).getSecurityManager();
        return sm.generateAuthorizationToken(this.generatePolicy(instance, hours), POLICY_TYPE);
    }

    private String generatePolicy(Instance instance, long hours) {
        String policy = "{\n    \"expires_in_hours\": " + String.valueOf(hours) + ",\n    \"policy\": {\n        \"Statement\": [{\n            \"Action\": [\"odps:Read\"],\n            \"Effect\": \"Allow\",\n            \"Resource\": \"acs:odps:*:projects/" + instance.getProject() + "/instances/" + instance.getId() + "\"\n        }],\n        \"Version\": \"1\"\n    }\n}";
        return policy;
    }
}

