/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.grpc;

import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class GrpcClientInvoker {
    private final Channel channel;
    private final Object request;
    private final StreamObserver responseObserver;
    private final Class requestClass;
    private final Method method;
    private final String[] methodArgSigs;
    private final Object[] methodArgs;
    private final String serviceName;
    private final String interfaceName;
    private final Integer timeout;
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcClientInvoker.class);

    public GrpcClientInvoker(SofaRequest sofaRequest, Channel channel) {
        this.channel = channel;
        this.method = sofaRequest.getMethod();
        this.methodArgs = sofaRequest.getMethodArgs();
        this.methodArgSigs = sofaRequest.getMethodArgSigs();
        this.interfaceName = sofaRequest.getInterfaceName();
        this.serviceName = this.interfaceName.substring(0, this.interfaceName.indexOf(36));
        this.request = this.methodArgs[0];
        this.responseObserver = this.methodArgs.length == 2 ? (StreamObserver)this.methodArgs[1] : null;
        this.requestClass = ClassUtils.forName(this.methodArgSigs[0]);
        this.requestClass.cast(this.request);
        this.timeout = sofaRequest.getTimeout();
    }

    public SofaResponse invoke() {
        SofaResponse sofaResponse = new SofaResponse();
        try {
            Object response = this.invokeRequestMethod();
            sofaResponse.setAppResponse(response);
        }
        catch (SofaRpcException e) {
            sofaResponse.setErrorMsg(e.getMessage());
        }
        return sofaResponse;
    }

    private CallOptions buildCallOptions() {
        CallOptions callOptions = CallOptions.DEFAULT;
        if (this.timeout != null) {
            callOptions = callOptions.withDeadlineAfter((long)this.timeout.intValue(), TimeUnit.SECONDS);
        }
        return callOptions;
    }

    public AbstractStub getBlockingStub() {
        AbstractStub stub = null;
        try {
            Method newBlockingStubMethod = Class.forName(this.serviceName).getDeclaredMethod("newBlockingStub", Channel.class);
            newBlockingStubMethod.setAccessible(true);
            stub = (AbstractStub)newBlockingStubMethod.invoke(null, this.channel);
        }
        catch (Throwable e) {
            throw new SofaRpcException(0, e.getMessage(), e);
        }
        return stub;
    }

    public Object invokeRequestMethod() {
        Object r = null;
        try {
            Method requestMethod = Class.forName(this.interfaceName).getDeclaredMethod(this.method.getName(), Class.forName(this.methodArgSigs[0]));
            requestMethod.setAccessible(true);
            r = requestMethod.invoke((Object)this.getBlockingStub(), this.methodArgs[0]);
        }
        catch (Throwable e) {
            throw new SofaRpcException(299, e.getMessage(), e);
        }
        return r;
    }
}

