/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.tsdb;

import com.alibaba.druid.sql.repository.Schema;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.otter.canal.filter.CanalEventFilter;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ResultSetPacket;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.TableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlConnection;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.TableMetaCache;
import com.alibaba.otter.canal.parse.inbound.mysql.ddl.DdlResult;
import com.alibaba.otter.canal.parse.inbound.mysql.ddl.DruidDdlParser;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.MemoryTableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.TableMetaTSDB;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.dao.MetaHistoryDAO;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.dao.MetaHistoryDO;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.dao.MetaSnapshotDAO;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.dao.MetaSnapshotDO;
import com.alibaba.otter.canal.protocol.position.EntryPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DatabaseTableMeta
implements TableMetaTSDB {
    public static final EntryPosition INIT_POSITION = new EntryPosition("0", Long.valueOf(0L), Long.valueOf(-2L), Long.valueOf(-1L));
    private static Logger logger = LoggerFactory.getLogger(DatabaseTableMeta.class);
    private static Pattern pattern = Pattern.compile("Duplicate entry '.*' for key '*'");
    private static Pattern h2Pattern = Pattern.compile("Unique index or primary key violation");
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "[scheduler-table-meta-snapshot]");
        thread.setDaemon(true);
        return thread;
    });
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private String destination;
    private MemoryTableMeta memoryTableMeta;
    private volatile MysqlConnection connection;
    private CanalEventFilter filter;
    private CanalEventFilter blackFilter;
    private Map<String, List<String>> fieldFilterMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> fieldBlackFilterMap = new HashMap<String, List<String>>();
    private EntryPosition lastPosition;
    private boolean hasNewDdl;
    private MetaHistoryDAO metaHistoryDAO;
    private MetaSnapshotDAO metaSnapshotDAO;
    private int snapshotInterval = 24;
    private int snapshotExpire = 360;
    private ScheduledFuture<?> scheduleSnapshotFuture;

    @Override
    public boolean init(String destination) {
        if (this.initialized.compareAndSet(false, true)) {
            this.destination = destination;
            this.memoryTableMeta = new MemoryTableMeta();
            if (this.snapshotInterval > 0) {
                this.scheduleSnapshotFuture = scheduler.scheduleWithFixedDelay(() -> {
                    boolean applyResult = false;
                    try {
                        MDC.put((String)"destination", (String)destination);
                        applyResult = this.applySnapshotToDB(this.lastPosition, false);
                    }
                    catch (Throwable e) {
                        logger.error("scheudle applySnapshotToDB faield", e);
                    }
                    try {
                        MDC.put((String)"destination", (String)destination);
                        if (applyResult) {
                            this.snapshotExpire((int)TimeUnit.HOURS.toSeconds(this.snapshotExpire));
                        }
                    }
                    catch (Throwable e) {
                        logger.error("scheudle snapshotExpire faield", e);
                    }
                }, this.snapshotInterval, this.snapshotInterval, TimeUnit.HOURS);
            }
        }
        return true;
    }

    @Override
    public void destory() {
        if (this.memoryTableMeta != null) {
            this.memoryTableMeta.destory();
        }
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (IOException e) {
                logger.error("ERROR # disconnect meta connection for address:{}", (Object)this.connection.getConnector().getAddress(), (Object)e);
            }
        }
        if (this.scheduleSnapshotFuture != null) {
            this.scheduleSnapshotFuture.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableMeta find(String schema, String table) {
        this.lock.readLock().lock();
        try {
            TableMeta tableMeta = this.memoryTableMeta.find(schema, table);
            return tableMeta;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean apply(EntryPosition position, String schema, String ddl, String extra) {
        this.lock.writeLock().lock();
        try {
            if (this.memoryTableMeta.apply(position, schema, ddl, extra)) {
                this.lastPosition = position;
                this.hasNewDdl = true;
                boolean bl = this.applyHistoryToDB(position, schema, ddl, extra);
                return bl;
            }
            throw new RuntimeException("apply to memory is failed");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean rollback(EntryPosition position) {
        this.memoryTableMeta = new MemoryTableMeta();
        boolean flag = false;
        EntryPosition snapshotPosition = this.buildMemFromSnapshot(position);
        if (snapshotPosition != null) {
            this.applyHistoryOnMemory(snapshotPosition, position);
            flag = true;
        }
        if (!flag && this.dumpTableMeta(this.connection, this.filter)) {
            flag = this.applySnapshotToDB(INIT_POSITION, true);
        }
        return flag;
    }

    @Override
    public Map<String, String> snapshot() {
        return this.memoryTableMeta.snapshot();
    }

    private boolean dumpTableMeta(MysqlConnection connection, CanalEventFilter filter) {
        try {
            ResultSetPacket packet = connection.query("show databases");
            ArrayList schemas = new ArrayList();
            schemas.addAll(packet.getFieldValues());
            for (String schema : schemas) {
                Object table2;
                packet = connection.query("show full tables from `" + schema + "` where Table_type = 'BASE TABLE'");
                ArrayList<Object> tables = new ArrayList<Object>();
                for (Object table2 : packet.getFieldValues()) {
                    if ("BASE TABLE".equalsIgnoreCase((String)table2)) continue;
                    String fullName = schema + "." + (String)table2;
                    if (this.blackFilter != null && this.blackFilter.filter((Object)fullName) || filter != null && !filter.filter((Object)fullName)) continue;
                    tables.add(table2);
                }
                if (tables.isEmpty()) continue;
                StringBuilder sql = new StringBuilder();
                table2 = tables.iterator();
                while (table2.hasNext()) {
                    String table3 = (String)table2.next();
                    sql.append("show create table `" + schema + "`.`" + table3 + "`;");
                }
                List<ResultSetPacket> packets = connection.queryMulti(sql.toString());
                for (ResultSetPacket onePacket : packets) {
                    if (onePacket.getFieldValues().size() <= 1) continue;
                    String oneTableCreateSql = (String)onePacket.getFieldValues().get(1);
                    this.memoryTableMeta.apply(INIT_POSITION, schema, oneTableCreateSql, null);
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new CanalParseException(e);
        }
    }

    private boolean applyHistoryToDB(EntryPosition position, String schema, String ddl, String extra) {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("destination", this.destination);
        content.put("binlogFile", position.getJournalName());
        content.put("binlogOffest", String.valueOf(position.getPosition()));
        content.put("binlogMasterId", String.valueOf(position.getServerId()));
        content.put("binlogTimestamp", String.valueOf(position.getTimestamp()));
        content.put("useSchema", schema);
        if (content.isEmpty()) {
            throw new RuntimeException("apply failed caused by content is empty in applyHistoryToDB");
        }
        List<DdlResult> ddlResults = DruidDdlParser.parse(ddl, schema);
        if (ddlResults.size() > 0) {
            DdlResult ddlResult = ddlResults.get(0);
            content.put("sqlSchema", ddlResult.getSchemaName());
            content.put("sqlTable", ddlResult.getTableName());
            content.put("sqlType", ddlResult.getType().name());
            content.put("sqlText", ddl);
            content.put("extra", extra);
        }
        MetaHistoryDO metaDO = new MetaHistoryDO();
        try {
            BeanUtils.populate((Object)metaDO, content);
            this.metaHistoryDAO.insert(metaDO);
        }
        catch (Throwable e) {
            if (this.isUkDuplicateException(e)) {
                logger.warn("dup apply for sql : " + ddl);
            }
            throw new CanalParseException("apply history to db failed caused by : " + e.getMessage(), e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applySnapshotToDB(EntryPosition position, boolean init) {
        Map<String, String> schemaDdls = null;
        this.lock.readLock().lock();
        try {
            if (!init && !this.hasNewDdl) {
                boolean bl = false;
                return bl;
            }
            this.hasNewDdl = false;
            schemaDdls = this.memoryTableMeta.snapshot();
        }
        finally {
            this.lock.readLock().unlock();
        }
        MemoryTableMeta tmpMemoryTableMeta = new MemoryTableMeta();
        for (Map.Entry<String, String> entry : schemaDdls.entrySet()) {
            tmpMemoryTableMeta.apply(position, entry.getKey(), entry.getValue(), null);
        }
        boolean compareAll = true;
        for (Schema schema : tmpMemoryTableMeta.getRepository().getSchemas()) {
            for (String table : schema.showTables()) {
                String fullName = schema.getName() + "." + table;
                if (this.blackFilter != null && this.blackFilter.filter((Object)fullName) || this.filter != null && !this.filter.filter((Object)fullName) || this.compareTableMetaDbAndMemory(this.connection, tmpMemoryTableMeta, schema.getName(), table)) continue;
                compareAll = false;
            }
        }
        if (compareAll) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("destination", this.destination);
            hashMap.put("binlogFile", position.getJournalName());
            hashMap.put("binlogOffest", String.valueOf(position.getPosition()));
            hashMap.put("binlogMasterId", String.valueOf(position.getServerId()));
            hashMap.put("binlogTimestamp", String.valueOf(position.getTimestamp()));
            hashMap.put("data", JSON.toJSONString(schemaDdls));
            if (hashMap.isEmpty()) {
                throw new RuntimeException("apply failed caused by content is empty in applySnapshotToDB");
            }
            MetaSnapshotDO snapshotDO = new MetaSnapshotDO();
            try {
                BeanUtils.populate((Object)snapshotDO, hashMap);
                this.metaSnapshotDAO.insert(snapshotDO);
            }
            catch (Throwable e) {
                if (this.isUkDuplicateException(e)) {
                    logger.info("dup apply snapshot use position : " + position + " , just ignore");
                }
                throw new CanalParseException("apply failed caused by : " + e.getMessage(), e);
            }
            return true;
        }
        logger.error("compare failed , check log");
        return false;
    }

    private boolean compareTableMetaDbAndMemory(MysqlConnection connection, MemoryTableMeta memoryTableMeta, String schema, String table) {
        TableMeta tableMetaFromMem = memoryTableMeta.find(schema, table);
        TableMeta tableMetaFromDB = new TableMeta();
        tableMetaFromDB.setSchema(schema);
        tableMetaFromDB.setTable(table);
        String createDDL = null;
        try {
            ResultSetPacket packet = connection.query("show create table " + this.getFullName(schema, table));
            if (packet.getFieldValues().size() > 1) {
                createDDL = (String)packet.getFieldValues().get(1);
                tableMetaFromDB.setFields(TableMetaCache.parseTableMeta(schema, table, packet));
            }
        }
        catch (Throwable e) {
            try {
                connection.reconnect();
                ResultSetPacket packet = connection.query("show create table " + this.getFullName(schema, table));
                if (packet.getFieldValues().size() > 1) {
                    createDDL = (String)packet.getFieldValues().get(1);
                    tableMetaFromDB.setFields(TableMetaCache.parseTableMeta(schema, table, packet));
                }
            }
            catch (IOException e1) {
                if (e.getMessage().contains("errorNumber=1146")) {
                    logger.error("table not exist in db , pls check :" + this.getFullName(schema, table) + " , mem : " + tableMetaFromMem);
                    return false;
                }
                throw new CanalParseException(e);
            }
        }
        boolean result = DatabaseTableMeta.compareTableMeta(tableMetaFromMem, tableMetaFromDB);
        if (!result) {
            logger.error("pls submit github issue, show create table ddl:" + createDDL + " , compare failed . \n db : " + tableMetaFromDB + " \n mem : " + tableMetaFromMem);
        }
        return result;
    }

    private EntryPosition buildMemFromSnapshot(EntryPosition position) {
        try {
            MetaSnapshotDO snapshotDO = this.metaSnapshotDAO.findByTimestamp(this.destination, position.getTimestamp());
            if (snapshotDO == null) {
                return null;
            }
            String binlogFile = snapshotDO.getBinlogFile();
            Long binlogOffest = snapshotDO.getBinlogOffest();
            String binlogMasterId = snapshotDO.getBinlogMasterId();
            Long binlogTimestamp = snapshotDO.getBinlogTimestamp();
            EntryPosition snapshotPosition = new EntryPosition(binlogFile, Long.valueOf(binlogOffest == null ? 0L : binlogOffest), Long.valueOf(binlogTimestamp == null ? 0L : binlogTimestamp), Long.valueOf(binlogMasterId == null ? "-2" : binlogMasterId));
            String sqlData = snapshotDO.getData();
            JSONObject jsonObj = JSON.parseObject((String)sqlData);
            for (Map.Entry entry : jsonObj.entrySet()) {
                if (this.memoryTableMeta.apply(snapshotPosition, ObjectUtils.toString(entry.getKey()), ObjectUtils.toString(entry.getValue()), null)) continue;
                return null;
            }
            return snapshotPosition;
        }
        catch (Throwable e) {
            throw new CanalParseException("apply failed caused by : " + e.getMessage(), e);
        }
    }

    private boolean applyHistoryOnMemory(EntryPosition position, EntryPosition rollbackPosition) {
        try {
            List<MetaHistoryDO> metaHistoryDOList = this.metaHistoryDAO.findByTimestamp(this.destination, position.getTimestamp(), rollbackPosition.getTimestamp());
            if (metaHistoryDOList == null) {
                return true;
            }
            for (MetaHistoryDO metaHistoryDO : metaHistoryDOList) {
                String binlogFile = metaHistoryDO.getBinlogFile();
                Long binlogOffest = metaHistoryDO.getBinlogOffest();
                String binlogMasterId = metaHistoryDO.getBinlogMasterId();
                Long binlogTimestamp = metaHistoryDO.getBinlogTimestamp();
                String useSchema = metaHistoryDO.getUseSchema();
                String sqlData = metaHistoryDO.getSqlText();
                EntryPosition snapshotPosition = new EntryPosition(binlogFile, Long.valueOf(binlogOffest == null ? 0L : binlogOffest), Long.valueOf(binlogTimestamp == null ? 0L : binlogTimestamp), Long.valueOf(binlogMasterId == null ? "-2" : binlogMasterId));
                if (snapshotPosition.getTimestamp() > rollbackPosition.getTimestamp() || rollbackPosition.getServerId().equals(snapshotPosition.getServerId()) && snapshotPosition.compareTo(rollbackPosition) > 0 || this.memoryTableMeta.apply(snapshotPosition, useSchema, sqlData, null)) continue;
                return false;
            }
            return metaHistoryDOList.size() > 0;
        }
        catch (Throwable e) {
            throw new CanalParseException("apply failed", e);
        }
    }

    private String structureSchema(String schema) {
        if (schema.startsWith("`") && schema.endsWith("`")) {
            return schema;
        }
        return "`" + schema + "`";
    }

    private String getFullName(String schema, String table) {
        StringBuilder builder = new StringBuilder();
        return builder.append(this.structureSchema(schema)).append('.').append('`').append(table).append('`').toString();
    }

    public static boolean compareTableMeta(TableMeta source, TableMeta target) {
        if (!StringUtils.equalsIgnoreCase((String)source.getSchema(), (String)target.getSchema())) {
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((String)source.getTable(), (String)target.getTable())) {
            return false;
        }
        List<TableMeta.FieldMeta> sourceFields = source.getFields();
        List<TableMeta.FieldMeta> targetFields = target.getFields();
        if (sourceFields.size() != targetFields.size()) {
            return false;
        }
        for (int i = 0; i < sourceFields.size(); ++i) {
            boolean isTargetPkOrUk;
            TableMeta.FieldMeta sourceField = sourceFields.get(i);
            TableMeta.FieldMeta targetField = targetFields.get(i);
            if (!StringUtils.equalsIgnoreCase((String)sourceField.getColumnName(), (String)targetField.getColumnName())) {
                return false;
            }
            if (sourceField.isUnsigned() && !targetField.isUnsigned() || !sourceField.isUnsigned() && targetField.isUnsigned()) {
                return false;
            }
            String sourceColumnType = StringUtils.removeEndIgnoreCase((String)sourceField.getColumnType(), (String)"zerofill").trim();
            String targetColumnType = StringUtils.removeEndIgnoreCase((String)targetField.getColumnType(), (String)"zerofill").trim();
            String sign = sourceField.isUnsigned() ? "unsigned" : "signed";
            sourceColumnType = StringUtils.removeEndIgnoreCase((String)sourceColumnType, (String)sign).trim();
            targetColumnType = StringUtils.removeEndIgnoreCase((String)targetColumnType, (String)sign).trim();
            boolean columnTypeCompare = false;
            columnTypeCompare |= StringUtils.containsIgnoreCase((String)sourceColumnType, (String)targetColumnType);
            if (!(columnTypeCompare |= StringUtils.containsIgnoreCase((String)targetColumnType, (String)sourceColumnType))) {
                sourceColumnType = DatabaseTableMeta.synonymsType(StringUtils.substringBefore((String)sourceColumnType, (String)"(")).trim();
                targetColumnType = DatabaseTableMeta.synonymsType(StringUtils.substringBefore((String)targetColumnType, (String)"(")).trim();
                columnTypeCompare |= StringUtils.containsIgnoreCase((String)sourceColumnType, (String)targetColumnType);
                if (!(columnTypeCompare |= StringUtils.containsIgnoreCase((String)targetColumnType, (String)sourceColumnType))) {
                    return false;
                }
            }
            if (!StringUtils.containsIgnoreCase((String)sourceColumnType, (String)"timestamp") && !StringUtils.containsIgnoreCase((String)targetColumnType, (String)"timestamp") && sourceField.isNullable() != targetField.isNullable()) {
                return false;
            }
            boolean isSourcePkOrUk = sourceField.isKey() || sourceField.isUnique();
            boolean bl = isTargetPkOrUk = targetField.isKey() || targetField.isUnique();
            if (isSourcePkOrUk == isTargetPkOrUk) continue;
            return false;
        }
        return true;
    }

    private static String synonymsType(String originType) {
        if (StringUtils.equalsIgnoreCase((String)originType, (String)"bool") || StringUtils.equalsIgnoreCase((String)originType, (String)"boolean")) {
            return "tinyint";
        }
        if (StringUtils.equalsIgnoreCase((String)originType, (String)"dec") || StringUtils.equalsIgnoreCase((String)originType, (String)"numeric") || StringUtils.equalsIgnoreCase((String)originType, (String)"fixed")) {
            return "decimal";
        }
        if (StringUtils.equalsIgnoreCase((String)originType, (String)"integer")) {
            return "int";
        }
        if (StringUtils.equalsIgnoreCase((String)originType, (String)"real") || StringUtils.equalsIgnoreCase((String)originType, (String)"double precision")) {
            return "double";
        }
        if (StringUtils.equalsIgnoreCase((String)originType, (String)"tinyblob") || StringUtils.equalsIgnoreCase((String)originType, (String)"mediumblob") || StringUtils.equalsIgnoreCase((String)originType, (String)"longblob")) {
            return "blob";
        }
        if (StringUtils.equalsIgnoreCase((String)originType, (String)"tinytext") || StringUtils.equalsIgnoreCase((String)originType, (String)"mediumtext") || StringUtils.equalsIgnoreCase((String)originType, (String)"longtext")) {
            return "text";
        }
        return originType;
    }

    private int snapshotExpire(int expireTimestamp) {
        return this.metaSnapshotDAO.deleteByTimestamp(this.destination, expireTimestamp);
    }

    public void setConnection(MysqlConnection connection) {
        this.connection = connection;
    }

    public void setFilter(CanalEventFilter filter) {
        this.filter = filter;
    }

    public MetaHistoryDAO getMetaHistoryDAO() {
        return this.metaHistoryDAO;
    }

    public void setMetaHistoryDAO(MetaHistoryDAO metaHistoryDAO) {
        this.metaHistoryDAO = metaHistoryDAO;
    }

    public MetaSnapshotDAO getMetaSnapshotDAO() {
        return this.metaSnapshotDAO;
    }

    public void setMetaSnapshotDAO(MetaSnapshotDAO metaSnapshotDAO) {
        this.metaSnapshotDAO = metaSnapshotDAO;
    }

    public void setBlackFilter(CanalEventFilter blackFilter) {
        this.blackFilter = blackFilter;
    }

    public void setFieldFilterMap(Map<String, List<String>> fieldFilterMap) {
        this.fieldFilterMap = fieldFilterMap;
    }

    public void setFieldBlackFilterMap(Map<String, List<String>> fieldBlackFilterMap) {
        this.fieldBlackFilterMap = fieldBlackFilterMap;
    }

    public Map<String, List<String>> getFieldFilterMap() {
        return this.fieldFilterMap;
    }

    public Map<String, List<String>> getFieldBlackFilterMap() {
        return this.fieldBlackFilterMap;
    }

    public int getSnapshotInterval() {
        return this.snapshotInterval;
    }

    public void setSnapshotInterval(int snapshotInterval) {
        this.snapshotInterval = snapshotInterval;
    }

    public int getSnapshotExpire() {
        return this.snapshotExpire;
    }

    public void setSnapshotExpire(int snapshotExpire) {
        this.snapshotExpire = snapshotExpire;
    }

    public MysqlConnection getConnection() {
        return this.connection;
    }

    public boolean isUkDuplicateException(Throwable t) {
        return pattern.matcher(t.getMessage()).find() || h2Pattern.matcher(t.getMessage()).find();
    }
}

