/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.ai;

import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.maintainer.client.ai.AiMaintainerService;
import com.alibaba.nacos.maintainer.client.model.HttpRequest;
import com.alibaba.nacos.maintainer.client.remote.ClientHttpProxy;
import com.alibaba.nacos.maintainer.client.utils.ParamUtil;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class NacosAiMaintainerServiceImpl
implements AiMaintainerService {
    private final ClientHttpProxy clientHttpProxy;

    public NacosAiMaintainerServiceImpl(Properties properties) throws NacosException {
        this.clientHttpProxy = new ClientHttpProxy(properties);
        ParamUtil.initSerialization();
    }

    @Override
    public Page<McpServerBasicInfo> listMcpServer(String namespaceId, String mcpName, int pageNo, int pageSize) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        params.put("search", "accurate");
        params.put("mcpName", mcpName);
        params.put("namespaceId", namespaceId);
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        return this.getMcpServerBasicInfoPage(params, resource);
    }

    @Override
    public Page<McpServerBasicInfo> searchMcpServer(String namespaceId, String mcpName, int pageNo, int pageSize) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        params.put("search", "blur");
        params.put("mcpName", mcpName);
        params.put("namespaceId", namespaceId);
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        return this.getMcpServerBasicInfoPage(params, resource);
    }

    private Page<McpServerBasicInfo> getMcpServerBasicInfoPage(Map<String, String> params, RequestResource resource) throws NacosException {
        HttpRequest httpRequest = this.buildHttpRequestBuilder(resource).setHttpMethod("GET").setPath("/v3/admin/ai/mcp/list").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<Page<McpServerBasicInfo>>>(){});
        return (Page)result.getData();
    }

    @Override
    public McpServerDetailInfo getMcpServerDetail(String namespaceId, String mcpName, String mcpId, String version) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("mcpName", mcpName);
        params.put("mcpId", mcpId);
        params.put("version", version);
        params.put("namespaceId", namespaceId);
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        HttpRequest httpRequest = this.buildHttpRequestBuilder(resource).setHttpMethod("GET").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<McpServerDetailInfo>>(){});
        return (McpServerDetailInfo)result.getData();
    }

    @Override
    public boolean createMcpServer(String namespaceId, String mcpName, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        Map<String, String> params = this.buildFullParameters(serverSpec, toolSpec, endpointSpec);
        params.put("namespaceId", namespaceId);
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        HttpRequest httpRequest = this.buildHttpRequestBuilder(resource).setHttpMethod("POST").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return ErrorCode.SUCCESS.getCode().equals(result.getCode());
    }

    @Override
    public boolean updateMcpServer(String namespaceId, String mcpName, boolean isLatest, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        Map<String, String> params = this.buildFullParameters(serverSpec, toolSpec, endpointSpec);
        params.put("latest", String.valueOf(isLatest));
        params.put("namespaceId", namespaceId);
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        HttpRequest httpRequest = this.buildHttpRequestBuilder(resource).setHttpMethod("PUT").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return ErrorCode.SUCCESS.getCode().equals(result.getCode());
    }

    private Map<String, String> buildFullParameters(McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("mcpName", serverSpec.getName());
        params.put("serverSpecification", JacksonUtils.toJson((Object)serverSpec));
        if (null != toolSpec) {
            params.put("toolSpecification", JacksonUtils.toJson((Object)toolSpec));
        }
        if (null != endpointSpec) {
            params.put("endpointSpecification", JacksonUtils.toJson((Object)endpointSpec));
        }
        return params;
    }

    @Override
    public boolean deleteMcpServer(String namespaceId, String mcpName, String mcpId, String version) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("mcpName", mcpName);
        params.put("mcpId", mcpId);
        params.put("version", version);
        params.put("namespaceId", namespaceId);
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        HttpRequest httpRequest = this.buildHttpRequestBuilder(resource).setHttpMethod("DELETE").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return ErrorCode.SUCCESS.getCode().equals(result.getCode());
    }

    private RequestResource buildRequestResource(String namespaceId, String mcpName) {
        RequestResource.Builder builder = RequestResource.aiBuilder();
        builder.setNamespace(namespaceId);
        builder.setGroup("DEFAULT_GROUP");
        builder.setResource(null == mcpName ? "" : mcpName);
        return builder.build();
    }

    private HttpRequest.Builder buildHttpRequestBuilder(RequestResource resource) {
        return new HttpRequest.Builder().setResource(resource);
    }
}

