/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import java.io.InputStream;
import java.util.Comparator;
import java.util.Objects;
import java.util.Properties;

public class VersionUtils {
    public static String version;
    private static String clientVersion;
    public static final String VERSION_PLACEHOLDER = "${project.version}";
    private static final String NACOS_VERSION_FILE = "nacos-version.txt";
    private static final Comparator<String> STRING_COMPARATOR;

    public static int compareVersion(String versionA, String versionB) {
        String[] sA = versionA.split("\\.");
        String[] sB = versionB.split("\\.");
        int expectSize = 3;
        if (sA.length != expectSize || sB.length != expectSize) {
            throw new IllegalArgumentException("version must be like x.y.z(-beta)");
        }
        int first = Objects.compare(sA[0], sB[0], STRING_COMPARATOR);
        if (first != 0) {
            return first;
        }
        int second = Objects.compare(sA[1], sB[1], STRING_COMPARATOR);
        if (second != 0) {
            return second;
        }
        return Objects.compare(sA[2].split("-")[0], sB[2].split("-")[0], STRING_COMPARATOR);
    }

    public static String getFullClientVersion() {
        return clientVersion;
    }

    static {
        try (InputStream in = VersionUtils.class.getClassLoader().getResourceAsStream(NACOS_VERSION_FILE);){
            Properties props = new Properties();
            props.load(in);
            String val = props.getProperty("version");
            if (val != null && !VERSION_PLACEHOLDER.equals(val)) {
                version = val;
                clientVersion = "Nacos-Java-Client:v" + version;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        STRING_COMPARATOR = String::compareTo;
    }
}

