/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.tm.api;

import com.alibaba.fescar.core.exception.TransactionException;
import com.alibaba.fescar.tm.api.GlobalTransaction;
import com.alibaba.fescar.tm.api.GlobalTransactionContext;
import com.alibaba.fescar.tm.api.TransactionalExecutor;
import com.alibaba.fescar.tm.api.transaction.TransactionHook;
import com.alibaba.fescar.tm.api.transaction.TransactionHookManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalTemplate.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(TransactionalExecutor business) throws TransactionalExecutor.ExecutionException {
        GlobalTransaction tx = GlobalTransactionContext.getCurrentOrCreate();
        try {
            try {
                this.triggerBeforeBegin();
                tx.begin(business.timeout(), business.name());
                this.triggerAfterBegin();
            }
            catch (TransactionException txe) {
                throw new TransactionalExecutor.ExecutionException(tx, txe, TransactionalExecutor.Code.BeginFailure);
            }
            Object rs = null;
            try {
                rs = business.execute();
            }
            catch (Throwable ex) {
                try {
                    this.triggerBeforeRollback();
                    tx.rollback();
                    this.triggerAfterRollback();
                    throw new TransactionalExecutor.ExecutionException(tx, TransactionalExecutor.Code.RollbackDone, ex);
                }
                catch (TransactionException txe) {
                    throw new TransactionalExecutor.ExecutionException(tx, (Throwable)txe, TransactionalExecutor.Code.RollbackFailure, ex);
                }
            }
            try {
                this.triggerBeforeCommit();
                tx.commit();
                this.triggerAfterCommit();
            }
            catch (TransactionException txe) {
                throw new TransactionalExecutor.ExecutionException(tx, txe, TransactionalExecutor.Code.CommitFailure);
            }
            Object object = rs;
            return object;
        }
        finally {
            this.triggerAfterCompletion();
            this.cleanUp();
        }
    }

    private void triggerBeforeBegin() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeBegin();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeBegin in hook " + e.getMessage());
            }
        }
    }

    private void triggerAfterBegin() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterBegin();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterBegin in hook " + e.getMessage());
            }
        }
    }

    private void triggerBeforeRollback() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeRollback();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeRollback in hook " + e.getMessage());
            }
        }
    }

    private void triggerAfterRollback() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterRollback();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterRollback in hook " + e.getMessage());
            }
        }
    }

    private void triggerBeforeCommit() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeCommit();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeCommit in hook " + e.getMessage());
            }
        }
    }

    private void triggerAfterCommit() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterCommit();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterCommit in hook " + e.getMessage());
            }
        }
    }

    private void triggerAfterCompletion() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterCompletion();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterCompletion in hook " + e.getMessage());
            }
        }
    }

    private void cleanUp() {
        TransactionHookManager.clear();
    }

    private List<TransactionHook> getCurrentHooks() {
        return TransactionHookManager.getHooks();
    }
}

