/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.tm;

import com.alibaba.fescar.common.XID;
import com.alibaba.fescar.core.exception.TransactionException;
import com.alibaba.fescar.core.exception.TransactionExceptionCode;
import com.alibaba.fescar.core.model.GlobalStatus;
import com.alibaba.fescar.core.model.TransactionManager;
import com.alibaba.fescar.core.protocol.transaction.AbstractTransactionRequest;
import com.alibaba.fescar.core.protocol.transaction.AbstractTransactionResponse;
import com.alibaba.fescar.core.protocol.transaction.GlobalBeginRequest;
import com.alibaba.fescar.core.protocol.transaction.GlobalBeginResponse;
import com.alibaba.fescar.core.protocol.transaction.GlobalCommitRequest;
import com.alibaba.fescar.core.protocol.transaction.GlobalCommitResponse;
import com.alibaba.fescar.core.protocol.transaction.GlobalRollbackRequest;
import com.alibaba.fescar.core.protocol.transaction.GlobalRollbackResponse;
import com.alibaba.fescar.core.protocol.transaction.GlobalStatusRequest;
import com.alibaba.fescar.core.protocol.transaction.GlobalStatusResponse;
import com.alibaba.fescar.core.rpc.netty.TmRpcClient;
import java.util.concurrent.TimeoutException;

public class DefaultTransactionManager
implements TransactionManager {
    public static TransactionManager get() {
        return SingletonHolder.INSTANCE;
    }

    public static void set(TransactionManager mock) {
        SingletonHolder.INSTANCE = mock;
    }

    private DefaultTransactionManager() {
    }

    public String begin(String applicationId, String transactionServiceGroup, String name, int timeout) throws TransactionException {
        GlobalBeginRequest request = new GlobalBeginRequest();
        request.setTransactionName(name);
        request.setTimeout(timeout);
        GlobalBeginResponse response = (GlobalBeginResponse)this.syncCall((AbstractTransactionRequest)request);
        return response.getXid();
    }

    public GlobalStatus commit(String xid) throws TransactionException {
        long txId = XID.getTransactionId((String)xid);
        GlobalCommitRequest globalCommit = new GlobalCommitRequest();
        globalCommit.setTransactionId(txId);
        GlobalCommitResponse response = (GlobalCommitResponse)this.syncCall((AbstractTransactionRequest)globalCommit);
        return response.getGlobalStatus();
    }

    public GlobalStatus rollback(String xid) throws TransactionException {
        long txId = XID.getTransactionId((String)xid);
        GlobalRollbackRequest globalRollback = new GlobalRollbackRequest();
        globalRollback.setTransactionId(txId);
        GlobalRollbackResponse response = (GlobalRollbackResponse)this.syncCall((AbstractTransactionRequest)globalRollback);
        return response.getGlobalStatus();
    }

    public GlobalStatus getStatus(String xid) throws TransactionException {
        long txId = XID.getTransactionId((String)xid);
        GlobalStatusRequest queryGlobalStatus = new GlobalStatusRequest();
        queryGlobalStatus.setTransactionId(txId);
        GlobalStatusResponse response = (GlobalStatusResponse)this.syncCall((AbstractTransactionRequest)queryGlobalStatus);
        return response.getGlobalStatus();
    }

    private AbstractTransactionResponse syncCall(AbstractTransactionRequest request) throws TransactionException {
        try {
            return (AbstractTransactionResponse)TmRpcClient.getInstance().sendMsgWithResponse((Object)request);
        }
        catch (TimeoutException toe) {
            throw new TransactionException(TransactionExceptionCode.IO, (Throwable)toe);
        }
    }

    private static class SingletonHolder {
        private static TransactionManager INSTANCE = new DefaultTransactionManager();

        private SingletonHolder() {
        }
    }
}

