/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring6.messaging.converter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import java.lang.reflect.Type;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeTypeUtils;

public class MappingFastJsonMessageConverter
extends AbstractMessageConverter {
    private FastJsonConfig config = new FastJsonConfig();

    public MappingFastJsonMessageConverter() {
        super(MimeTypeUtils.APPLICATION_JSON);
    }

    public FastJsonConfig getFastJsonConfig() {
        return this.config;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.config = fastJsonConfig;
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object obj = null;
        Type type = MappingFastJsonMessageConverter.getResolvedType(targetClass, conversionHint);
        Object payload = message.getPayload();
        if (payload instanceof byte[] && this.config.isJSONB()) {
            obj = JSONB.parseObject((byte[])((byte[])payload), (Type)type, (SymbolTable)this.config.getSymbolTable(), (Filter[])this.config.getReaderFilters(), (JSONReader.Feature[])this.config.getReaderFeatures());
        } else if (payload instanceof byte[] && !this.config.isJSONB()) {
            obj = JSON.parseObject((byte[])((byte[])payload), (Type)type, (String)this.config.getDateFormat(), (Filter[])this.config.getReaderFilters(), (JSONReader.Feature[])this.config.getReaderFeatures());
        } else if (payload instanceof String && JSON.isValid((String)((String)payload))) {
            obj = JSON.parseObject((String)((String)payload), (Type)type, (String)this.config.getDateFormat(), (Filter[])this.config.getReaderFilters(), (JSONReader.Feature[])this.config.getReaderFeatures());
        }
        return obj;
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        Object obj = null;
        if (byte[].class == this.getSerializedPayloadClass()) {
            obj = payload instanceof String && this.config.isJSONB() ? JSONB.fromJSONString((String)((String)payload)) : (payload instanceof String && !this.config.isJSONB() ? ((String)payload).getBytes(this.config.getCharset()) : (Object)(this.config.isJSONB() ? JSONB.toBytes((Object)payload, (SymbolTable)this.config.getSymbolTable(), (Filter[])this.config.getWriterFilters(), (JSONWriter.Feature[])this.config.getWriterFeatures()) : JSON.toJSONBytes((Object)payload, (String)this.config.getDateFormat(), (Filter[])this.config.getWriterFilters(), (JSONWriter.Feature[])this.config.getWriterFeatures())));
        } else if (String.class == this.getSerializedPayloadClass()) {
            obj = payload instanceof String && JSON.isValid((String)((String)payload)) ? (Object)payload : (Object)JSON.toJSONString((Object)payload, (String)this.config.getDateFormat(), (Filter[])this.config.getWriterFilters(), (JSONWriter.Feature[])this.config.getWriterFeatures());
        }
        return obj;
    }

    static Type getResolvedType(Class<?> targetClass, @Nullable Object conversionHint) {
        if (conversionHint instanceof MethodParameter) {
            MethodParameter param = (MethodParameter)conversionHint;
            if (Message.class.isAssignableFrom((param = param.nestedIfOptional()).getParameterType())) {
                param = param.nested();
            }
            Type genericParameterType = param.getNestedGenericParameterType();
            Class contextClass = param.getContainingClass();
            return GenericTypeResolver.resolveType((Type)genericParameterType, (Class)contextClass);
        }
        return targetClass;
    }
}

