/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util.concurrent;

import com.taobao.hsf.util.concurrent.AbstractListener;
import com.taobao.hsf.util.concurrent.DefaultListenableFuture;
import com.taobao.hsf.util.concurrent.Func1;
import com.taobao.hsf.util.concurrent.ListenableFuture;
import com.taobao.hsf.util.concurrent.WrappedListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DefaultMapFuture<T, R>
extends DefaultListenableFuture<R> {
    private ListenableFuture<T> source;

    public DefaultMapFuture(Executor executor, ListenableFuture<T> source, Func1<T, R> transformer) {
        super(executor);
        this.source = source;
        source.addListener(new MapCallback(source, transformer));
    }

    public DefaultMapFuture(Executor executor, ListenableFuture<T> source, Func1<T, R> transformer, WrappedListener.ListenerWrapper listenerWrapper) {
        super(executor);
        this.source = source;
        source.addListener(new WrappedListener(new MapCallback(source, transformer), listenerWrapper));
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        this.source.get();
        return (R)super.get();
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.source.get(timeout, unit);
        return (R)super.get(timeout, unit);
    }

    private class MapCallback
    extends AbstractListener<T> {
        private Func1<T, R> transformer;

        public MapCallback(ListenableFuture<T> source, Func1<T, R> transformer) {
            super(source);
            this.transformer = transformer;
        }

        @Override
        protected void operationComplete(T value) {
            try {
                Object input = value;
                Object result = this.transformer.call(input);
                DefaultMapFuture.this.set(result);
            }
            catch (Throwable t) {
                DefaultMapFuture.this.setException(t);
            }
        }

        @Override
        protected void onThrowable(Throwable t) {
            DefaultMapFuture.this.setException(t);
        }
    }
}

