/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLIfStatement
extends SQLStatementImpl
implements SQLReplaceable {
    private SQLExpr condition;
    private List<SQLStatement> statements = new ArrayList<SQLStatement>();
    private List<ElseIf> elseIfList = new ArrayList<ElseIf>();
    private Else elseItem;

    @Override
    public SQLIfStatement clone() {
        SQLIfStatement x = new SQLIfStatement();
        for (SQLStatement stmt : this.statements) {
            SQLStatement stmt2 = stmt.clone();
            stmt2.setParent(x);
            x.statements.add(stmt2);
        }
        for (ElseIf o : this.elseIfList) {
            ElseIf o2 = o.clone();
            o2.setParent(x);
            x.elseIfList.add(o2);
        }
        if (this.elseItem != null) {
            x.setElseItem(this.elseItem.clone());
        }
        return x;
    }

    @Override
    public void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            int i;
            if (this.condition != null) {
                this.condition.accept(visitor);
            }
            for (i = 0; i < this.statements.size(); ++i) {
                this.statements.get(i).accept(visitor);
            }
            for (i = 0; i < this.elseIfList.size(); ++i) {
                this.elseIfList.get(i).accept(visitor);
            }
            if (this.elseItem != null) {
                this.elseItem.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public SQLExpr getCondition() {
        return this.condition;
    }

    public void setCondition(SQLExpr condition) {
        if (condition != null) {
            condition.setParent(this);
        }
        this.condition = condition;
    }

    public List<SQLStatement> getStatements() {
        return this.statements;
    }

    public void addStatement(SQLStatement statement) {
        if (statement != null) {
            statement.setParent(this);
        }
        this.statements.add(statement);
    }

    public List<ElseIf> getElseIfList() {
        return this.elseIfList;
    }

    public Else getElseItem() {
        return this.elseItem;
    }

    public void setElseItem(Else elseItem) {
        if (elseItem != null) {
            elseItem.setParent(this);
        }
        this.elseItem = elseItem;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.condition == expr) {
            this.setCondition(target);
            return true;
        }
        return false;
    }

    public static class Else
    extends SQLObjectImpl {
        private List<SQLStatement> statements = new ArrayList<SQLStatement>();

        @Override
        public void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild(visitor, this.statements);
            }
            visitor.endVisit(this);
        }

        public List<SQLStatement> getStatements() {
            return this.statements;
        }

        public void setStatements(List<SQLStatement> statements) {
            this.statements = statements;
        }

        @Override
        public Else clone() {
            Else x = new Else();
            for (SQLStatement stmt : this.statements) {
                SQLStatement stmt2 = stmt.clone();
                stmt2.setParent(x);
                x.statements.add(stmt2);
            }
            return x;
        }
    }

    public static class ElseIf
    extends SQLObjectImpl
    implements SQLReplaceable {
        private SQLExpr condition;
        private List<SQLStatement> statements = new ArrayList<SQLStatement>();

        @Override
        public void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild(visitor, this.condition);
                this.acceptChild(visitor, this.statements);
            }
            visitor.endVisit(this);
        }

        public List<SQLStatement> getStatements() {
            return this.statements;
        }

        public void setStatements(List<SQLStatement> statements) {
            this.statements = statements;
        }

        public SQLExpr getCondition() {
            return this.condition;
        }

        public void setCondition(SQLExpr condition) {
            if (condition != null) {
                condition.setParent(this);
            }
            this.condition = condition;
        }

        @Override
        public boolean replace(SQLExpr expr, SQLExpr target) {
            if (this.condition == expr) {
                this.setCondition(target);
                return true;
            }
            return false;
        }

        @Override
        public ElseIf clone() {
            ElseIf x = new ElseIf();
            if (this.condition != null) {
                x.setCondition(this.condition.clone());
            }
            for (SQLStatement stmt : this.statements) {
                SQLStatement stmt2 = stmt.clone();
                stmt2.setParent(x);
                x.statements.add(stmt2);
            }
            return x;
        }
    }
}

