/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGOrderBy;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGArrayExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGTypeCastExpr;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGLexer;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class PGExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER"};

    public PGExprParser(String sql) {
        this(new PGLexer(sql));
        this.lexer.nextToken();
    }

    public PGExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
    }

    @Override
    public PGOrderBy parseOrderBy() {
        if (this.lexer.token() == Token.ORDER) {
            PGOrderBy orderBy = new PGOrderBy();
            this.lexer.nextToken();
            if (this.identifierEquals("SIBLINGS")) {
                this.lexer.nextToken();
                orderBy.setSibings(true);
            }
            this.accept(Token.BY);
            orderBy.addItem(this.parseSelectOrderByItem());
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                orderBy.addItem(this.parseSelectOrderByItem());
            }
            return orderBy;
        }
        return null;
    }

    @Override
    public SQLExpr primary() {
        if (this.lexer.token() == Token.ARRAY) {
            this.lexer.nextToken();
            PGArrayExpr array = new PGArrayExpr();
            this.accept(Token.LBRACKET);
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        return super.primary();
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.COLONCOLON) {
            this.lexer.nextToken();
            SQLDataType dataType = this.parseDataType();
            PGTypeCastExpr castExpr = new PGTypeCastExpr();
            castExpr.setExpr(expr);
            castExpr.setDataType(dataType);
            return this.primaryRest(castExpr);
        }
        return super.primaryRest(expr);
    }
}

