/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class MySqlLexer
extends Lexer {
    public static final Keywords DEFAULT_MYSQL_KEYWORDS;

    public MySqlLexer(char[] input, int inputLength, boolean skipComment) {
        super(input, inputLength, skipComment);
        this.keywods = DEFAULT_MYSQL_KEYWORDS;
    }

    public MySqlLexer(String input) {
        super(input);
        this.keywods = DEFAULT_MYSQL_KEYWORDS;
    }

    @Override
    public void scanSharp() {
        if (this.ch != '#') {
            throw new ParserException("illegal stat");
        }
        if (this.charAt(this.pos + 1) == '{') {
            this.scanVariable();
            return;
        }
        Token lastToken = this.token;
        this.scanChar();
        this.mark = this.pos;
        this.bufPos = 0;
        while (true) {
            if (this.ch == '\r') {
                if (this.charAt(this.pos + 1) == '\n') {
                    this.bufPos += 2;
                    this.scanChar();
                    break;
                }
                ++this.bufPos;
                break;
            }
            if (this.ch == '\u001a') break;
            if (this.ch == '\n') {
                this.scanChar();
                ++this.bufPos;
                break;
            }
            this.scanChar();
            ++this.bufPos;
        }
        this.stringVal = this.subString(this.mark, this.bufPos);
        this.token = Token.LINE_COMMENT;
        this.hasComment = true;
        if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
            return;
        }
        this.endOfComment = this.isEOF();
        if (!(this.isAllowComment() || !this.isEOF() && this.isSafeComment(this.stringVal))) {
            throw new NotAllowCommentException();
        }
    }

    @Override
    public void scanVariable() {
        if (this.ch != '@' && this.ch != ':' && this.ch != '#' && this.ch != '$') {
            throw new ParserException("illegal variable");
        }
        this.mark = this.pos;
        this.bufPos = 1;
        if (this.charAt(this.pos + 1) == '@') {
            this.ch = this.charAt(++this.pos);
            ++this.bufPos;
        }
        if (this.charAt(this.pos + 1) == '`') {
            char ch;
            ++this.pos;
            ++this.bufPos;
            while (true) {
                if ((ch = this.charAt(++this.pos)) == '`') {
                    ++this.bufPos;
                    break;
                }
                if (ch == '\u001a') {
                    throw new ParserException("illegal identifier");
                }
                ++this.bufPos;
            }
            ch = this.charAt(++this.pos);
            this.ch = this.charAt(this.pos);
            this.stringVal = this.subString(this.mark, this.bufPos);
            this.token = Token.VARIANT;
        } else if (this.charAt(this.pos + 1) == '{') {
            char ch;
            ++this.pos;
            ++this.bufPos;
            while (true) {
                if ((ch = this.charAt(++this.pos)) == '}') {
                    ++this.bufPos;
                    break;
                }
                if (ch == '\u001a') {
                    throw new ParserException("illegal identifier");
                }
                ++this.bufPos;
            }
            ch = this.charAt(++this.pos);
            this.ch = this.charAt(this.pos);
            this.stringVal = this.subString(this.mark, this.bufPos);
            this.token = Token.VARIANT;
        } else {
            while (true) {
                this.ch = this.charAt(++this.pos);
                if (!this.isIdentifierChar(this.ch)) break;
                ++this.bufPos;
            }
        }
        this.ch = this.charAt(this.pos);
        this.stringVal = this.subString(this.mark, this.bufPos);
        this.token = Token.VARIANT;
    }

    @Override
    public void scanIdentifier() {
        char first = this.ch;
        if (this.ch == '`') {
            char ch;
            this.mark = this.pos;
            this.bufPos = 1;
            while (true) {
                if ((ch = this.charAt(++this.pos)) == '`') {
                    ++this.bufPos;
                    break;
                }
                if (ch == '\u001a') {
                    throw new ParserException("illegal identifier");
                }
                ++this.bufPos;
            }
            ch = this.charAt(++this.pos);
            this.ch = this.charAt(this.pos);
            this.stringVal = this.subString(this.mark, this.bufPos);
            Token tok = this.keywods.getKeyword(this.stringVal);
            this.token = tok != null ? tok : Token.IDENTIFIER;
        } else {
            char ch;
            boolean firstFlag = CharTypes.isFirstIdentifierChar(first);
            if (!firstFlag) {
                throw new ParserException("illegal identifier");
            }
            this.mark = this.pos;
            this.bufPos = 1;
            while (this.isIdentifierChar(ch = this.charAt(++this.pos))) {
                ++this.bufPos;
            }
            this.ch = this.charAt(this.pos);
            this.stringVal = this.addSymbol();
            Token tok = this.keywods.getKeyword(this.stringVal);
            this.token = tok != null ? tok : Token.IDENTIFIER;
        }
    }

    @Override
    protected final void scanString() {
        boolean hasSpecial = false;
        int startIndex = this.pos + 1;
        int endIndex = -1;
        for (int i = startIndex; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (ch == '\\') {
                hasSpecial = true;
                continue;
            }
            if (ch != '\'') continue;
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            throw new ParserException("unclosed str");
        }
        String stringVal = this.subString(startIndex, endIndex - startIndex);
        if (!hasSpecial) {
            this.stringVal = stringVal;
            int pos = endIndex + 1;
            char ch = this.charAt(pos);
            if (ch != '\'') {
                this.pos = pos;
                this.ch = ch;
                this.token = Token.LITERAL_CHARS;
                return;
            }
        }
        this.mark = this.pos;
        hasSpecial = false;
        block12: while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                switch (this.ch) {
                    case '\u0000': {
                        this.ch = '\u0000';
                        this.putChar('\u0000');
                        continue block12;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block12;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block12;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block12;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block12;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block12;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block12;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block12;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        continue block12;
                    }
                }
                this.putChar(this.ch);
                continue;
            }
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? this.subString(this.mark + 1, this.bufPos) : new String(this.buf, 0, this.bufPos);
    }

    @Override
    public void scanComment() {
        Token lastToken = this.token;
        if (this.ch == '-') {
            char next_2 = this.charAt(this.pos + 2);
            if (this.isDigit(next_2)) {
                this.scanChar();
                this.token = Token.SUB;
                return;
            }
        } else if (this.ch != '/') {
            throw new IllegalStateException();
        }
        this.mark = this.pos;
        this.bufPos = 0;
        this.scanChar();
        if (this.ch == '*') {
            this.scanChar();
            ++this.bufPos;
            while (this.ch == ' ') {
                this.scanChar();
                ++this.bufPos;
            }
            boolean isHint = false;
            int startHintSp = this.bufPos + 1;
            if (this.ch == '!') {
                isHint = true;
                this.scanChar();
                ++this.bufPos;
            }
            while (true) {
                if (this.ch == '\u001a') {
                    this.token = Token.ERROR;
                    return;
                }
                if (this.ch == '*' && this.charAt(this.pos + 1) == '/') {
                    this.bufPos += 3;
                    break;
                }
                this.scanChar();
                ++this.bufPos;
            }
            this.scanChar();
            this.scanChar();
            if (isHint) {
                this.stringVal = this.subString(this.mark + startHintSp, this.bufPos - startHintSp - 2);
                this.token = Token.HINT;
            } else {
                this.stringVal = this.subString(this.mark, this.bufPos);
                this.token = Token.MULTI_LINE_COMMENT;
                this.hasComment = true;
            }
            if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
                return;
            }
            this.endOfComment = this.isEOF();
            if (!(isHint || this.isAllowComment() || !this.isEOF() && this.isSafeComment(this.stringVal))) {
                throw new NotAllowCommentException();
            }
            return;
        }
        if (this.ch == '/' || this.ch == '-') {
            this.scanChar();
            ++this.bufPos;
            while (true) {
                if (this.ch == '\r') {
                    if (this.charAt(this.pos + 1) == '\n') {
                        this.bufPos += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.bufPos;
                    break;
                }
                if (this.ch == '\u001a') break;
                if (this.ch == '\n') {
                    this.scanChar();
                    ++this.bufPos;
                    break;
                }
                this.scanChar();
                ++this.bufPos;
            }
            this.stringVal = this.subString(this.mark, this.bufPos + 1);
            this.token = Token.LINE_COMMENT;
            this.hasComment = true;
            if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
                return;
            }
            this.endOfComment = this.isEOF();
            if (!(this.isAllowComment() || !this.isEOF() && this.isSafeComment(this.stringVal))) {
                throw new NotAllowCommentException();
            }
            return;
        }
    }

    private boolean isSafeComment(String comment) {
        if (comment == null) {
            return true;
        }
        return (comment = comment.toLowerCase()).indexOf("select") == -1 && comment.indexOf("delete") == -1 && comment.indexOf("insert") == -1 && comment.indexOf("update") == -1 && comment.indexOf("into") == -1 && comment.indexOf("where") == -1 && comment.indexOf("or") == -1 && comment.indexOf("and") == -1 && comment.indexOf("union") == -1 && comment.indexOf(39) == -1 && comment.indexOf(61) == -1 && comment.indexOf(62) == -1 && comment.indexOf(60) == -1 && comment.indexOf(38) == -1 && comment.indexOf(124) == -1 && comment.indexOf(94) == -1;
    }

    private boolean isIdentifierChar(char c) {
        return c != '#' && CharTypes.isIdentifierChar(c);
    }

    @Override
    public void scanNumber() {
        this.mark = this.pos++;
        if (this.ch == '-') {
            ++this.bufPos;
            this.ch = this.charAt(this.pos);
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            if (this.charAt(this.pos + 1) == '.') {
                this.token = Token.LITERAL_INT;
                return;
            }
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            if (this.ch == '+' || this.ch == '-') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            isDouble = true;
        }
        if (isDouble) {
            this.token = Token.LITERAL_FLOAT;
        } else if (CharTypes.isFirstIdentifierChar(this.ch) && (this.ch != 'b' || this.bufPos != 1 || this.charAt(this.pos - 1) != '0')) {
            ++this.bufPos;
            while (true) {
                this.ch = this.charAt(++this.pos);
                if (!this.isIdentifierChar(this.ch)) break;
                ++this.bufPos;
            }
            this.stringVal = this.addSymbol();
            this.token = Token.IDENTIFIER;
        } else {
            this.token = Token.LITERAL_INT;
        }
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
        map.put("DUAL", Token.DUAL);
        map.put("FALSE", Token.FALSE);
        map.put("IDENTIFIED", Token.IDENTIFIED);
        map.put("IF", Token.IF);
        map.put("KILL", Token.KILL);
        map.put("LIMIT", Token.LIMIT);
        map.put("TRUE", Token.TRUE);
        map.put("BINARY", Token.BINARY);
        map.put("SHOW", Token.SHOW);
        map.put("CACHE", Token.CACHE);
        map.put("ANALYZE", Token.ANALYZE);
        map.put("OPTIMIZE", Token.OPTIMIZE);
        DEFAULT_MYSQL_KEYWORDS = new Keywords(map);
    }
}

