/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.threads.messages;

import com.alibaba.dashscope.api.GeneralApi;
import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.FlattenResultBase;
import com.alibaba.dashscope.common.GeneralGetParam;
import com.alibaba.dashscope.common.GeneralListParam;
import com.alibaba.dashscope.common.ListResult;
import com.alibaba.dashscope.common.UpdateMetadataParam;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.GeneralServiceOption;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.threads.messages.MessageFile;
import com.alibaba.dashscope.threads.messages.MessageParamBase;
import com.alibaba.dashscope.threads.messages.ThreadMessage;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;

public final class Messages {
    private final GeneralApi<HalfDuplexParamBase> api;
    private final GeneralServiceOption serviceOption = this.defaultServiceOption();

    private GeneralServiceOption defaultServiceOption() {
        return ((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)GeneralServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.OUT)).path("threads")).build();
    }

    public Messages() {
        this.api = new GeneralApi();
    }

    public Messages(String baseUrl, ConnectionOptions connectionOptions) {
        this.serviceOption.setBaseHttpUrl(baseUrl);
        this.api = new GeneralApi(connectionOptions);
    }

    public ThreadMessage create(String threadId, MessageParamBase param) throws ApiException, NoApiKeyException, InputRequiredException {
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/%s/messages", threadId));
        if (threadId == null || threadId.equals("")) {
            throw new InputRequiredException("The threadId is required.");
        }
        param.validate();
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return (ThreadMessage)FlattenResultBase.fromDashScopeResult(result, ThreadMessage.class);
    }

    public ThreadMessage update(String threadId, String messageId, UpdateMetadataParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        if (threadId == null || threadId.isEmpty() || messageId == null || messageId.isEmpty()) {
            throw new InputRequiredException("threadId  and messageId  are required!");
        }
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/%s/messages/%s", threadId, messageId));
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return (ThreadMessage)FlattenResultBase.fromDashScopeResult(result, ThreadMessage.class);
    }

    public ListResult<ThreadMessage> list(String threadId, GeneralListParam listParam) throws ApiException, NoApiKeyException, InputRequiredException {
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("threads/%s/messages", threadId));
        if (threadId == null || threadId.equals("")) {
            throw new InputRequiredException("The threadId is required.");
        }
        DashScopeResult result = this.api.get(listParam, this.serviceOption);
        Type typeOfT = new TypeToken<ListResult<ThreadMessage>>(){}.getType();
        return (ListResult)FlattenResultBase.fromDashScopeResult(result, typeOfT);
    }

    public ThreadMessage retrieve(String threadId, String messageId) throws ApiException, NoApiKeyException, InputRequiredException {
        return this.retrieve(threadId, messageId, null);
    }

    public ThreadMessage retrieve(String threadId, String messageId, String apiKey) throws ApiException, NoApiKeyException, InputRequiredException {
        if (threadId == null || threadId.isEmpty() || messageId == null || messageId.isEmpty()) {
            throw new InputRequiredException("The threadId and messageId are required.");
        }
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("threads/%s/messages/%s", threadId, messageId));
        DashScopeResult result = this.api.get(((GeneralGetParam.GeneralGetParamBuilder)GeneralGetParam.builder().apiKey(apiKey)).build(), this.serviceOption);
        return (ThreadMessage)FlattenResultBase.fromDashScopeResult(result, ThreadMessage.class);
    }

    public MessageFile retrieveFile(String threadId, String messageId, String fileId) throws ApiException, NoApiKeyException, InputRequiredException {
        return this.retrieveFile(threadId, messageId, fileId, null);
    }

    public MessageFile retrieveFile(String threadId, String messageId, String fileId, String apiKey) throws ApiException, NoApiKeyException, InputRequiredException {
        if (threadId == null || threadId.isEmpty() || messageId == null || messageId.isEmpty() || fileId == null || fileId.isEmpty()) {
            throw new InputRequiredException("The threadId, messageId and fileId are required.");
        }
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("threads/%s/messages/%s/files/%s", threadId, messageId, fileId));
        DashScopeResult result = this.api.get(((GeneralGetParam.GeneralGetParamBuilder)GeneralGetParam.builder().apiKey(apiKey)).build(), this.serviceOption);
        return (MessageFile)FlattenResultBase.fromDashScopeResult(result, MessageFile.class);
    }

    public ListResult<MessageFile> listFiles(String threadId, String messageId, GeneralListParam listParam) throws ApiException, NoApiKeyException, InputRequiredException {
        if (threadId == null || threadId.isEmpty() || messageId == null || messageId.isEmpty()) {
            throw new InputRequiredException("The threadId and messageId are required.");
        }
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("threads/%s/messages/%s/files", threadId, messageId));
        DashScopeResult result = this.api.get(listParam, this.serviceOption);
        Type typeOfT = new TypeToken<ListResult<MessageFile>>(){}.getType();
        return (ListResult)FlattenResultBase.fromDashScopeResult(result, typeOfT);
    }
}

