/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.generation;

import com.alibaba.dashscope.aigc.generation.GenerationParamBase;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenerationParam
extends GenerationParamBase {
    private List<Message> messages;
    private Double topP;
    private Integer topK;
    private Boolean enableSearch;
    private Integer seed;
    @SerializedName(value="result_format")
    private String resultFormat;
    private Float temperature;
    private Boolean incrementalOutput;
    private Integer maxTokens;
    private Float repetitionPenalty;
    private List<String> stopStrings;
    private List<List<Integer>> stopTokens;

    @Override
    public JsonObject getInput() {
        JsonObject jsonObject = new JsonObject();
        JsonArray requestMessages = new JsonArray();
        if (this.getMessages() != null && !this.getMessages().isEmpty()) {
            requestMessages.addAll(JsonUtils.toJsonArray(this.getMessages()));
            if (this.getPrompt() != null) {
                Object msg = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role(Role.USER.getValue())).content(this.getPrompt())).build();
                requestMessages.add(JsonUtils.toJsonElement(msg));
            }
            jsonObject.add("messages", (JsonElement)requestMessages);
        } else if (this.getHistory() != null && !this.getHistory().isEmpty()) {
            JsonArray ar = JsonUtils.toJsonElement(this.getHistory()).getAsJsonArray();
            jsonObject.add("history", (JsonElement)ar);
            if (this.getPrompt() != null) {
                jsonObject.addProperty("prompt", this.getPrompt());
            }
        } else if (this.getPrompt() != null) {
            jsonObject.addProperty("prompt", this.getPrompt());
        }
        return jsonObject;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.topP != null) {
            params.put("top_p", this.topP);
        }
        if (this.topK != null) {
            params.put("top_k", this.topK);
        }
        if (this.enableSearch.booleanValue()) {
            params.put("enable_search", this.enableSearch);
        }
        if (ResultFormat.MESSAGE.equals(this.getResultFormat())) {
            params.put("result_format", this.getResultFormat());
        }
        if (this.seed != null) {
            params.put("seed", this.seed);
        }
        if (this.temperature != null) {
            params.put("temperature", this.temperature);
        }
        if (this.incrementalOutput.booleanValue()) {
            params.put("incremental_output", this.incrementalOutput);
        }
        if (this.repetitionPenalty != null) {
            params.put("repetition_penalty", this.repetitionPenalty);
        }
        if (this.maxTokens != null) {
            params.put("max_tokens", this.maxTokens);
        }
        if (this.stopStrings != null && !this.stopStrings.isEmpty()) {
            params.put("stop", this.stopStrings);
        } else if (this.stopTokens != null && !this.stopTokens.isEmpty()) {
            params.put("stop", this.stopTokens);
        }
        params.putAll(this.parameters);
        return params;
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.getPrompt() == null && (this.getHistory() == null || this.getHistory().isEmpty()) && (this.getMessages() == null || this.getMessages().isEmpty())) {
            throw new InputRequiredException("messages and prompt must not all null");
        }
    }

    private static Boolean $default$enableSearch() {
        return false;
    }

    private static String $default$resultFormat() {
        return ResultFormat.TEXT;
    }

    private static Boolean $default$incrementalOutput() {
        return false;
    }

    protected GenerationParam(GenerationParamBuilder<?, ?> b) {
        super((GenerationParamBase.GenerationParamBaseBuilder<?, ?>)b);
        List<Object> stopTokens;
        List<Object> stopStrings;
        this.messages = ((GenerationParamBuilder)b).messages;
        this.topP = ((GenerationParamBuilder)b).topP;
        this.topK = ((GenerationParamBuilder)b).topK;
        this.enableSearch = ((GenerationParamBuilder)b).enableSearch$set ? ((GenerationParamBuilder)b).enableSearch$value : GenerationParam.$default$enableSearch();
        this.seed = ((GenerationParamBuilder)b).seed;
        this.resultFormat = ((GenerationParamBuilder)b).resultFormat$set ? ((GenerationParamBuilder)b).resultFormat$value : GenerationParam.$default$resultFormat();
        this.temperature = ((GenerationParamBuilder)b).temperature;
        this.incrementalOutput = ((GenerationParamBuilder)b).incrementalOutput$set ? ((GenerationParamBuilder)b).incrementalOutput$value : GenerationParam.$default$incrementalOutput();
        this.maxTokens = ((GenerationParamBuilder)b).maxTokens;
        this.repetitionPenalty = ((GenerationParamBuilder)b).repetitionPenalty;
        switch (((GenerationParamBuilder)b).stopStrings == null ? 0 : ((GenerationParamBuilder)b).stopStrings.size()) {
            case 0: {
                stopStrings = Collections.emptyList();
                break;
            }
            case 1: {
                stopStrings = Collections.singletonList(((GenerationParamBuilder)b).stopStrings.get(0));
                break;
            }
            default: {
                stopStrings = Collections.unmodifiableList(new ArrayList(((GenerationParamBuilder)b).stopStrings));
            }
        }
        this.stopStrings = stopStrings;
        switch (((GenerationParamBuilder)b).stopTokens == null ? 0 : ((GenerationParamBuilder)b).stopTokens.size()) {
            case 0: {
                stopTokens = Collections.emptyList();
                break;
            }
            case 1: {
                stopTokens = Collections.singletonList(((GenerationParamBuilder)b).stopTokens.get(0));
                break;
            }
            default: {
                stopTokens = Collections.unmodifiableList(new ArrayList(((GenerationParamBuilder)b).stopTokens));
            }
        }
        this.stopTokens = stopTokens;
    }

    public static GenerationParamBuilder<?, ?> builder() {
        return new GenerationParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenerationParam)) {
            return false;
        }
        GenerationParam other = (GenerationParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        Boolean this$enableSearch = this.getEnableSearch();
        Boolean other$enableSearch = other.getEnableSearch();
        if (this$enableSearch == null ? other$enableSearch != null : !((Object)this$enableSearch).equals(other$enableSearch)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Boolean this$incrementalOutput = this.getIncrementalOutput();
        Boolean other$incrementalOutput = other.getIncrementalOutput();
        if (this$incrementalOutput == null ? other$incrementalOutput != null : !((Object)this$incrementalOutput).equals(other$incrementalOutput)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Float this$repetitionPenalty = this.getRepetitionPenalty();
        Float other$repetitionPenalty = other.getRepetitionPenalty();
        if (this$repetitionPenalty == null ? other$repetitionPenalty != null : !((Object)this$repetitionPenalty).equals(other$repetitionPenalty)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$resultFormat = this.getResultFormat();
        String other$resultFormat = other.getResultFormat();
        if (this$resultFormat == null ? other$resultFormat != null : !this$resultFormat.equals(other$resultFormat)) {
            return false;
        }
        List<String> this$stopStrings = this.getStopStrings();
        List<String> other$stopStrings = other.getStopStrings();
        if (this$stopStrings == null ? other$stopStrings != null : !((Object)this$stopStrings).equals(other$stopStrings)) {
            return false;
        }
        List<List<Integer>> this$stopTokens = this.getStopTokens();
        List<List<Integer>> other$stopTokens = other.getStopTokens();
        return !(this$stopTokens == null ? other$stopTokens != null : !((Object)this$stopTokens).equals(other$stopTokens));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GenerationParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        Boolean $enableSearch = this.getEnableSearch();
        result = result * 59 + ($enableSearch == null ? 43 : ((Object)$enableSearch).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Boolean $incrementalOutput = this.getIncrementalOutput();
        result = result * 59 + ($incrementalOutput == null ? 43 : ((Object)$incrementalOutput).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Float $repetitionPenalty = this.getRepetitionPenalty();
        result = result * 59 + ($repetitionPenalty == null ? 43 : ((Object)$repetitionPenalty).hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $resultFormat = this.getResultFormat();
        result = result * 59 + ($resultFormat == null ? 43 : $resultFormat.hashCode());
        List<String> $stopStrings = this.getStopStrings();
        result = result * 59 + ($stopStrings == null ? 43 : ((Object)$stopStrings).hashCode());
        List<List<Integer>> $stopTokens = this.getStopTokens();
        result = result * 59 + ($stopTokens == null ? 43 : ((Object)$stopTokens).hashCode());
        return result;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Boolean getEnableSearch() {
        return this.enableSearch;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public String getResultFormat() {
        return this.resultFormat;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Boolean getIncrementalOutput() {
        return this.incrementalOutput;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Float getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public List<String> getStopStrings() {
        return this.stopStrings;
    }

    public List<List<Integer>> getStopTokens() {
        return this.stopTokens;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public void setEnableSearch(Boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public void setResultFormat(String resultFormat) {
        this.resultFormat = resultFormat;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public void setIncrementalOutput(Boolean incrementalOutput) {
        this.incrementalOutput = incrementalOutput;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setRepetitionPenalty(Float repetitionPenalty) {
        this.repetitionPenalty = repetitionPenalty;
    }

    public void setStopStrings(List<String> stopStrings) {
        this.stopStrings = stopStrings;
    }

    public void setStopTokens(List<List<Integer>> stopTokens) {
        this.stopTokens = stopTokens;
    }

    @Override
    public String toString() {
        return "GenerationParam(messages=" + this.getMessages() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ", enableSearch=" + this.getEnableSearch() + ", seed=" + this.getSeed() + ", resultFormat=" + this.getResultFormat() + ", temperature=" + this.getTemperature() + ", incrementalOutput=" + this.getIncrementalOutput() + ", maxTokens=" + this.getMaxTokens() + ", repetitionPenalty=" + this.getRepetitionPenalty() + ", stopStrings=" + this.getStopStrings() + ", stopTokens=" + this.getStopTokens() + ")";
    }

    private static final class GenerationParamBuilderImpl
    extends GenerationParamBuilder<GenerationParam, GenerationParamBuilderImpl> {
        private GenerationParamBuilderImpl() {
        }

        @Override
        protected GenerationParamBuilderImpl self() {
            return this;
        }

        @Override
        public GenerationParam build() {
            return new GenerationParam(this);
        }
    }

    public static abstract class GenerationParamBuilder<C extends GenerationParam, B extends GenerationParamBuilder<C, B>>
    extends GenerationParamBase.GenerationParamBaseBuilder<C, B> {
        private List<Message> messages;
        private Double topP;
        private Integer topK;
        private boolean enableSearch$set;
        private Boolean enableSearch$value;
        private Integer seed;
        private boolean resultFormat$set;
        private String resultFormat$value;
        private Float temperature;
        private boolean incrementalOutput$set;
        private Boolean incrementalOutput$value;
        private Integer maxTokens;
        private Float repetitionPenalty;
        private ArrayList<String> stopStrings;
        private ArrayList<List<Integer>> stopTokens;

        public B messages(List<Message> messages) {
            this.messages = messages;
            return (B)this.self();
        }

        public B topP(Double topP) {
            this.topP = topP;
            return (B)this.self();
        }

        public B topK(Integer topK) {
            this.topK = topK;
            return (B)this.self();
        }

        public B enableSearch(Boolean enableSearch) {
            this.enableSearch$value = enableSearch;
            this.enableSearch$set = true;
            return (B)this.self();
        }

        public B seed(Integer seed) {
            this.seed = seed;
            return (B)this.self();
        }

        public B resultFormat(String resultFormat) {
            this.resultFormat$value = resultFormat;
            this.resultFormat$set = true;
            return (B)this.self();
        }

        public B temperature(Float temperature) {
            this.temperature = temperature;
            return (B)this.self();
        }

        public B incrementalOutput(Boolean incrementalOutput) {
            this.incrementalOutput$value = incrementalOutput;
            this.incrementalOutput$set = true;
            return (B)this.self();
        }

        public B maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return (B)this.self();
        }

        public B repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return (B)this.self();
        }

        public B stopString(String stopString) {
            if (this.stopStrings == null) {
                this.stopStrings = new ArrayList();
            }
            this.stopStrings.add(stopString);
            return (B)this.self();
        }

        public B stopStrings(Collection<? extends String> stopStrings) {
            if (stopStrings == null) {
                throw new NullPointerException("stopStrings cannot be null");
            }
            if (this.stopStrings == null) {
                this.stopStrings = new ArrayList();
            }
            this.stopStrings.addAll(stopStrings);
            return (B)this.self();
        }

        public B clearStopStrings() {
            if (this.stopStrings != null) {
                this.stopStrings.clear();
            }
            return (B)this.self();
        }

        public B stopToken(List<Integer> stopToken) {
            if (this.stopTokens == null) {
                this.stopTokens = new ArrayList();
            }
            this.stopTokens.add(stopToken);
            return (B)this.self();
        }

        public B stopTokens(Collection<? extends List<Integer>> stopTokens) {
            if (stopTokens == null) {
                throw new NullPointerException("stopTokens cannot be null");
            }
            if (this.stopTokens == null) {
                this.stopTokens = new ArrayList();
            }
            this.stopTokens.addAll(stopTokens);
            return (B)this.self();
        }

        public B clearStopTokens() {
            if (this.stopTokens != null) {
                this.stopTokens.clear();
            }
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "GenerationParam.GenerationParamBuilder(super=" + super.toString() + ", messages=" + this.messages + ", topP=" + this.topP + ", topK=" + this.topK + ", enableSearch$value=" + this.enableSearch$value + ", seed=" + this.seed + ", resultFormat$value=" + this.resultFormat$value + ", temperature=" + this.temperature + ", incrementalOutput$value=" + this.incrementalOutput$value + ", maxTokens=" + this.maxTokens + ", repetitionPenalty=" + this.repetitionPenalty + ", stopStrings=" + this.stopStrings + ", stopTokens=" + this.stopTokens + ")";
        }
    }

    public static class ResultFormat {
        public static String TEXT = "text";
        public static String MESSAGE = "message";
    }
}

