/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq;

import com.alibaba.cloud.stream.binder.rocketmq.RocketMQBinderUtils;
import com.alibaba.cloud.stream.binder.rocketmq.consuming.RocketMQListenerBindingContainer;
import com.alibaba.cloud.stream.binder.rocketmq.integration.RocketMQInboundChannelAdapter;
import com.alibaba.cloud.stream.binder.rocketmq.integration.RocketMQMessageHandler;
import com.alibaba.cloud.stream.binder.rocketmq.integration.RocketMQMessageSource;
import com.alibaba.cloud.stream.binder.rocketmq.metrics.InstrumentationManager;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQBinderConfigurationProperties;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQConsumerProperties;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQExtendedBindingProperties;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQProducerProperties;
import com.alibaba.cloud.stream.binder.rocketmq.provisioning.RocketMQTopicProvisioner;
import com.alibaba.cloud.stream.binder.rocketmq.provisioning.selector.PartitionMessageQueueSelector;
import com.alibaba.cloud.stream.binder.rocketmq.support.JacksonRocketMQHeaderMapper;
import com.alibaba.cloud.stream.binder.rocketmq.support.RocketMQHeaderMapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.spring.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.apache.rocketmq.spring.support.RocketMQUtil;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binding.MessageConverterConfigurer;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.acks.AcknowledgmentCallback;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.retry.RecoveryCallback;
import org.springframework.util.StringUtils;

public class RocketMQMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<RocketMQConsumerProperties>, ExtendedProducerProperties<RocketMQProducerProperties>, RocketMQTopicProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, RocketMQConsumerProperties, RocketMQProducerProperties> {
    private RocketMQExtendedBindingProperties extendedBindingProperties = new RocketMQExtendedBindingProperties();
    private final RocketMQBinderConfigurationProperties rocketBinderConfigurationProperties;
    private final RocketMQProperties rocketMQProperties;
    private final InstrumentationManager instrumentationManager;
    private Map<String, String> topicInUse = new HashMap<String, String>();

    public RocketMQMessageChannelBinder(RocketMQTopicProvisioner provisioningProvider, RocketMQExtendedBindingProperties extendedBindingProperties, RocketMQBinderConfigurationProperties rocketBinderConfigurationProperties, RocketMQProperties rocketMQProperties, InstrumentationManager instrumentationManager) {
        super(null, (ProvisioningProvider)provisioningProvider);
        this.extendedBindingProperties = extendedBindingProperties;
        this.rocketBinderConfigurationProperties = rocketBinderConfigurationProperties;
        this.rocketMQProperties = rocketMQProperties;
        this.instrumentationManager = instrumentationManager;
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<RocketMQProducerProperties> producerProperties, MessageChannel channel, MessageChannel errorChannel) throws Exception {
        if (((RocketMQProducerProperties)producerProperties.getExtension()).getEnabled().booleanValue()) {
            RocketMQTemplate rocketMQTemplate;
            String extendedProducerGroup = ((RocketMQProducerProperties)producerProperties.getExtension()).getGroup();
            String producerGroup = StringUtils.isEmpty((Object)extendedProducerGroup) ? destination.getName() : extendedProducerGroup;
            RocketMQBinderConfigurationProperties mergedProperties = RocketMQBinderUtils.mergeProperties(this.rocketBinderConfigurationProperties, this.rocketMQProperties);
            if (((RocketMQProducerProperties)producerProperties.getExtension()).getTransactional().booleanValue()) {
                Map rocketMQTemplates = this.getBeanFactory().getBeansOfType(RocketMQTemplate.class);
                if (rocketMQTemplates.size() == 0) {
                    throw new IllegalStateException("there is no RocketMQTemplate in Spring BeanFactory");
                }
                if (rocketMQTemplates.size() > 1) {
                    throw new IllegalStateException("there is more than 1 RocketMQTemplates in Spring BeanFactory");
                }
                rocketMQTemplate = (RocketMQTemplate)rocketMQTemplates.values().iterator().next();
            } else {
                DefaultMQProducer producer;
                rocketMQTemplate = new RocketMQTemplate();
                rocketMQTemplate.setObjectMapper((ObjectMapper)this.getApplicationContext().getBeansOfType(ObjectMapper.class).values().iterator().next());
                String ak = mergedProperties.getAccessKey();
                String sk = mergedProperties.getSecretKey();
                if (!StringUtils.isEmpty((Object)ak) && !StringUtils.isEmpty((Object)sk)) {
                    AclClientRPCHook rpcHook = new AclClientRPCHook(new SessionCredentials(ak, sk));
                    producer = new DefaultMQProducer(producerGroup, (RPCHook)rpcHook, mergedProperties.isEnableMsgTrace(), mergedProperties.getCustomizedTraceTopic());
                    producer.setVipChannelEnabled(false);
                    producer.setInstanceName(RocketMQUtil.getInstanceName((RPCHook)rpcHook, (String)(destination.getName() + "|" + UtilAll.getPid())));
                } else {
                    producer = new DefaultMQProducer(producerGroup);
                    producer.setVipChannelEnabled(((RocketMQProducerProperties)producerProperties.getExtension()).getVipChannelEnabled().booleanValue());
                }
                producer.setNamesrvAddr(mergedProperties.getNameServer());
                producer.setSendMsgTimeout(((RocketMQProducerProperties)producerProperties.getExtension()).getSendMessageTimeout());
                producer.setRetryTimesWhenSendFailed(((RocketMQProducerProperties)producerProperties.getExtension()).getRetryTimesWhenSendFailed());
                producer.setRetryTimesWhenSendAsyncFailed(((RocketMQProducerProperties)producerProperties.getExtension()).getRetryTimesWhenSendAsyncFailed());
                producer.setCompressMsgBodyOverHowmuch(((RocketMQProducerProperties)producerProperties.getExtension()).getCompressMessageBodyThreshold());
                producer.setRetryAnotherBrokerWhenNotStoreOK(((RocketMQProducerProperties)producerProperties.getExtension()).isRetryNextServer());
                producer.setMaxMessageSize(((RocketMQProducerProperties)producerProperties.getExtension()).getMaxMessageSize().intValue());
                rocketMQTemplate.setProducer(producer);
                if (producerProperties.isPartitioned()) {
                    rocketMQTemplate.setMessageQueueSelector((MessageQueueSelector)new PartitionMessageQueueSelector());
                }
            }
            RocketMQMessageHandler messageHandler = new RocketMQMessageHandler(rocketMQTemplate, destination.getName(), producerGroup, ((RocketMQProducerProperties)producerProperties.getExtension()).getTransactional(), this.instrumentationManager, producerProperties, ((AbstractMessageChannel)channel).getChannelInterceptors().stream().filter(channelInterceptor -> channelInterceptor instanceof MessageConverterConfigurer.PartitioningInterceptor).map(channelInterceptor -> (MessageConverterConfigurer.PartitioningInterceptor)channelInterceptor).findFirst().orElse(null));
            messageHandler.setBeanFactory((BeanFactory)this.getApplicationContext().getBeanFactory());
            messageHandler.setSync(((RocketMQProducerProperties)producerProperties.getExtension()).getSync());
            messageHandler.setHeaderMapper(this.createHeaderMapper(producerProperties));
            if (errorChannel != null) {
                messageHandler.setSendFailureChannel(errorChannel);
            }
            return messageHandler;
        }
        throw new RuntimeException("Binding for channel " + destination.getName() + " has been disabled, message can't be delivered");
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<RocketMQProducerProperties> producerProperties, MessageChannel errorChannel) throws Exception {
        throw new UnsupportedOperationException("The abstract binder should not call this method");
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<RocketMQConsumerProperties> consumerProperties) throws Exception {
        if (group == null || "".equals(group)) {
            throw new RuntimeException("'group must be configured for channel " + destination.getName());
        }
        RocketMQListenerBindingContainer listenerContainer = new RocketMQListenerBindingContainer(consumerProperties, this.rocketBinderConfigurationProperties, this);
        listenerContainer.setConsumerGroup(group);
        listenerContainer.setTopic(destination.getName());
        listenerContainer.setConsumeThreadMax(consumerProperties.getConcurrency());
        listenerContainer.setSuspendCurrentQueueTimeMillis(((RocketMQConsumerProperties)consumerProperties.getExtension()).getSuspendCurrentQueueTimeMillis());
        listenerContainer.setDelayLevelWhenNextConsume(((RocketMQConsumerProperties)consumerProperties.getExtension()).getDelayLevelWhenNextConsume());
        listenerContainer.setNameServer(this.rocketBinderConfigurationProperties.getNameServer());
        listenerContainer.setHeaderMapper(this.createHeaderMapper(consumerProperties));
        RocketMQInboundChannelAdapter rocketInboundChannelAdapter = new RocketMQInboundChannelAdapter(listenerContainer, consumerProperties, this.instrumentationManager);
        this.topicInUse.put(destination.getName(), group);
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(destination, group, (ConsumerProperties)consumerProperties);
        if (consumerProperties.getMaxAttempts() > 1) {
            rocketInboundChannelAdapter.setRetryTemplate(this.buildRetryTemplate((ConsumerProperties)consumerProperties));
            rocketInboundChannelAdapter.setRecoveryCallback((RecoveryCallback<? extends Object>)errorInfrastructure.getRecoverer());
        } else {
            rocketInboundChannelAdapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        }
        return rocketInboundChannelAdapter;
    }

    protected AbstractMessageChannelBinder.PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, ExtendedConsumerProperties<RocketMQConsumerProperties> consumerProperties) {
        RocketMQMessageSource rocketMQMessageSource = new RocketMQMessageSource(this.rocketBinderConfigurationProperties, consumerProperties, name, group);
        return new AbstractMessageChannelBinder.PolledConsumerResources((MessageSource)rocketMQMessageSource, this.registerErrorInfrastructure(destination, group, (ConsumerProperties)consumerProperties, true));
    }

    protected MessageHandler getPolledConsumerErrorMessageHandler(ConsumerDestination destination, String group, ExtendedConsumerProperties<RocketMQConsumerProperties> properties) {
        return message -> {
            AcknowledgmentCallback ack;
            if (message.getPayload() instanceof MessagingException && (ack = StaticMessageHeaderAccessor.getAcknowledgmentCallback((Message)((MessagingException)message.getPayload()).getFailedMessage())) != null) {
                if (((RocketMQConsumerProperties)properties.getExtension()).shouldRequeue()) {
                    ack.acknowledge(AcknowledgmentCallback.Status.REQUEUE);
                } else {
                    ack.acknowledge(AcknowledgmentCallback.Status.REJECT);
                }
            }
        };
    }

    public RocketMQConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (RocketMQConsumerProperties)this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public RocketMQProducerProperties getExtendedProducerProperties(String channelName) {
        return (RocketMQProducerProperties)this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    public Map<String, String> getTopicInUse() {
        return this.topicInUse;
    }

    public String getDefaultsPrefix() {
        return this.extendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.extendedBindingProperties.getExtendedPropertiesEntryClass();
    }

    public void setExtendedBindingProperties(RocketMQExtendedBindingProperties extendedBindingProperties) {
        this.extendedBindingProperties = extendedBindingProperties;
    }

    private RocketMQHeaderMapper createHeaderMapper(ExtendedConsumerProperties<RocketMQConsumerProperties> extendedConsumerProperties) {
        Set<String> trustedPackages = ((RocketMQConsumerProperties)extendedConsumerProperties.getExtension()).getTrustedPackages();
        return this.createHeaderMapper(trustedPackages);
    }

    private RocketMQHeaderMapper createHeaderMapper(ExtendedProducerProperties<RocketMQProducerProperties> producerProperties) {
        return this.createHeaderMapper(Collections.emptyList());
    }

    private RocketMQHeaderMapper createHeaderMapper(Collection<String> trustedPackages) {
        ObjectMapper objectMapper = (ObjectMapper)this.getApplicationContext().getBeansOfType(ObjectMapper.class).values().iterator().next();
        JacksonRocketMQHeaderMapper headerMapper = new JacksonRocketMQHeaderMapper(objectMapper);
        if (!StringUtils.isEmpty(trustedPackages)) {
            headerMapper.addTrustedPackages(trustedPackages);
        }
        return headerMapper;
    }
}

