/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.oss.resource;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.OSSObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class OssStorageResource
implements Resource {
    private final OSS oss;
    private final String bucketName;
    private final String objectKey;
    private final URI location;

    public OssStorageResource(OSS oss, String location) {
        Assert.notNull((Object)oss, (String)"Object Storage Service can not be null");
        Assert.isTrue((boolean)location.startsWith("oss://"), (String)"Location must start with oss://");
        this.oss = oss;
        try {
            URI locationUri = new URI(location);
            this.bucketName = locationUri.getAuthority();
            this.objectKey = locationUri.getPath() != null && locationUri.getPath().length() > 1 ? locationUri.getPath().substring(1) : null;
            this.location = locationUri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid location: " + location, e);
        }
    }

    public boolean exists() {
        try {
            return this.isBucket() ? this.getBucket() != null : this.getOSSObject() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public URL getURL() throws IOException {
        return this.location.toURL();
    }

    public URI getURI() throws IOException {
        return this.location;
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    public long contentLength() throws IOException {
        this.assertExisted();
        if (this.isBucket()) {
            throw new FileNotFoundException("OSSObject not existed.");
        }
        return this.getOSSObject().getObjectMetadata().getContentLength();
    }

    public long lastModified() throws IOException {
        this.assertExisted();
        if (this.isBucket()) {
            throw new FileNotFoundException("OSSObject not existed.");
        }
        return this.getOSSObject().getObjectMetadata().getLastModified().getTime();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return new OssStorageResource(this.oss, this.location.resolve(relativePath).toString());
    }

    public String getFilename() {
        return this.isBucket() ? this.bucketName : this.objectKey;
    }

    public String getDescription() {
        return this.location.toString();
    }

    public InputStream getInputStream() throws IOException {
        this.assertExisted();
        if (this.isBucket()) {
            throw new IllegalStateException("Cannot open an input stream to a bucket: '" + this.location + "'");
        }
        return this.getOSSObject().getObjectContent();
    }

    public Bucket getBucket() {
        return this.oss.listBuckets().stream().filter(bucket -> bucket.getName().equals(this.bucketName)).findFirst().get();
    }

    public boolean bucketExists() {
        return this.getBucket() != null;
    }

    public OSSObject getOSSObject() {
        return this.oss.getObject(this.bucketName, this.objectKey);
    }

    public boolean isBucket() {
        return this.objectKey == null;
    }

    private void assertExisted() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException("Bucket or OSSObject not existed.");
        }
    }
}

