/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.metadata.repository;

import com.alibaba.cloud.dubbo.env.DubboCloudProperties;
import com.alibaba.cloud.dubbo.http.DefaultHttpRequest;
import com.alibaba.cloud.dubbo.http.matcher.RequestMetadataMatcher;
import com.alibaba.cloud.dubbo.metadata.DubboRestServiceMetadata;
import com.alibaba.cloud.dubbo.metadata.RequestMetadata;
import com.alibaba.cloud.dubbo.metadata.RestMethodMetadata;
import com.alibaba.cloud.dubbo.metadata.ServiceRestMetadata;
import com.alibaba.cloud.dubbo.registry.event.SubscribedServicesChangedEvent;
import com.alibaba.cloud.dubbo.service.DubboMetadataService;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceExporter;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceProxy;
import com.alibaba.cloud.dubbo.util.JSONUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.dubbo.common.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpRequest;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

@Repository
public class DubboServiceMetadataRepository
implements SmartInitializingSingleton,
ApplicationEventPublisherAware {
    public static final String DUBBO_METADATA_SERVICE_PREFIX = "dubbo.metadata-service.";
    public static final String DUBBO_METADATA_SERVICE_URLS_PROPERTY_NAME = "dubbo.metadata-service.urls";
    public static final String DUBBO_PROTOCOLS_PORT_PROPERTY_NAME_PATTERN = "dubbo.protocols.%s.port";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Object monitor = new Object();
    private final Set<String> initializedServices = new LinkedHashSet<String>();
    private final MultiValueMap<String, URL> allExportedURLs = new LinkedMultiValueMap();
    private final MultiValueMap<String, URL> subscribedDubboMetadataServiceURLs = new LinkedMultiValueMap();
    private final Set<ServiceRestMetadata> serviceRestMetadata = new LinkedHashSet<ServiceRestMetadata>();
    private ApplicationEventPublisher applicationEventPublisher;
    private volatile Set<String> subscribedServices = Collections.emptySet();
    private Map<String, Map<RequestMetadataMatcher, DubboRestServiceMetadata>> dubboRestServiceMetadataRepository = DubboServiceMetadataRepository.newHashMap();
    @Autowired
    private DubboCloudProperties dubboCloudProperties;
    @Autowired
    private DubboMetadataServiceProxy dubboMetadataConfigServiceProxy;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private JSONUtils jsonUtils;
    @Autowired
    private InetUtils inetUtils;
    @Value(value="${spring.application.name}")
    private String currentApplicationName;
    @Autowired
    private DubboMetadataServiceExporter dubboMetadataServiceExporter;

    private static <K, V> Map<K, V> getMap(Map<String, Map<K, V>> repository, String key) {
        return DubboServiceMetadataRepository.getOrDefault(repository, key, DubboServiceMetadataRepository.newHashMap());
    }

    private static <K, V> V getOrDefault(Map<K, V> source, K key, V defaultValue) {
        V value = source.get(key);
        if (value == null) {
            value = defaultValue;
            source.put(key, value);
        }
        return value;
    }

    private static <K, V> Map<K, V> newHashMap() {
        return new LinkedHashMap();
    }

    @PostConstruct
    public Stream<String> initSubscribedServices() {
        LinkedHashSet<String> newSubscribedServices = new LinkedHashSet<String>();
        if ("*".equals(this.dubboCloudProperties.getSubscribedServices())) {
            List services = this.discoveryClient.getServices();
            newSubscribedServices.addAll(services);
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Current application will subscribe all services(size:{}) in registry, a lot of memory and CPU cycles may be used, thus it's strongly recommend you using the externalized property '{}' to specify the services", (Object)newSubscribedServices.size(), (Object)"dubbo.cloud.subscribed-services");
            }
        } else {
            newSubscribedServices.addAll(this.dubboCloudProperties.subscribedServices());
        }
        this.excludeSelf(newSubscribedServices);
        Set<String> oldSubscribedServices = this.subscribedServices;
        this.subscribedServices = newSubscribedServices;
        this.dispatchEvent(new SubscribedServicesChangedEvent(this, oldSubscribedServices, newSubscribedServices));
        oldSubscribedServices.clear();
        return newSubscribedServices.stream();
    }

    private void dispatchEvent(ApplicationEvent event) {
        this.applicationEventPublisher.publishEvent(event);
    }

    public void afterSingletonsInstantiated() {
        this.initializeMetadata();
    }

    private void initializeMetadata() {
        this.doGetSubscribedServices().forEach(this::initializeMetadata);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The metadata of Dubbo services has been initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeMetadata(String serviceName) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.initializedServices.contains(serviceName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("The metadata of Dubbo service[name : {}] has been initialized", (Object)serviceName);
                }
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("The metadata of Dubbo service[name : {}] is about to be initialized", (Object)serviceName);
                }
                this.initSubscribedDubboMetadataService(serviceName);
                this.initDubboRestServiceMetadataRepository(serviceName);
                this.initializedServices.add(serviceName);
            }
        }
    }

    public Map<String, String> getDubboMetadataServiceMetadata() {
        List<URL> dubboMetadataServiceURLs = this.dubboMetadataServiceExporter.export();
        this.removeDubboMetadataServiceURLs(dubboMetadataServiceURLs);
        Map<String, String> metadata = DubboServiceMetadataRepository.newHashMap();
        this.addDubboMetadataServiceURLsMetadata(metadata, dubboMetadataServiceURLs);
        this.addDubboProtocolsPortMetadata(metadata);
        return Collections.unmodifiableMap(metadata);
    }

    private void removeDubboMetadataServiceURLs(List<URL> dubboMetadataServiceURLs) {
        dubboMetadataServiceURLs.forEach(this::unexportURL);
    }

    private void addDubboMetadataServiceURLsMetadata(Map<String, String> metadata, List<URL> dubboMetadataServiceURLs) {
        String dubboMetadataServiceURLsJSON = this.jsonUtils.toJSON(dubboMetadataServiceURLs);
        metadata.put(DUBBO_METADATA_SERVICE_URLS_PROPERTY_NAME, dubboMetadataServiceURLsJSON);
    }

    private void addDubboProtocolsPortMetadata(Map<String, String> metadata) {
        this.allExportedURLs.values().stream().flatMap(v -> v.stream()).forEach(url -> {
            String protocol = url.getProtocol();
            String propertyName = this.getDubboProtocolPropertyName(protocol);
            String propertyValue = String.valueOf(url.getPort());
            metadata.put(propertyName, propertyValue);
        });
    }

    public String getDubboProtocolPropertyName(String protocol) {
        return String.format(DUBBO_PROTOCOLS_PORT_PROPERTY_NAME_PATTERN, protocol);
    }

    public void publishServiceRestMetadata(Set<ServiceRestMetadata> serviceRestMetadataSet) {
        for (ServiceRestMetadata serviceRestMetadata : serviceRestMetadataSet) {
            if (CollectionUtils.isEmpty(serviceRestMetadata.getMeta())) continue;
            this.serviceRestMetadata.add(serviceRestMetadata);
        }
    }

    public Set<ServiceRestMetadata> getServiceRestMetadata() {
        return Collections.unmodifiableSet(this.serviceRestMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> findSubscribedDubboMetadataServiceURLs(String serviceName, String group, String version, String protocol) {
        String serviceKey = URL.buildKey((String)serviceName, (String)group, (String)version);
        List urls = null;
        Object object = this.monitor;
        synchronized (object) {
            urls = (List)this.subscribedDubboMetadataServiceURLs.get((Object)serviceKey);
        }
        if (CollectionUtils.isEmpty((Collection)urls)) {
            return Collections.emptyList();
        }
        return StringUtils.hasText((String)protocol) ? urls.stream().filter(url -> url.getProtocol().equalsIgnoreCase(protocol)).collect(Collectors.toList()) : Collections.unmodifiableList(urls);
    }

    public boolean isSubscribedService(String serviceName) {
        return this.doGetSubscribedServices().contains(serviceName);
    }

    public void exportURL(URL url) {
        URL actualURL = url;
        InetUtils.HostInfo hostInfo = this.inetUtils.findFirstNonLoopbackHostInfo();
        String ipAddress = hostInfo.getIpAddress();
        if (!Objects.equals(url.getHost(), ipAddress)) {
            actualURL = url.setHost(ipAddress);
        }
        this.allExportedURLs.add((Object)actualURL.getServiceKey(), (Object)actualURL);
    }

    public void unexportURL(URL url) {
        String key = url.getServiceKey();
        List urls = (List)this.allExportedURLs.get((Object)key);
        if (!CollectionUtils.isEmpty((Collection)urls)) {
            urls.remove(url);
            this.allExportedURLs.addAll((Object)key, urls);
        }
    }

    public Map<String, List<URL>> getAllExportedUrls() {
        return Collections.unmodifiableMap(this.allExportedURLs);
    }

    public Set<String> getAllServiceKeys() {
        return this.allExportedURLs.keySet();
    }

    public List<URL> getDubboMetadataServiceURLs(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        String dubboURLsJSON = (String)metadata.get(DUBBO_METADATA_SERVICE_URLS_PROPERTY_NAME);
        return this.jsonUtils.toURLs(dubboURLsJSON);
    }

    public Integer getDubboProtocolPort(ServiceInstance serviceInstance, String protocol) {
        String protocolProperty = this.getDubboProtocolPropertyName(protocol);
        Map metadata = serviceInstance.getMetadata();
        String protocolPort = (String)metadata.get(protocolProperty);
        return StringUtils.hasText((String)protocolPort) ? Integer.valueOf(protocolPort) : null;
    }

    public List<URL> getExportedURLs(String serviceInterface, String group, String version) {
        String serviceKey = URL.buildKey((String)serviceInterface, (String)group, (String)version);
        return (List)this.allExportedURLs.getOrDefault((Object)serviceKey, Collections.emptyList());
    }

    protected void initDubboRestServiceMetadataRepository(String serviceName) {
        if (this.dubboRestServiceMetadataRepository.containsKey(serviceName)) {
            return;
        }
        Set<ServiceRestMetadata> serviceRestMetadataSet = this.getServiceRestMetadataSet(serviceName);
        if (CollectionUtils.isEmpty(serviceRestMetadataSet)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("The Spring application[name : {}] does not expose The REST metadata in the Dubbo services.", (Object)serviceName);
            }
            return;
        }
        Map<RequestMetadataMatcher, DubboRestServiceMetadata> metadataMap = this.getMetadataMap(serviceName);
        for (ServiceRestMetadata serviceRestMetadata : serviceRestMetadataSet) {
            serviceRestMetadata.getMeta().forEach(restMethodMetadata -> {
                RequestMetadata requestMetadata = restMethodMetadata.getRequest();
                RequestMetadataMatcher matcher = new RequestMetadataMatcher(requestMetadata);
                DubboRestServiceMetadata metadata = new DubboRestServiceMetadata(serviceRestMetadata, (RestMethodMetadata)restMethodMetadata);
                metadataMap.put(matcher, metadata);
            });
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The REST metadata in the dubbo services has been loaded in the Spring application[name : {}]", (Object)serviceName);
        }
    }

    public DubboRestServiceMetadata get(String serviceName, RequestMetadata requestMetadata) {
        return (DubboRestServiceMetadata)this.match(this.dubboRestServiceMetadataRepository, serviceName, requestMetadata);
    }

    protected Set<String> doGetSubscribedServices() {
        Set<String> subscribedServices = this.subscribedServices;
        return subscribedServices == null ? Collections.emptySet() : subscribedServices;
    }

    public Set<String> getSubscribedServices() {
        return Collections.unmodifiableSet(this.doGetSubscribedServices());
    }

    private <T> T match(Map<String, Map<RequestMetadataMatcher, T>> repository, String serviceName, RequestMetadata requestMetadata) {
        RequestMetadataMatcher matcher;
        Map<RequestMetadataMatcher, T> map = repository.get(serviceName);
        T object = null;
        if (!CollectionUtils.isEmpty(map) && (object = (T)map.get(matcher = new RequestMetadataMatcher(requestMetadata))) == null) {
            HttpRequest request = DefaultHttpRequest.builder().method(requestMetadata.getMethod()).path(requestMetadata.getPath()).params((Map<String, List<String>>)requestMetadata.getParams()).headers(requestMetadata.getHeaders()).build();
            for (Map.Entry<RequestMetadataMatcher, T> entry : map.entrySet()) {
                RequestMetadataMatcher possibleMatcher = entry.getKey();
                if (!possibleMatcher.match(request)) continue;
                object = entry.getValue();
                break;
            }
        }
        if (object == null && this.logger.isWarnEnabled()) {
            this.logger.warn("DubboServiceMetadata can't be found in the Spring application [%s] and %s", (Object)serviceName, (Object)requestMetadata);
        }
        return object;
    }

    private Map<RequestMetadataMatcher, DubboRestServiceMetadata> getMetadataMap(String serviceName) {
        return DubboServiceMetadataRepository.getMap(this.dubboRestServiceMetadataRepository, serviceName);
    }

    private Set<ServiceRestMetadata> getServiceRestMetadataSet(String serviceName) {
        Set metadata;
        block4: {
            metadata = Collections.emptySet();
            DubboMetadataService dubboMetadataService = this.dubboMetadataConfigServiceProxy.getProxy(serviceName);
            if (dubboMetadataService != null) {
                try {
                    String serviceRestMetadataJsonConfig = dubboMetadataService.getServiceRestMetadata();
                    if (StringUtils.hasText((String)serviceRestMetadataJsonConfig)) {
                        metadata = (Set)this.objectMapper.readValue(serviceRestMetadataJsonConfig, (JavaType)TypeFactory.defaultInstance().constructCollectionType(LinkedHashSet.class, ServiceRestMetadata.class));
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block4;
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return metadata;
    }

    private void excludeSelf(Set<String> subscribedServices) {
        subscribedServices.remove(this.currentApplicationName);
    }

    protected void initSubscribedDubboMetadataService(String serviceName) {
        this.discoveryClient.getInstances(serviceName).stream().findAny().map(this::getDubboMetadataServiceURLs).ifPresent(dubboMetadataServiceURLs -> dubboMetadataServiceURLs.forEach(dubboMetadataServiceURL -> {
            block2: {
                try {
                    this.initSubscribedDubboMetadataServiceURL((URL)dubboMetadataServiceURL);
                    this.initDubboMetadataServiceProxy((URL)dubboMetadataServiceURL);
                }
                catch (Throwable e) {
                    if (!this.logger.isErrorEnabled()) break block2;
                    this.logger.error(e.getMessage(), e);
                }
            }
        }));
    }

    private void initSubscribedDubboMetadataServiceURL(URL dubboMetadataServiceURL) {
        String serviceKey = dubboMetadataServiceURL.getServiceKey();
        this.subscribedDubboMetadataServiceURLs.add((Object)serviceKey, (Object)dubboMetadataServiceURL);
    }

    private void initDubboMetadataServiceProxy(URL dubboMetadataServiceURL) {
        String serviceName = dubboMetadataServiceURL.getParameter("application");
        String version = dubboMetadataServiceURL.getParameter("version");
        this.dubboMetadataConfigServiceProxy.initProxy(serviceName, version);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

