/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import com.alibaba.cloud.nacos.NacosConfigEnabledCondition;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.annotation.NacosAnnotationProcessor;
import com.alibaba.cloud.nacos.refresh.NacosContextRefresher;
import com.alibaba.cloud.nacos.refresh.NacosRefreshHistory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@Conditional(value={NacosConfigEnabledCondition.class})
public class NacosConfigAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={NacosConfigProperties.class}, search=SearchStrategy.CURRENT)
    public NacosConfigProperties nacosConfigProperties(ApplicationContext context) {
        if (context.getParent() != null && BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getParent(), NacosConfigProperties.class).length > 0) {
            return (NacosConfigProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)context.getParent(), NacosConfigProperties.class);
        }
        if (NacosConfigManager.getInstance() == null) {
            return new NacosConfigProperties();
        }
        return NacosConfigManager.getInstance().getNacosConfigProperties();
    }

    @Bean
    public NacosRefreshHistory nacosRefreshHistory() {
        return new NacosRefreshHistory();
    }

    @Bean
    public NacosConfigManager nacosConfigManager(NacosConfigProperties nacosConfigProperties) {
        return NacosConfigManager.getInstance(nacosConfigProperties);
    }

    @Bean
    public static NacosAnnotationProcessor nacosAnnotationProcessor() {
        return new NacosAnnotationProcessor();
    }

    @Bean
    public NacosContextRefresher nacosContextRefresher(NacosConfigManager nacosConfigManager, NacosRefreshHistory nacosRefreshHistory) {
        return new NacosContextRefresher(nacosConfigManager, nacosRefreshHistory);
    }
}

