/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context.statistics;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

/**
 * @author xiaolongzuo
 */
class ManagedReportTask extends AbstractReportTask {

    private static final String DEFAULT_STATISTICS_URL = "http://edas-internal.console.aliyun.com/sca/statistics.json";

    ManagedReportTask(long interval, Map<String, String> params) {
        super(interval, params);
    }

    @Override
    protected String getUrl() {
        return DEFAULT_STATISTICS_URL;
    }

    @Override
    protected void quickRequest(String url, Map<String, String> params) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (String key : params.keySet()) {
                stringBuffer.append(key).append("=").append(params.get(key)).append("&");
            }
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.connect();
            if (params != null && params.size() > 0) {
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(stringBuffer.substring(0, stringBuffer.length() - 1).getBytes("UTF-8"));
                outputStream.flush();
            }
            connection.getInputStream();
            connection.disconnect();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

}
