/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context.edas;

import com.alibaba.cloud.context.utils.StringUtils;

/**
 * EDAS通用配置简单实现
 *
 * @author xiaolongzuo
 */
public class SimpleEdasConfiguration implements EdasConfiguration {

    private String applicationName;

    private String namespace;

    private boolean isEnabled;

    public SimpleEdasConfiguration() {
    }

    public SimpleEdasConfiguration(String applicationName, String namespace,
                                   boolean isEnabled) {
        this.applicationName = applicationName;
        this.namespace = namespace;
        this.isEnabled = isEnabled;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEnabled(boolean enabled) {
        isEnabled = enabled;
    }

    @Override
    public String getApplicationName() {
        return applicationName;
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    @Override
    public boolean isEnabled() {
        return isEnabled;
    }

    @Override
    public String getRegionId() {
        if (namespace == null) {
            return null;
        }
        return namespace.contains(":") ? namespace.split(":")[0] : namespace;
    }

    @Override
    public boolean isApplicationNameValid() {
        return StringUtils.isNotEmpty(applicationName);
    }

}
