/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context.cs;

import com.alibaba.cloud.context.AliCloudServerMode;

/**
 * configserver已处理配置简单实现
 *
 * @author xiaolongzuo
 */
public class SimpleCsHandledConfiguration implements CsHandledConfiguration {

    private AliCloudServerMode serverMode;

    private String tenantId;

    private String dauthAccessKey;

    private String dauthSecretKey;

    private String projectName;

    private String serverList;

    private String serverPort;

    public SimpleCsHandledConfiguration() {
    }

    public SimpleCsHandledConfiguration(AliCloudServerMode serverMode, String tenantId,
                                        String dauthAccessKey, String dauthSecretKey, String projectName,
                                        String serverList, String serverPort) {
        this.serverMode = serverMode;
        this.tenantId = tenantId;
        this.dauthAccessKey = dauthAccessKey;
        this.dauthSecretKey = dauthSecretKey;
        this.projectName = projectName;
        this.serverList = serverList;
        this.serverPort = serverPort;
    }

    public void setServerMode(AliCloudServerMode serverMode) {
        this.serverMode = serverMode;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setDauthAccessKey(String dauthAccessKey) {
        this.dauthAccessKey = dauthAccessKey;
    }

    public void setDauthSecretKey(String dauthSecretKey) {
        this.dauthSecretKey = dauthSecretKey;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setServerList(String serverList) {
        this.serverList = serverList;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    @Override
    public AliCloudServerMode getServerMode() {
        return serverMode;
    }

    @Override
    public String getTenantId() {
        return tenantId;
    }

    @Override
    public String getDauthAccessKey() {
        return dauthAccessKey;
    }

    @Override
    public String getDauthSecretKey() {
        return dauthSecretKey;
    }

    @Override
    public String getProjectName() {
        return projectName;
    }

    @Override
    public String getServerList() {
        return serverList;
    }

    @Override
    public String getServerPort() {
        return serverPort;
    }
}
