/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context;

/**
 * @author xiaolongzuo
 */
public enum AlicloudSdkRegion {

    CN_BEIJING,
    CN_QINGDAO,
    CN_SHENZHEN,
    CN_HANGZHOU,
    CN_SHANGHAI,
    AP_SOUTHEAST_1;

    public String getRegionId() {
        return name().toLowerCase().replace("_", "-");
    }

    public String getEndpoint(AlicloudSdkProduct alicloudSdkProduct) {
        if (alicloudSdkProduct == AlicloudSdkProduct.EDAS) {
            return "edas." + getRegionId() + ".aliyuncs.com";
        }
        return null;
    }

}
