/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.JobExecutorQueryVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.service.JobExecutorService;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobExecutorMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobExecutor;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobExecutorServiceImpl
implements JobExecutorService {
    private final JobExecutorMapper jobExecutorMapper;

    @Override
    public PageResult<List<JobExecutor>> getJobExecutorPage(JobExecutorQueryVO jobQueryVO) {
        PageDTO pageDTO = new PageDTO((long)jobQueryVO.getPage(), (long)jobQueryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<String> groupNames = UserSessionUtils.getGroupNames(jobQueryVO.getGroupName());
        PageDTO selectPage = (PageDTO)this.jobExecutorMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobExecutor::getNamespaceId, (Object)userSessionVO.getNamespaceId())).eq(StrUtil.isNotBlank((CharSequence)jobQueryVO.getExecutorType()), JobExecutor::getExecutorType, (Object)jobQueryVO.getExecutorType())).in(CollUtil.isNotEmpty(groupNames), JobExecutor::getGroupName, groupNames)).like(StrUtil.isNotBlank((CharSequence)jobQueryVO.getExecutorInfo()), JobExecutor::getExecutorInfo, (Object)StrUtil.trim((CharSequence)jobQueryVO.getExecutorInfo()))).orderByAsc(JobExecutor::getId));
        return new PageResult<List<JobExecutor>>(pageDTO, selectPage.getRecords());
    }

    @Override
    public JobExecutor getJobExecutorDetail(Long id) {
        return (JobExecutor)this.jobExecutorMapper.selectById((Serializable)id);
    }

    @Override
    public Set<String> getJobExecutorList(JobExecutorQueryVO jobQueryVO) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<String> groupNames = UserSessionUtils.getGroupNames(jobQueryVO.getGroupName());
        return StreamUtils.toSet((Collection)this.jobExecutorMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{JobExecutor::getExecutorInfo}).eq(JobExecutor::getNamespaceId, (Object)userSessionVO.getNamespaceId())).eq(StrUtil.isNotBlank((CharSequence)jobQueryVO.getExecutorType()), JobExecutor::getExecutorType, (Object)jobQueryVO.getExecutorType())).in(CollUtil.isNotEmpty(groupNames), JobExecutor::getGroupName, groupNames)).like(StrUtil.isNotBlank((CharSequence)jobQueryVO.getExecutorInfo()), JobExecutor::getExecutorInfo, (Object)StrUtil.trim((CharSequence)jobQueryVO.getExecutorInfo()))).orderByDesc(JobExecutor::getId)), JobExecutor::getExecutorInfo);
    }

    @Override
    @Transactional
    public Boolean deleteJobExecutorByIds(Set<Long> ids) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        Assert.isTrue((ids.size() == this.jobExecutorMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobExecutor::getNamespaceId, (Object)namespaceId)).in(JobExecutor::getId, ids)) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete job executor"));
        return Boolean.TRUE;
    }

    @Generated
    public JobExecutorServiceImpl(JobExecutorMapper jobExecutorMapper) {
        this.jobExecutorMapper = jobExecutorMapper;
    }
}

