/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.request;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.enums.HeadersEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.request.RetryTaskRequest;
import com.aizuda.snailjob.server.common.enums.TaskGeneratorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.retry.task.service.TaskContextConverter;
import com.aizuda.snailjob.server.retry.task.support.generator.retry.TaskContext;
import com.aizuda.snailjob.server.retry.task.support.generator.retry.TaskGenerator;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ReportRetryInfoHttpRequestHandler
extends PostHttpRequestHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportRetryInfoHttpRequestHandler.class);
    private final List<TaskGenerator> taskGenerators;
    private final AccessTemplate accessTemplate;

    public boolean supports(String path) {
        return "/batch/report".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    @Transactional
    public SnailJobRpcResult doHandler(String content, UrlQuery urlQuery, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("Batch Report Retry Data. content:[{}]", new Object[]{content});
        final SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        try {
            TaskGenerator taskGenerator = this.taskGenerators.stream().filter(t -> t.supports(TaskGeneratorSceneEnum.CLIENT_REPORT.getScene())).findFirst().orElseThrow(() -> new SnailJobServerException("No matching task generator found"));
            Assert.notEmpty((Object[])args, () -> new SnailJobServerException("The reported data cannot be empty. ReqId:[{}]", new Object[]{retryRequest.getReqId()}));
            List retryTaskList = JsonUtil.parseList((String)JsonUtil.toJsonString((Object)args[0]), RetryTaskRequest.class);
            SnailJobLog.LOCAL.info("begin handler report data. <|>{}<|>", new Object[]{JsonUtil.toJsonString((Object)retryTaskList)});
            Set set = StreamUtils.toSet((Collection)retryTaskList, RetryTaskRequest::getGroupName);
            Assert.isTrue((set.size() <= 1 ? 1 : 0) != 0, () -> new SnailJobServerException("Batch report data, the same batch can only be the same group. ReqId:[{}]", new Object[]{retryRequest.getReqId()}));
            Map map = StreamUtils.groupByKey((Collection)retryTaskList, RetryTaskRequest::getSceneName);
            Retryer retryer = RetryerBuilder.newBuilder().retryIfException(throwable -> throwable instanceof DuplicateKeyException || throwable instanceof TransactionSystemException || throwable instanceof ConcurrencyFailureException || throwable instanceof IOException).withStopStrategy(StopStrategies.stopAfterAttempt((int)5)).withWaitStrategy(WaitStrategies.fixedWait((long)1L, (TimeUnit)TimeUnit.SECONDS)).withRetryListener(new RetryListener(){

                public <V> void onRetry(Attempt<V> attempt) {
                    if (attempt.hasException()) {
                        SnailJobLog.LOCAL.error("Data reporting exception occurred, execute retry. ReqId:[{}] Count:[{}]", new Object[]{retryRequest.getReqId(), attempt.getAttemptNumber(), attempt.getExceptionCause()});
                    }
                }
            }).build();
            String namespaceId = headers.getAsString((CharSequence)HeadersEnum.NAMESPACE.getKey());
            String groupName = headers.getAsString((CharSequence)HeadersEnum.GROUP_NAME.getKey());
            GroupConfig groupConfig = this.accessTemplate.getGroupConfigAccess().getGroupConfigByGroupName(groupName, namespaceId);
            if (Objects.isNull(groupConfig)) {
                throw new SnailJobServerException("failed to report data, no group configuration found. groupName:[{}]", new Object[]{groupName});
            }
            retryer.call(() -> {
                map.forEach((sceneName, retryTaskDTOS) -> {
                    TaskContext taskContext = new TaskContext();
                    taskContext.setSceneName((String)sceneName);
                    taskContext.setNamespaceId(namespaceId);
                    taskContext.setGroupId(groupConfig.getId());
                    taskContext.setGroupName(groupName);
                    taskContext.setInitScene(groupConfig.getInitScene());
                    taskContext.setTaskInfos(TaskContextConverter.INSTANCE.toTaskContextInfo((List<RetryTaskRequest>)retryTaskDTOS));
                    taskGenerator.taskGenerator(taskContext);
                });
                return null;
            });
            return new SnailJobRpcResult(StatusEnum.YES.getStatus().intValue(), "Batch Retry Data Upload Processed Successfully", (Object)Boolean.TRUE, retryRequest.getReqId());
        }
        catch (Exception e) {
            Throwable throwable2 = e;
            if (e.getClass().isAssignableFrom(RetryException.class)) {
                RetryException re = (RetryException)e;
                throwable2 = re.getLastFailedAttempt().getExceptionCause();
            }
            SnailJobLog.LOCAL.error("Batch Report Retry Data Error. <|>{}<|>", new Object[]{args[0], throwable2});
            return new SnailJobRpcResult(StatusEnum.YES.getStatus().intValue(), throwable2.getMessage(), (Object)Boolean.FALSE, retryRequest.getReqId());
        }
    }

    @Generated
    public ReportRetryInfoHttpRequestHandler(List<TaskGenerator> taskGenerators, AccessTemplate accessTemplate) {
        this.taskGenerators = taskGenerators;
        this.accessTemplate = accessTemplate;
    }
}

