/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.vectorex;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.store.DocumentStore;
import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.core.util.CollectionUtil;
import com.agentsflex.core.util.VectorUtil;
import com.agentsflex.store.vectorex.VectoRexStoreConfig;
import com.google.common.collect.Lists;
import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.core.VectorData;
import io.github.javpower.vectorex.keynote.core.VectorSearchResult;
import io.github.javpower.vectorex.keynote.model.MetricType;
import io.github.javpower.vectorex.keynote.model.VectorFiled;
import io.github.javpower.vectorexcore.VectoRexClient;
import io.github.javpower.vectorexcore.entity.KeyValue;
import io.github.javpower.vectorexcore.entity.ScalarField;
import io.github.javpower.vectorexcore.entity.VectoRexEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VectoRexStore
extends DocumentStore {
    private final VectoRexStoreConfig config;
    private final VectoRexClient client;
    private final String defaultCollectionName;
    private boolean isCreateCollection = false;

    public VectoRexStore(VectoRexStoreConfig config) {
        this.config = config;
        this.defaultCollectionName = config.getDefaultCollectionName();
        this.client = new VectoRexClient(config.getUri());
    }

    public StoreResult storeInternal(List<Document> documents, StoreOptions options) {
        ArrayList<DbData> data = new ArrayList<DbData>();
        for (Document doc : documents) {
            HashMap<String, Object> dict = new HashMap<String, Object>();
            dict.put("id", String.valueOf(doc.getId()));
            dict.put("content", doc.getContent());
            dict.put("vector", VectorUtil.toFloatList((double[])doc.getVector()));
            DbData dbData = new DbData();
            dbData.setId(String.valueOf(doc.getId()));
            dbData.setMetadata(dict);
            VectorData vd = new VectorData(dbData.getId(), VectorUtil.toFloatArray((double[])doc.getVector()));
            vd.setName("vector");
            dbData.setVectorFiled((List)Lists.newArrayList((Object[])new VectorData[]{vd}));
            data.add(dbData);
        }
        String collectionName = options.getCollectionNameOrDefault(this.defaultCollectionName);
        if (this.config.isAutoCreateCollection() && !this.isCreateCollection) {
            List collections = this.client.getCollections();
            if (CollectionUtil.noItems((Collection)collections) || collections.stream().noneMatch(e -> e.getCollectionName().equals(collectionName))) {
                this.createCollection(collectionName);
            } else {
                this.isCreateCollection = true;
            }
        }
        if (CollectionUtil.hasItems(data)) {
            this.client.getStore(collectionName).saveAll(data);
        }
        return StoreResult.successWithIds(documents);
    }

    private void createCollection(String collectionName) {
        VectorFiled vectorFiled = new VectorFiled();
        vectorFiled.setDimensions(this.getEmbeddingModel().dimensions());
        vectorFiled.setName("vector");
        vectorFiled.setMetricType(MetricType.FLOAT_COSINE_DISTANCE);
        VectoRexEntity entity = new VectoRexEntity();
        entity.setCollectionName(collectionName);
        ArrayList<KeyValue> vectorFiles = new ArrayList<KeyValue>();
        vectorFiles.add(new KeyValue((Object)"vector", (Object)vectorFiled));
        ArrayList<KeyValue> scalarFields = new ArrayList<KeyValue>();
        ScalarField id = new ScalarField();
        id.setName("id");
        id.setIsPrimaryKey(Boolean.valueOf(true));
        scalarFields.add(new KeyValue((Object)"id", (Object)id));
        ScalarField content = new ScalarField();
        content.setName("content");
        content.setIsPrimaryKey(Boolean.valueOf(false));
        scalarFields.add(new KeyValue((Object)"content", (Object)content));
        entity.setVectorFileds(vectorFiles);
        entity.setScalarFields(scalarFields);
        this.client.createCollection(entity);
    }

    public StoreResult deleteInternal(Collection<?> ids, StoreOptions options) {
        this.client.getStore(options.getCollectionNameOrDefault(this.defaultCollectionName)).deleteAll((List)ids);
        return StoreResult.success();
    }

    public List<Document> searchInternal(SearchWrapper searchWrapper, StoreOptions options) {
        List data = this.client.getStore(options.getCollectionNameOrDefault(this.defaultCollectionName)).search("vector", VectorUtil.toFloatList((double[])searchWrapper.getVector()), searchWrapper.getMaxResults().intValue(), null);
        ArrayList<Document> documents = new ArrayList<Document>();
        for (VectorSearchResult result : data) {
            DbData dd = result.getData();
            Map metadata = dd.getMetadata();
            Document doc = new Document();
            doc.setId((Object)result.getId());
            doc.setContent((String)metadata.get("content"));
            Object vectorObj = metadata.get("vector");
            if (vectorObj instanceof List) {
                doc.setVector(VectorUtil.convertToVector((List)((List)vectorObj)));
            }
            documents.add(doc);
        }
        return documents;
    }

    public StoreResult updateInternal(List<Document> documents, StoreOptions options) {
        if (documents == null || documents.isEmpty()) {
            return StoreResult.success();
        }
        for (Document doc : documents) {
            HashMap<String, Object> dict = new HashMap<String, Object>();
            dict.put("id", String.valueOf(doc.getId()));
            dict.put("content", doc.getContent());
            dict.put("vector", VectorUtil.toFloatList((double[])doc.getVector()));
            DbData dbData = new DbData();
            dbData.setId(String.valueOf(doc.getId()));
            dbData.setMetadata(dict);
            VectorData vd = new VectorData(dbData.getId(), VectorUtil.toFloatArray((double[])doc.getVector()));
            vd.setName("vector");
            dbData.setVectorFiled((List)Lists.newArrayList((Object[])new VectorData[]{vd}));
            this.client.getStore(options.getCollectionNameOrDefault(this.defaultCollectionName)).update(dbData);
        }
        return StoreResult.successWithIds(documents);
    }

    public VectoRexClient getClient() {
        return this.client;
    }
}

