/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.qwen;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.CollectionUtil;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.MessageUtil;
import com.agentsflex.llm.qwen.QwenLlmConfig;
import java.util.List;

public class QwenLlmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat();

    public static AiMessageParser getAiMessageParser(boolean isStream) {
        return DefaultAiMessageParser.getChatGPTMessageParser((boolean)isStream);
    }

    public static String promptToPayload(Prompt prompt, QwenLlmConfig config, ChatOptions options, boolean withStream) {
        List messages = prompt.toMessages();
        Message message = (Message)CollectionUtil.lastItem((List)messages);
        return Maps.of((String)"model", (Object)config.getModel()).set("messages", promptFormat.toMessagesJsonObject(messages)).setIf(withStream, "stream", (Object)true).setIfNotEmpty("tools", promptFormat.toFunctionsJsonObject(message)).setIfContainsKey("tools", "tool_choice", (Object)MessageUtil.getToolChoice((Message)message)).setIfNotNull("top_p", (Object)options.getTopP()).setIfNotEmpty("stop", (Object)options.getStop()).setIf(map -> !map.containsKey((Object)"tools") && options.getTemperature().floatValue() > 0.0f, "temperature", (Object)options.getTemperature()).setIf(map -> !map.containsKey((Object)"tools") && options.getMaxTokens() != null, "max_tokens", (Object)options.getMaxTokens()).toJSON();
    }

    public static String promptToEnabledPayload(Document text, EmbeddingOptions options, QwenLlmConfig config) {
        return Maps.of((String)"model", (Object)options.getModelOrDefault(config.getDefaultEmbeddingModel())).set("encoding_format", (Object)"float").set("input", (Object)text.getContent()).toJSON();
    }
}

