/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.qianfan;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.qianfan.QianFanLlmConfig;
import com.agentsflex.llm.qianfan.QianFanLlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class QianFanLlm
extends BaseLlm<QianFanLlmConfig> {
    private final HttpClient httpClient = new HttpClient();
    private final AiMessageParser aiMessageParser = QianFanLlmUtil.getAiMessageParser(false);
    private final AiMessageParser streamMessageParser = QianFanLlmUtil.getAiMessageParser(true);
    private final Map<String, String> headers = new HashMap<String, String>();

    public QianFanLlm(QianFanLlmConfig config) {
        super((LlmConfig)config);
        this.headers.put("Content-Type", "application/json");
        this.headers.put("Authorization", "Bearer " + ((QianFanLlmConfig)this.getConfig()).getApiKey());
        Consumer headersConfig = config.getHeadersConfig();
        if (headersConfig != null) {
            headersConfig.accept(this.headers);
        }
    }

    public static QianFanLlm of(String apiKey) {
        QianFanLlmConfig config = new QianFanLlmConfig();
        config.setApiKey(apiKey);
        return new QianFanLlm(config);
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        String payload = QianFanLlmUtil.promptToPayload(prompt, (QianFanLlmConfig)this.config, options, false);
        String endpoint = ((QianFanLlmConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/chat/completions", this.headers, payload);
        if (((QianFanLlmConfig)this.config).isDebug()) {
            System.out.println(">>>>the input:" + payload);
            System.out.println(">>>>receive payload:" + response);
        }
        if (StringUtil.noText((String)response)) {
            return AiMessageResponse.error((Prompt)prompt, (String)response, (String)"no content for response.");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONObject error = jsonObject.getJSONObject("error");
        AiMessageResponse messageResponse = new AiMessageResponse(prompt, response, (AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error.getString("message"));
            messageResponse.setErrorType(error.getString("type"));
            messageResponse.setErrorCode(error.getString("code"));
        }
        return messageResponse;
    }

    public void chatStream(Prompt prompt, StreamResponseListener listener, ChatOptions options) {
        SseClient llmClient = new SseClient();
        String payload = QianFanLlmUtil.promptToPayload(prompt, (QianFanLlmConfig)this.config, options, true);
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, listener, prompt, this.streamMessageParser);
        llmClient.start(((QianFanLlmConfig)this.config).getEndpoint() + "/chat/completions", this.headers, payload, (LlmClientListener)clientListener, this.config);
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        String payload = QianFanLlmUtil.promptToEmbeddingsPayload(document, options, (QianFanLlmConfig)this.config);
        String response = this.httpClient.post(((QianFanLlmConfig)this.config).getEndpoint() + "/embeddings", this.headers, payload);
        if (((QianFanLlmConfig)this.config).isDebug()) {
            System.out.println(">>>>the input:" + payload);
            System.out.println(">>>>receive payload:" + response);
        }
        if (StringUtil.noText((String)response)) {
            return null;
        }
        VectorData vectorData = new VectorData();
        double[] embedding = (double[])JSONPath.read((String)response, (String)"$.data[0].embedding", double[].class);
        vectorData.setVector(embedding);
        return vectorData;
    }
}

