/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.openai;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.openai.OpenAILlmConfig;
import com.agentsflex.llm.openai.OpenAILlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.HashMap;
import java.util.function.Consumer;

public class OpenAILlm
extends BaseLlm<OpenAILlmConfig> {
    private final HttpClient httpClient = new HttpClient();
    public AiMessageParser aiMessageParser = OpenAILlmUtil.getAiMessageParser(false);
    public AiMessageParser streamMessageParser = OpenAILlmUtil.getAiMessageParser(true);

    public static OpenAILlm of(String apiKey) {
        OpenAILlmConfig config = new OpenAILlmConfig();
        config.setApiKey(apiKey);
        return new OpenAILlm(config);
    }

    public static OpenAILlm of(String apiKey, String endpoint) {
        OpenAILlmConfig config = new OpenAILlmConfig();
        config.setApiKey(apiKey);
        config.setEndpoint(endpoint);
        return new OpenAILlm(config);
    }

    public OpenAILlm(OpenAILlmConfig config) {
        super((LlmConfig)config);
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((OpenAILlmConfig)this.getConfig()).getApiKey());
        Consumer headersConfig = ((OpenAILlmConfig)this.config).getHeadersConfig();
        if (headersConfig != null) {
            headersConfig.accept(headers);
        }
        String payload = OpenAILlmUtil.promptToPayload(prompt, (OpenAILlmConfig)this.config, options, false);
        String endpoint = ((OpenAILlmConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/v1/chat/completions", headers, payload);
        if (((OpenAILlmConfig)this.config).isDebug()) {
            System.out.println(">>>>receive payload:" + response);
        }
        if (StringUtil.noText((String)response)) {
            return AiMessageResponse.error((Prompt)prompt, (String)response, (String)"no content for response.");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONObject error = jsonObject.getJSONObject("error");
        AiMessageResponse messageResponse = new AiMessageResponse(prompt, response, (AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error.getString("message"));
            messageResponse.setErrorType(error.getString("type"));
            messageResponse.setErrorCode(error.getString("code"));
        }
        return messageResponse;
    }

    public void chatStream(Prompt prompt, StreamResponseListener listener, ChatOptions options) {
        SseClient llmClient = new SseClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((OpenAILlmConfig)this.getConfig()).getApiKey());
        String payload = OpenAILlmUtil.promptToPayload(prompt, (OpenAILlmConfig)this.config, options, true);
        String endpoint = ((OpenAILlmConfig)this.config).getEndpoint();
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, listener, prompt, this.streamMessageParser);
        llmClient.start(endpoint + "/v1/chat/completions", headers, payload, (LlmClientListener)clientListener, this.config);
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((OpenAILlmConfig)this.getConfig()).getApiKey());
        String payload = OpenAILlmUtil.promptToEmbeddingsPayload(document, options, (OpenAILlmConfig)this.config);
        String endpoint = ((OpenAILlmConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/v1/embeddings", headers, payload);
        if (((OpenAILlmConfig)this.config).isDebug()) {
            System.out.println(">>>>receive payload:" + response);
        }
        if (StringUtil.noText((String)response)) {
            return null;
        }
        VectorData vectorData = new VectorData();
        double[] embedding = (double[])JSONPath.read((String)response, (String)"$.data[0].embedding", double[].class);
        vectorData.setVector(embedding);
        return vectorData;
    }
}

