/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.ollama;

import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.message.FunctionCall;
import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.message.MessageStatus;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.ImagePrompt;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.MessageUtil;
import com.agentsflex.llm.ollama.OllamaLlmConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OllamaLlmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat(){

        protected void buildMessageContent(Message message, Map<String, Object> map) {
            if (message instanceof ImagePrompt.TextAndImageMessage) {
                ImagePrompt prompt = ((ImagePrompt.TextAndImageMessage)message).getPrompt();
                map.put("content", prompt.getContent());
                map.put("images", new String[]{prompt.toImageBase64()});
            } else {
                super.buildMessageContent(message, map);
            }
        }

        protected Object buildToolCallsArguments(Map<String, Object> arguments) {
            return arguments;
        }
    };

    public static AiMessageParser getAiMessageParser() {
        DefaultAiMessageParser aiMessageParser = new DefaultAiMessageParser();
        aiMessageParser.setContentPath("$.message.content");
        aiMessageParser.setTotalTokensPath("$.eval_count");
        aiMessageParser.setCompletionTokensPath("$.prompt_eval_count");
        aiMessageParser.setStatusParser(content -> {
            Boolean done = (Boolean)JSONPath.eval((Object)content, (String)"$.done");
            if (done != null && done.booleanValue()) {
                return MessageStatus.END;
            }
            return MessageStatus.MIDDLE;
        });
        aiMessageParser.setCallsParser(content -> {
            JSONArray toolCalls = (JSONArray)JSONPath.eval((Object)content, (String)"$.message.tool_calls");
            if (toolCalls == null || toolCalls.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<FunctionCall> functionCalls = new ArrayList<FunctionCall>();
            for (int i = 0; i < toolCalls.size(); ++i) {
                JSONObject jsonObject = toolCalls.getJSONObject(i);
                JSONObject functionObject = jsonObject.getJSONObject("function");
                if (functionObject == null) continue;
                FunctionCall functionCall = new FunctionCall();
                functionCall.setId(jsonObject.getString("id"));
                functionCall.setName(functionObject.getString("name"));
                Object arguments = functionObject.get((Object)"arguments");
                if (arguments instanceof Map) {
                    functionCall.setArgs((Map)arguments);
                } else if (arguments instanceof String) {
                    functionCall.setArgs((Map)JSON.parseObject((String)arguments.toString(), Map.class));
                }
                functionCalls.add(functionCall);
            }
            return functionCalls;
        });
        return aiMessageParser;
    }

    public static String promptToPayload(Prompt prompt, OllamaLlmConfig config, ChatOptions options, boolean stream) {
        List messages = prompt.toMessages();
        HumanMessage message = MessageUtil.findLastHumanMessage((List)messages);
        return Maps.of((String)"model", (Object)Optional.ofNullable(options.getModel()).orElse(config.getModel())).set("messages", promptFormat.toMessagesJsonObject(messages)).set("think", (Object)Optional.ofNullable(options.getEnableThinking()).orElse(config.getEnableThinking())).setIf(!stream, "stream", (Object)stream).setIfNotEmpty("tools", promptFormat.toFunctionsJsonObject(message)).setIfNotEmpty("options.seed", (Object)options.getSeed()).setIfNotEmpty("options.top_k", (Object)options.getTopK()).setIfNotEmpty("options.top_p", (Object)options.getTopP()).setIfNotEmpty("options.temperature", (Object)options.getTemperature()).setIfNotEmpty("options.stop", (Object)options.getStop()).toJSON();
    }
}

