/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.ollama;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.DnjsonClient;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.ollama.OllamaLlmConfig;
import com.agentsflex.llm.ollama.OllamaLlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.HashMap;

public class OllamaLlm
extends BaseLlm<OllamaLlmConfig> {
    private HttpClient httpClient = new HttpClient();
    private final DnjsonClient dnjsonClient = new DnjsonClient();
    public AiMessageParser aiMessageParser = OllamaLlmUtil.getAiMessageParser();

    public OllamaLlm(OllamaLlmConfig config) {
        super((LlmConfig)config);
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        if (StringUtil.hasText((String)((OllamaLlmConfig)this.getConfig()).getApiKey())) {
            headers.put("Authorization", "Bearer " + ((OllamaLlmConfig)this.getConfig()).getApiKey());
        }
        String payload = Maps.of((String)"model", (Object)options.getModelOrDefault(((OllamaLlmConfig)this.config).getModel())).set("input", (Object)document.getContent()).toJSON();
        String endpoint = ((OllamaLlmConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/api/embed", headers, payload);
        if (((OllamaLlmConfig)this.config).isDebug()) {
            System.out.println(">>>>receive payload:" + response);
        }
        if (StringUtil.noText((String)response)) {
            return null;
        }
        VectorData vectorData = new VectorData();
        double[] embedding = (double[])JSONPath.read((String)response, (String)"$.embeddings[0]", double[].class);
        vectorData.setVector(embedding);
        vectorData.addMetadata("total_duration", JSONPath.read((String)response, (String)"$.total_duration", Long.class));
        vectorData.addMetadata("load_duration", JSONPath.read((String)response, (String)"$.load_duration", Long.class));
        vectorData.addMetadata("prompt_eval_count", JSONPath.read((String)response, (String)"$.prompt_eval_count", Integer.class));
        vectorData.addMetadata("model", JSONPath.read((String)response, (String)"$.model", String.class));
        return vectorData;
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((OllamaLlmConfig)this.config).getApiKey());
        String endpoint = ((OllamaLlmConfig)this.config).getEndpoint();
        String payload = OllamaLlmUtil.promptToPayload(prompt, (OllamaLlmConfig)this.config, options, false);
        String response = this.httpClient.post(endpoint + "/api/chat", headers, payload);
        if (((OllamaLlmConfig)this.config).isDebug()) {
            System.out.println(">>>>receive payload:" + response);
        }
        if (StringUtil.noText((String)response)) {
            return AiMessageResponse.error((Prompt)prompt, (String)response, (String)"no content for response.");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        String error = jsonObject.getString("error");
        AiMessage aiMessage = (AiMessage)this.aiMessageParser.parse((Object)jsonObject);
        AiMessageResponse messageResponse = new AiMessageResponse(prompt, response, aiMessage);
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error);
        }
        return messageResponse;
    }

    public void chatStream(Prompt prompt, StreamResponseListener listener, ChatOptions options) {
        SseClient llmClient = new SseClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((OllamaLlmConfig)this.config).getApiKey());
        String payload = OllamaLlmUtil.promptToPayload(prompt, (OllamaLlmConfig)this.config, options, true);
        String endpoint = ((OllamaLlmConfig)this.config).getEndpoint();
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, listener, prompt, this.aiMessageParser);
        this.dnjsonClient.start(endpoint + "/api/chat", headers, payload, (LlmClientListener)clientListener, this.config);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

