/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.adapters;

import flex.messaging.log.Log;
import flex.messaging.services.messaging.adapters.JMSConsumer;
import flex.messaging.services.messaging.adapters.MessageReceiver;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;

class SyncMessageReceiver
implements MessageReceiver {
    private ScheduledExecutorService messageReceiverService;
    private boolean isScheduled = false;
    private JMSConsumer jmsConsumer;
    private int syncMaxReceiveThreads;
    private long syncReceiveIntervalMillis;
    private long syncReceiveWaitMillis;

    public SyncMessageReceiver(JMSConsumer jmsConsumer) {
        this.jmsConsumer = jmsConsumer;
        this.syncReceiveIntervalMillis = 100L;
        this.syncReceiveWaitMillis = 0L;
        this.syncMaxReceiveThreads = 1;
    }

    public long getSyncReceiveIntervalMillis() {
        return this.syncReceiveIntervalMillis;
    }

    public void setSyncReceiveIntervalMillis(long syncReceiveIntervalMillis) {
        if (syncReceiveIntervalMillis < 1L) {
            syncReceiveIntervalMillis = 100L;
        }
        this.syncReceiveIntervalMillis = syncReceiveIntervalMillis;
    }

    public long getSyncReceiveWaitMillis() {
        return this.syncReceiveWaitMillis;
    }

    public void setSyncReceiveWaitMillis(long syncReceiveWaitMillis) {
        if (syncReceiveWaitMillis < -1L) {
            syncReceiveWaitMillis = 0L;
        }
        this.syncReceiveWaitMillis = syncReceiveWaitMillis;
    }

    public void startReceive() {
        if (!this.isScheduled) {
            if (Log.isDebug()) {
                Log.getLogger((String)"Service.Message.JMS").debug(Thread.currentThread() + " JMS consumer sync receive thread for JMS destination '" + this.jmsConsumer.destinationJndiName + "' is starting to poll the JMS server for new messages.");
            }
            MessageReceiveThreadFactory mrtf = new MessageReceiveThreadFactory();
            this.messageReceiverService = Executors.newScheduledThreadPool(this.syncMaxReceiveThreads, mrtf);
            this.messageReceiverService.scheduleAtFixedRate(new MessageReceiveThread(), this.syncReceiveIntervalMillis, this.syncReceiveIntervalMillis, TimeUnit.MILLISECONDS);
            this.isScheduled = true;
        }
    }

    public void stopReceive() {
        if (this.messageReceiverService != null) {
            this.messageReceiverService.shutdown();
        }
    }

    private Message receiveMessage() throws JMSException {
        if (this.syncReceiveWaitMillis == -1L) {
            return this.jmsConsumer.receive();
        }
        if (this.syncReceiveWaitMillis == 0L) {
            return this.jmsConsumer.receiveNoWait();
        }
        if (this.syncReceiveWaitMillis > 0L) {
            return this.jmsConsumer.receive(this.syncReceiveWaitMillis);
        }
        return null;
    }

    class MessageReceiveThread
    implements Runnable {
        MessageReceiveThread() {
        }

        public void run() {
            try {
                Message message;
                while ((message = SyncMessageReceiver.this.receiveMessage()) != null) {
                    SyncMessageReceiver.this.jmsConsumer.onMessage(message);
                }
            }
            catch (JMSException jmsEx) {
                SyncMessageReceiver.this.jmsConsumer.onException(jmsEx);
            }
        }
    }

    class MessageReceiveThreadFactory
    implements ThreadFactory {
        private int receiveThreadCount;

        MessageReceiveThreadFactory() {
        }

        public synchronized Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("MessageReceiveThread-" + this.receiveThreadCount++);
            t.setDaemon(true);
            if (Log.isDebug()) {
                Log.getLogger((String)"Service.Message.JMS").debug("Created message receive thread: " + t.getName());
            }
            return t;
        }
    }
}

