/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Transform;
import co.elastic.clients.elasticsearch.watcher.Action;
import co.elastic.clients.elasticsearch.watcher.Condition;
import co.elastic.clients.elasticsearch.watcher.Input;
import co.elastic.clients.elasticsearch.watcher.PutWatchResponse;
import co.elastic.clients.elasticsearch.watcher.Trigger;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutWatchRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, Action> actions;
    @Nullable
    private final Boolean active;
    @Nullable
    private final Condition condition;
    private final String id;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Long ifSeqNo;
    @Nullable
    private final Input input;
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String throttlePeriod;
    @Nullable
    private final Transform transform;
    @Nullable
    private final Trigger trigger;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<PutWatchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutWatchRequest::setupPutWatchRequestDeserializer);
    public static final Endpoint<PutWatchRequest, PutWatchResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutWatchRequest, PutWatchResponse>("es/watcher.put_watch", request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/watch");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.active != null) {
            params.put("active", String.valueOf(request.active));
        }
        if (request.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(request.ifPrimaryTerm));
        }
        if (request.ifSeqNo != null) {
            params.put("if_seq_no", String.valueOf(request.ifSeqNo));
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutWatchResponse._DESERIALIZER);

    private PutWatchRequest(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiable(builder.actions);
        this.active = builder.active;
        this.condition = builder.condition;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.ifPrimaryTerm = builder.ifPrimaryTerm;
        this.ifSeqNo = builder.ifSeqNo;
        this.input = builder.input;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.throttlePeriod = builder.throttlePeriod;
        this.transform = builder.transform;
        this.trigger = builder.trigger;
        this.version = builder.version;
    }

    public static PutWatchRequest of(Function<Builder, ObjectBuilder<PutWatchRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Action> actions() {
        return this.actions;
    }

    @Nullable
    public final Boolean active() {
        return this.active;
    }

    @Nullable
    public final Condition condition() {
        return this.condition;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public final Long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Nullable
    public final Input input() {
        return this.input;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final String throttlePeriod() {
        return this.throttlePeriod;
    }

    @Nullable
    public final Transform transform() {
        return this.transform;
    }

    @Nullable
    public final Trigger trigger() {
        return this.trigger;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartObject();
            for (Map.Entry<String, Action> entry : this.actions.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.condition != null) {
            generator.writeKey("condition");
            this.condition.serialize(generator, mapper);
        }
        if (this.input != null) {
            generator.writeKey("input");
            this.input.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.metadata.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.throttlePeriod != null) {
            generator.writeKey("throttle_period");
            generator.write(this.throttlePeriod);
        }
        if (this.transform != null) {
            generator.writeKey("transform");
            this.transform.serialize(generator, mapper);
        }
        if (this.trigger != null) {
            generator.writeKey("trigger");
            this.trigger.serialize(generator, mapper);
        }
    }

    protected static void setupPutWatchRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.stringMapDeserializer(Action._DESERIALIZER), "actions");
        op.add(Builder::condition, Condition._DESERIALIZER, "condition");
        op.add(Builder::input, Input._DESERIALIZER, "input");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::throttlePeriod, JsonpDeserializer.stringDeserializer(), "throttle_period");
        op.add(Builder::transform, Transform._DESERIALIZER, "transform");
        op.add(Builder::trigger, Trigger._DESERIALIZER, "trigger");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutWatchRequest> {
        @Nullable
        private Map<String, Action> actions;
        @Nullable
        private Boolean active;
        @Nullable
        private Condition condition;
        private String id;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Long ifSeqNo;
        @Nullable
        private Input input;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String throttlePeriod;
        @Nullable
        private Transform transform;
        @Nullable
        private Trigger trigger;
        @Nullable
        private Long version;

        public final Builder actions(Map<String, Action> map) {
            this.actions = Builder._mapPutAll(this.actions, map);
            return this;
        }

        public final Builder actions(String key, Action value) {
            this.actions = Builder._mapPut(this.actions, key, value);
            return this;
        }

        public final Builder actions(String key, Function<Action.Builder, ObjectBuilder<Action>> fn) {
            return this.actions(key, fn.apply(new Action.Builder()).build());
        }

        public final Builder active(@Nullable Boolean value) {
            this.active = value;
            return this;
        }

        public final Builder condition(@Nullable Condition value) {
            this.condition = value;
            return this;
        }

        public final Builder condition(Function<Condition.Builder, ObjectBuilder<Condition>> fn) {
            return this.condition(fn.apply(new Condition.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        public final Builder ifSeqNo(@Nullable Long value) {
            this.ifSeqNo = value;
            return this;
        }

        public final Builder input(@Nullable Input value) {
            this.input = value;
            return this;
        }

        public final Builder input(Function<Input.Builder, ObjectBuilder<Input>> fn) {
            return this.input(fn.apply(new Input.Builder()).build());
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder throttlePeriod(@Nullable String value) {
            this.throttlePeriod = value;
            return this;
        }

        public final Builder transform(@Nullable Transform value) {
            this.transform = value;
            return this;
        }

        public final Builder transform(Function<Transform.Builder, ObjectBuilder<Transform>> fn) {
            return this.transform(fn.apply(new Transform.Builder()).build());
        }

        public final Builder trigger(@Nullable Trigger value) {
            this.trigger = value;
            return this;
        }

        public final Builder trigger(Function<Trigger.Builder, ObjectBuilder<Trigger>> fn) {
            return this.trigger(fn.apply(new Trigger.Builder()).build());
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutWatchRequest build() {
            this._checkSingleUse();
            return new PutWatchRequest(this);
        }
    }
}

