/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.read.builder;

import cn.idev.excel.ExcelReader;
import cn.idev.excel.event.SyncReadListener;
import cn.idev.excel.exception.ExcelGenerateException;
import cn.idev.excel.read.builder.AbstractExcelReaderParameterBuilder;
import cn.idev.excel.read.metadata.ReadSheet;
import cn.idev.excel.read.metadata.ReadWorkbook;
import cn.idev.excel.support.ExcelTypeEnum;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;

public class CsvReaderBuilder
extends AbstractExcelReaderParameterBuilder<CsvReaderBuilder, ReadSheet> {
    private ReadWorkbook readWorkbook;
    private ReadSheet readSheet;
    private CSVFormat.Builder csvFormatBuilder;

    private CsvReaderBuilder() {
    }

    public CsvReaderBuilder(ReadWorkbook readWorkbook) {
        readWorkbook.setExcelType(ExcelTypeEnum.CSV);
        this.readWorkbook = readWorkbook;
        this.readSheet = new ReadSheet();
        this.csvFormatBuilder = CSVFormat.DEFAULT.builder();
    }

    public CsvReaderBuilder delimiter(String delimiter) {
        if (delimiter != null) {
            this.csvFormatBuilder.setDelimiter(delimiter);
        }
        return this;
    }

    public CsvReaderBuilder quote(Character quote) {
        return this.quote(quote, QuoteMode.MINIMAL);
    }

    public CsvReaderBuilder quote(Character quote, QuoteMode quoteMode) {
        if (quote != null) {
            this.csvFormatBuilder.setQuote(quote);
        }
        if (quoteMode != null) {
            this.csvFormatBuilder.setQuoteMode(quoteMode);
        }
        return this;
    }

    public CsvReaderBuilder recordSeparator(String recordSeparator) {
        if (recordSeparator != null) {
            this.csvFormatBuilder.setRecordSeparator(recordSeparator);
        }
        return this;
    }

    public CsvReaderBuilder nullString(String nullString) {
        if (nullString != null) {
            this.csvFormatBuilder.setNullString(nullString);
        }
        return this;
    }

    public CsvReaderBuilder escape(Character escape) {
        if (escape != null) {
            this.csvFormatBuilder.setEscape(escape);
        }
        return this;
    }

    private ExcelReader buildExcelReader() {
        if (this.readWorkbook.getAutoTrim() != null) {
            this.csvFormatBuilder.setTrim(this.readWorkbook.getAutoTrim().booleanValue());
        }
        if (this.readWorkbook.getIgnoreEmptyRow() != null) {
            this.csvFormatBuilder.setIgnoreEmptyLines(this.readWorkbook.getIgnoreEmptyRow().booleanValue());
        }
        this.readWorkbook.setCsvFormat(this.csvFormatBuilder.build());
        return new ExcelReader(this.readWorkbook);
    }

    public void doRead() {
        if (this.readWorkbook == null) {
            throw new ExcelGenerateException("Must use 'FastExcelFactory.read().csv()' to call this method");
        }
        ExcelReader excelReader = this.buildExcelReader();
        excelReader.read(this.readSheet);
        excelReader.finish();
    }

    public <T> List<T> doReadSync() {
        if (this.readWorkbook == null) {
            throw new ExcelGenerateException("Must use 'FastExcelFactory.read().csv()' to call this method");
        }
        ExcelReader excelReader = this.buildExcelReader();
        SyncReadListener syncReadListener = new SyncReadListener();
        this.registerReadListener(syncReadListener);
        excelReader.read(this.readSheet);
        excelReader.finish();
        return syncReadListener.getList();
    }

    @Override
    protected ReadSheet parameter() {
        return this.readSheet;
    }
}

