/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.util;

import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.metadata.property.ExcelContentProperty;
import cn.idev.excel.util.StringUtils;
import cn.idev.excel.util.WorkBookUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;

public class NumberUtils {
    private NumberUtils() {
    }

    public static String format(Number num, ExcelContentProperty contentProperty) {
        if (contentProperty == null || contentProperty.getNumberFormatProperty() == null || StringUtils.isEmpty(contentProperty.getNumberFormatProperty().getFormat())) {
            if (num instanceof BigDecimal) {
                return ((BigDecimal)num).toPlainString();
            }
            return num.toString();
        }
        String format = contentProperty.getNumberFormatProperty().getFormat();
        RoundingMode roundingMode = contentProperty.getNumberFormatProperty().getRoundingMode();
        DecimalFormat decimalFormat = new DecimalFormat(format);
        decimalFormat.setRoundingMode(roundingMode);
        return decimalFormat.format(num);
    }

    public static WriteCellData<?> formatToCellDataString(Number num, ExcelContentProperty contentProperty) {
        return new WriteCellData(NumberUtils.format(num, contentProperty));
    }

    public static WriteCellData<?> formatToCellData(Number num, ExcelContentProperty contentProperty) {
        WriteCellData cellData = new WriteCellData(new BigDecimal(num.toString()));
        if (contentProperty != null && contentProperty.getNumberFormatProperty() != null && StringUtils.isNotBlank(contentProperty.getNumberFormatProperty().getFormat())) {
            WorkBookUtil.fillDataFormat(cellData, contentProperty.getNumberFormatProperty().getFormat(), null);
        }
        return cellData;
    }

    public static Short parseShort(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return new BigDecimal(string).shortValue();
        }
        return NumberUtils.parse(string, contentProperty).shortValue();
    }

    public static Long parseLong(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return new BigDecimal(string).longValue();
        }
        return NumberUtils.parse(string, contentProperty).longValue();
    }

    public static Integer parseInteger(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return new BigDecimal(string).intValue();
        }
        return NumberUtils.parse(string, contentProperty).intValue();
    }

    public static Float parseFloat(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return Float.valueOf(new BigDecimal(string).floatValue());
        }
        return Float.valueOf(NumberUtils.parse(string, contentProperty).floatValue());
    }

    public static BigDecimal parseBigDecimal(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return new BigDecimal(string);
        }
        return new BigDecimal(NumberUtils.parse(string, contentProperty).toString());
    }

    public static Byte parseByte(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return new BigDecimal(string).byteValue();
        }
        return NumberUtils.parse(string, contentProperty).byteValue();
    }

    public static Double parseDouble(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return new BigDecimal(string).doubleValue();
        }
        return NumberUtils.parse(string, contentProperty).doubleValue();
    }

    private static boolean hasFormat(ExcelContentProperty contentProperty) {
        return contentProperty != null && contentProperty.getNumberFormatProperty() != null && !StringUtils.isEmpty(contentProperty.getNumberFormatProperty().getFormat());
    }

    private static Number parse(String string, ExcelContentProperty contentProperty) throws ParseException {
        String format = contentProperty.getNumberFormatProperty().getFormat();
        RoundingMode roundingMode = contentProperty.getNumberFormatProperty().getRoundingMode();
        DecimalFormat decimalFormat = new DecimalFormat(format);
        decimalFormat.setRoundingMode(roundingMode);
        decimalFormat.setParseBigDecimal(true);
        return decimalFormat.parse(string);
    }
}

