/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.Driver;
import com.kingbase8.KBNotification;
import com.kingbase8.KBProperty;
import com.kingbase8.copy.CopyManager;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.BaseStatement;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.ConnectionFactory;
import com.kingbase8.core.Encoding;
import com.kingbase8.core.Oid;
import com.kingbase8.core.Provider;
import com.kingbase8.core.Query;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.ReplicationProtocol;
import com.kingbase8.core.ResultHandlerBase;
import com.kingbase8.core.ServerVersion;
import com.kingbase8.core.SqlCommand;
import com.kingbase8.core.TransactionState;
import com.kingbase8.core.TypeInfo;
import com.kingbase8.core.Utils;
import com.kingbase8.core.Version;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.fastpath.Fastpath;
import com.kingbase8.geometric.KBbox;
import com.kingbase8.geometric.KBcircle;
import com.kingbase8.geometric.KBline;
import com.kingbase8.geometric.KBlseg;
import com.kingbase8.geometric.KBpath;
import com.kingbase8.geometric.KBpoint;
import com.kingbase8.geometric.KBpolygon;
import com.kingbase8.jdbc.AutoSave;
import com.kingbase8.jdbc.CompatibleDB;
import com.kingbase8.jdbc.DSInterval;
import com.kingbase8.jdbc.EsBlob;
import com.kingbase8.jdbc.EsClob;
import com.kingbase8.jdbc.EsNClob;
import com.kingbase8.jdbc.FieldMetadata;
import com.kingbase8.jdbc.KSQLSavepoint;
import com.kingbase8.jdbc.KbArray;
import com.kingbase8.jdbc.KbBlob;
import com.kingbase8.jdbc.KbCallableStatement;
import com.kingbase8.jdbc.KbClob;
import com.kingbase8.jdbc.KbDatabaseMetaData;
import com.kingbase8.jdbc.KbPreparedStatement;
import com.kingbase8.jdbc.KbSQLXML;
import com.kingbase8.jdbc.KbStatement;
import com.kingbase8.jdbc.KbStruct;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.jdbc.PrimitiveArraySupport;
import com.kingbase8.jdbc.TimestampUtils;
import com.kingbase8.jdbc.TypeInfoCache;
import com.kingbase8.jdbc.YMInterval;
import com.kingbase8.largeobject.LargeObjectManager;
import com.kingbase8.replication.KBReplicationConnection;
import com.kingbase8.replication.KBReplicationConnectionImpl;
import com.kingbase8.util.GT;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KBBinaryObject;
import com.kingbase8.util.KBInterval;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KBmoney;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LruCache;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class KbConnection
implements BaseConnection {
    private static final SQLPermission SQL_PERMISSION_ABORT_T = new SQLPermission("callAbort");
    private static final Set<Integer> SUPPORTED_BINARY_OIDS_T = KbConnection.getSupportedBinaryOidsSet();
    private boolean pgClassIsView;
    private static final SQLPermission SQL_PERMISSION_NETWORK_TIMEOUT_T = new SQLPermission("setNetworkTimeout");
    private final Properties clientInfoProps;
    public Object pCMV2;
    private final String creatingUrlT;
    private final EReadOnlyBehavior isReadOnlyBehaviorT;
    private final Query rollbackQueryT;
    private final QueryExecutor queryExecutorT;
    private final Query commitQueryT;
    private boolean disableColumnSanitiserT;
    private boolean hideUnprivilegedObjectsT;
    protected int defaultFetchSizeT;
    private boolean isReadOnly;
    private int savepointIdT;
    private final boolean _bindStringAsVarchar;
    private boolean autoCommitT;
    private volatile Timer _cancelTimer;
    private SQLWarning firstWarningT;
    private PreparedStatement checkConnectionQueryT;
    private final boolean replicationConnectionT;
    private boolean useFetchSizeInAutoCommit;
    private final LruCache<FieldMetadata.Key, FieldMetadata> fieldMetadataCacheT;
    private boolean optimizeBatchedDML;
    private boolean nullConvertEmptyLob;
    private boolean hideRecycledObjects;
    private String rowidType;
    private String structType;
    private boolean databaseSupportRowid;
    private Throwable openStackTraceT;
    protected int prepareThresholdNum;
    protected Map<String, Class<?>> _typemap;
    private final TimestampUtils tsUtils;
    private Fastpath fp;
    private LargeObjectManager lo;
    private final CachedQuery setSessionNotReadOnlyT;
    protected DatabaseMetaData metadata;
    private CopyManager copyManager;
    private final CachedQuery setSessionReadOnlyT;
    private int resultSetHoldability;
    protected boolean forcebinaryT;
    private final TypeInfo typeCacheT;
    private final String _hostip;
    private final int _hostport;
    private final Properties info;
    protected boolean isSlave;
    private DispatchConnection dispatchConn;
    private Connection masterConnection;
    protected boolean isResultSetZeroResend;
    private String ora_input_emptystr_isnull;

    final CachedQuery borrowQuery(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.borrowQuery(_sql);
    }

    private CachedQuery borrowReturningQuery(String _sql, String[] _columnNames) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.borrowReturningQuery(_sql, _columnNames);
    }

    final CachedQuery borrowCallableQuery(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.borrowCallableQuery(_sql);
    }

    void releaseQuery(CachedQuery cachedQuery) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.queryExecutorT.releaseQuery(cachedQuery);
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.queryExecutorT.setFlushCacheOnDeallocate(flushCacheOnDeallocate);
        String info = "  setFlushCacheOnDeallocate = {0}";
        KBLOGGER.log(Level.FINE, "  setFlushCacheOnDeallocate = {0}", flushCacheOnDeallocate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KbConnection(HostSpec[] _hostSpecs, String user, String database, Properties info, String url, int _version, Object cCMV2) throws SQLException {
        block28: {
            ResultSet resultSet;
            this.disableColumnSanitiserT = false;
            this.isReadOnly = false;
            this.savepointIdT = 0;
            this.autoCommitT = true;
            this._cancelTimer = null;
            this.firstWarningT = null;
            this.fp = null;
            this.lo = null;
            this.copyManager = null;
            this.resultSetHoldability = 2;
            this.forcebinaryT = false;
            this.isSlave = false;
            this.dispatchConn = null;
            this.masterConnection = null;
            this.isResultSetZeroResend = false;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "Kingbase8 JDBC Driver V008R006B0001", new Object[0]);
            this.pCMV2 = cCMV2;
            this.creatingUrlT = url;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.info = info;
            this._hostip = _hostSpecs[0].getHost();
            this._hostport = _hostSpecs[0].getPort();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.isReadOnlyBehaviorT = KbConnection.getReadOnlyBehavior(KBProperty.READ_ONLY_MODE.get(info));
            this.setDefaultFetchSize(KBProperty.DEFAULT_ROW_FETCH_SIZE.getInt(info));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setPrepareThreshold(KBProperty.PREPARE_THRESHOLD.getInt(info));
            if (this.prepareThresholdNum == -1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setForceBinary(true);
            }
            this.queryExecutorT = ConnectionFactory.openConnection(_hostSpecs, user, database, info, _version, this.pCMV2);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (KBLOGGER.isLoggable(Level.WARNING) && !this.haveMinimumServerVersion(ServerVersion.v8_2)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBLOGGER.log(Level.WARNING, "Unsupported Server Version: {0}", this.queryExecutorT.getServerVersion());
            }
            try {
                resultSet = this.execSQLQuery("select name,setting from pg_settings where name = 'kdb_flashback.db_recyclebin' or name='database_mode' or name='ora_input_emptystr_isnull'");
                while (resultSet.next()) {
                    String name = resultSet.getString(1);
                    String setting = resultSet.getString(2);
                    String string = setting = setting != null ? setting.toLowerCase() : null;
                    if ("kdb_flashback.db_recyclebin".equalsIgnoreCase(name)) {
                        this.hideRecycledObjects = true;
                        continue;
                    }
                    if ("ora_input_emptystr_isnull".equalsIgnoreCase(name)) {
                        this.ora_input_emptystr_isnull = setting;
                        continue;
                    }
                    if (!"database_mode".equalsIgnoreCase(name)) continue;
                    this.setCompatibleLevel(setting);
                }
            }
            catch (SQLException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultSet = this.execSQLQuery("select relkind from pg_class where relname='pg_class'");
                if (resultSet.next()) {
                    String relkind = resultSet.getString(1);
                    if (relkind.equalsIgnoreCase("v")) {
                        this.pgClassIsView = true;
                    }
                    break block28;
                }
                this.pgClassIsView = false;
            }
            catch (SQLException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        try {
            ResultSet rs = this.execSQLQuery("select * from pg_type where typname='rowid';");
            this.databaseSupportRowid = rs.next();
        }
        catch (SQLException rs) {
            // empty catch block
        }
        this.setStoreCase(KBProperty.STORE_CASE.get(info).toLowerCase());
        this.setSessionReadOnlyT = this.createQuery("SET SESSION CHARACTERISTICS AS TRANSACTION READ ONLY", false, true, new String[0]);
        this.setSessionNotReadOnlyT = this.createQuery("SET SESSION CHARACTERISTICS AS TRANSACTION READ WRITE", false, true, new String[0]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBProperty.READ_ONLY.getBoolean(info)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setReadOnly(true);
        }
        this.hideUnprivilegedObjectsT = KBProperty.HIDE_UNPRIVILEGED_OBJECTS.getBoolean(info);
        Set<Integer> binaryOidsSet = KbConnection.getBinaryOids_(info);
        HashSet<Integer> useBinaryReceiveForOidsSet = new HashSet<Integer>(binaryOidsSet);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        HashSet<Integer> useBinarySendForOidsSet = new HashSet<Integer>(binaryOidsSet);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useBinarySendForOidsSet.remove(1082);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.queryExecutorT.setBinaryReceiveOids(useBinaryReceiveForOidsSet);
        this.queryExecutorT.setBinarySendOids(useBinarySendForOidsSet);
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, "    types using binary send = {0}", this.oidsToString(useBinarySendForOidsSet));
            KBLOGGER.log(Level.FINEST, "    types using binary receive = {0}", this.oidsToString(useBinaryReceiveForOidsSet));
            KBLOGGER.log(Level.FINEST, "    integer date/time = {0}", this.queryExecutorT.getIntegerDateTimes());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String stringType = KBProperty.STRING_TYPE.get(info);
        if (stringType != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (stringType.equalsIgnoreCase("unspecified")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._bindStringAsVarchar = false;
            } else {
                if (!stringType.equalsIgnoreCase("varchar")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new KSQLException(GT.tr("Unsupported _value for stringtype _parameter: {0}", stringType), KSQLState.INVALID_PARAMETER_VALUE);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._bindStringAsVarchar = true;
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._bindStringAsVarchar = true;
        }
        this.tsUtils = new TimestampUtils(!this.queryExecutorT.getIntegerDateTimes(), new Provider<TimeZone>(){

            @Override
            public TimeZone get() {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TimeZone timeZone = KbConnection.this.queryExecutorT.getTimeZone();
                return timeZone;
            }
        });
        this.commitQueryT = this.createQuery((String)"COMMIT", (boolean)false, (boolean)true, (String[])new String[0]).query;
        this.rollbackQueryT = this.createQuery((String)"ROLLBACK", (boolean)false, (boolean)true, (String[])new String[0]).query;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int unknownLength = KBProperty.UNKNOWN_LENGTH.getInt(info);
        this.typeCacheT = this.createTypeInfo(this, unknownLength);
        this.initObjectTypes(info);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBProperty.LOG_UNCLOSED_CONNECTIONS.getBoolean(info)) {
            this.openStackTraceT = new Throwable("Connection was created at this point:");
        }
        this.disableColumnSanitiserT = KBProperty.DISABLE_COLUMN_SANITISER.getBoolean(info);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.haveMinimumServerVersion(ServerVersion.v8_3)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.typeCacheT.addCoreType("uuid", 2950, 1111, "java.util.UUID", 2951);
            this.typeCacheT.addCoreType("xml", 142, 2009, "java.sql.SQLXML", 143);
        }
        if (CompatibleDB.oracle(this.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.typeCacheT.addCoreType("blob", 8013, 2004, "java.sql.Blob", -1);
            this.typeCacheT.addCoreType("clob", 8014, 2005, "java.sql.Clob", -1);
            this.typeCacheT.addCoreType("nclob", 8015, 2011, "java.sql.NClob", -1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.typeCacheT.addCoreType("bpcharbyte", 8016, 1, "java.lang.String", 8017);
            this.typeCacheT.addCoreType("varcharbyte", 8018, 12, "java.lang.String", 8019);
            this.typeCacheT.addCoreType("date", 8020, 93, "java.sql.Timestamp", 8021);
            this.typeCacheT.addCoreType("tinyint", 8100, -6, "java.lang.Byte", 8101);
            if (this.databaseSupportRowid) {
                this.typeCacheT.addCoreType("rowid", 6123, -8, "com.kingbase8.jdbc.KbRowId", 6124);
            } else {
                this.typeCacheT.addCoreType("tid", 27, -8, "com.kingbase8.jdbc.KbRowId", 1010);
            }
            this.typeCacheT.addCoreType("yminterval", 7002, 1111, "com.kingbase8.jdbc.YMInterval", 7003);
            this.typeCacheT.addCoreType("dsinterval", 7000, 1111, "com.kingbase8.jdbc.DSInterval", 7001);
        }
        this.clientInfoProps = new Properties();
        if (this.haveMinimumServerVersion(ServerVersion.v9_0)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String appName = KBProperty.APPLICATION_NAME.get(info);
            if (appName == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                appName = "";
            }
            this.clientInfoProps.put("ApplicationName", appName);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.fieldMetadataCacheT = new LruCache(Math.max(0, KBProperty.DATABASE_METADATA_CACHE_FIELDS.getInt(info)), Math.max(0, KBProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.getInt(info) * 1024 * 1024), false);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.replicationConnectionT = KBProperty.REPLICATION.get(info) != null;
        this.useFetchSizeInAutoCommit = KBProperty.USE_FETCH_SIZE_IN_AUTO_COMMIT.getBoolean(info);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setNullConvertEmptyLob(KBProperty.NULL_CONVERT_EMPTY_LOB.getBoolean(info));
        this.setStructType(KBProperty.STRUCT_TYPE.get(info));
        this.setRowIdType(KBProperty.ROWID_TYPE.get(info));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.queryExecutorT.isReWriteBatchedInsertsEnabled()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setOptimizeBatchedDML(KBProperty.OPTIMIZE_BATCHED_DML.getBoolean(info));
        }
    }

    public KbConnection(HostSpec[] _hostSpecs, String user, String database, Properties info, String url) throws SQLException {
        this(_hostSpecs, user, database, info, url, -1, null);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static Set<Integer> getSupportedBinaryOidsSet() {
        return new HashSet<Integer>(Arrays.asList(8100, 17, 20, 700, 21, 23, 701, 1266, 1114, 1184, 1083, 1082, 1007, 8101, 1005, 1016, 1021, 1015, 8013, 603, 1009, 1022, 600, 2950));
    }

    private static Set<Integer> getBinaryOids_(Properties infoProps) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean binaryTransfer = KBProperty.BINARY_TRANSFER.getBoolean(infoProps);
        HashSet<Integer> binaryOids = new HashSet<Integer>(32);
        if (binaryTransfer) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            binaryOids.addAll(SUPPORTED_BINARY_OIDS_T);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        binaryOids.addAll(KbConnection.getOidSet(KBProperty.BINARY_TRANSFER_ENABLE.get(infoProps)));
        binaryOids.removeAll(KbConnection.getOidSet(KBProperty.BINARY_TRANSFER_DISABLE.get(infoProps)));
        binaryOids.retainAll(SUPPORTED_BINARY_OIDS_T);
        return binaryOids;
    }

    private static Set<Integer> getOidSet(String oidList) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        HashSet<Integer> oids = new HashSet<Integer>();
        StringTokenizer token = new StringTokenizer(oidList, ",");
        while (token.hasMoreTokens()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String oid = token.nextToken();
            oids.add(Oid.valueOf(oid));
        }
        return oids;
    }

    private String oidsToString(Set<Integer> oids) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder sbu = new StringBuilder();
        for (Integer oid : oids) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append(Oid.toString(oid));
            sbu.append(',');
        }
        if (sbu.length() > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.setLength(sbu.length() - 1);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append(" <none>");
        }
        return sbu.toString();
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils tmp = this.tsUtils;
        return tmp;
    }

    @Override
    public Statement createStatement() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.prepareStatement(_sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.prepareCall(_sql, 1003, 1007);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return this._typemap;
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT;
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getReplicationProtocol();
    }

    public void addWarning(SQLWarning warn) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.firstWarningT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.firstWarningT.setNextWarning(warn);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.firstWarningT = warn;
        }
    }

    @Override
    public ResultSet execSQLQuery(String sqlStr) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.execSQLQuery(sqlStr, 1003, 1007);
    }

    @Override
    public ResultSet execSQLQuery(String sqlStr, int _resultSetType, int _resultSetConcurrency) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BaseStatement baseStatement = (BaseStatement)this.createStatement(_resultSetType, _resultSetConcurrency);
        boolean hasResultSetT = baseStatement.executeWithFlags(sqlStr, 16);
        while (!hasResultSetT && baseStatement.getUpdateCount() != -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            hasResultSetT = baseStatement.getMoreResults();
        }
        if (!hasResultSetT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "No results were returned by the query.";
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        SQLWarning sqlWarnings = baseStatement.getWarnings();
        if (sqlWarnings != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.addWarning(sqlWarnings);
        }
        return baseStatement.getResultSet();
    }

    @Override
    public void execSQLUpdate(String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BaseStatement stm = (BaseStatement)this.createStatement();
        if (stm.executeWithFlags(s, 22)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "A _result was returned when none was expected.";
            throw new KSQLException(GT.tr("A _result was returned when none was expected.", new Object[0]), KSQLState.TOO_MANY_RESULTS);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLWarning _warnings = stm.getWarnings();
        if (_warnings != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.addWarning(_warnings);
        }
        stm.close();
    }

    void execSQLUpdate(CachedQuery query) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BaseStatement stm = (BaseStatement)this.createStatement();
        if (stm.executeWithFlags(query, 22)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "A _result was returned when none was expected.";
            throw new KSQLException(GT.tr("A _result was returned when none was expected.", new Object[0]), KSQLState.TOO_MANY_RESULTS);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLWarning _warnings = stm.getWarnings();
        if (_warnings != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.addWarning(_warnings);
        }
        stm.close();
    }

    public void setCursorName(String cursor) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
    }

    public String getCursorName() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return null;
    }

    public String getURL() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.creatingUrlT;
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (this.fp == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.fp = new Fastpath(this);
        }
        return this.fp;
    }

    public String getUserName() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getUser();
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (this.lo == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.lo = new LargeObjectManager(this);
        }
        return this.lo;
    }

    @Override
    public Object getObject(String type, String _value, byte[] byteValue) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._typemap != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Class<?> c = this._typemap.get(type);
            if (c != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String info = "Custom type mapst are not supported.";
                throw new KSQLException(GT.tr("Custom type mapst are not supported.", new Object[0]), KSQLState.NOT_IMPLEMENTED);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBobject objt = null;
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, "Constructing object from type={0} _value=<{1}>", type, _value);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Class<? extends KBobject> klass = this.typeCacheT.getKBobject(type);
            if (klass != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                objt = klass.newInstance();
                objt.setType(type);
                if (byteValue != null && objt instanceof KBBinaryObject) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBBinaryObject binObj = (KBBinaryObject)((Object)objt);
                    binObj.setByteValue(byteValue, 0);
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    objt.setValue(_value);
                }
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                objt = new KBobject();
                objt.setType(type);
                objt.setValue(_value);
            }
            return objt;
        }
        catch (SQLException sx) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw sx;
        }
        catch (Exception ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Failed to create object for: {0}.";
            throw new KSQLException(GT.tr("Failed to create object for: {0}.", type), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    protected TypeInfo createTypeInfo(BaseConnection _conn, int unknownLength) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new TypeInfoCache(_conn, unknownLength);
    }

    @Override
    public TypeInfo getTypeInfo() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeCacheT;
    }

    @Override
    public void addDataType(String dataType, String nameStr) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            this.addDataType(dataType, Class.forName(nameStr).asSubclass(KBobject.class));
        }
        catch (Exception exception) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new RuntimeException("Cannot register new type: " + exception);
        }
    }

    @Override
    public void addDataType(String dataType, Class<? extends KBobject> klass) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        this.typeCacheT.addDataType(dataType, klass);
    }

    private void initObjectTypes(Properties infoProps) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.addDataType("box", KBbox.class);
        this.addDataType("circle", KBcircle.class);
        this.addDataType("line", KBline.class);
        this.addDataType("lseg", KBlseg.class);
        this.addDataType("path", KBpath.class);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.addDataType("point", KBpoint.class);
        this.addDataType("polygon", KBpolygon.class);
        this.addDataType("money", KBmoney.class);
        this.addDataType("interval", KBInterval.class);
        this.addDataType("yminterval", YMInterval.class);
        this.addDataType("dsinterval", DSInterval.class);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Enumeration<?> enumeration = infoProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            Class<?> cls;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String propertyNameStr = (String)enumeration.nextElement();
            if (!propertyNameStr.startsWith("datatype.")) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String typeNameT = propertyNameStr.substring(9);
            String clasNameT = infoProps.getProperty(propertyNameStr);
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                cls = Class.forName(clasNameT);
            }
            catch (ClassNotFoundException classNotFoundException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String info = "Unable to load the class {0} responsible for the datatype {1}";
                throw new KSQLException(GT.tr("Unable to load the class {0} responsible for the datatype {1}", clasNameT, typeNameT), KSQLState.SYSTEM_ERROR, (Throwable)classNotFoundException);
            }
            this.addDataType(typeNameT, cls.asSubclass(KBobject.class));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    @Override
    public void close() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String info = "KbConnection close()";
        KBLOGGER.log(Level.FINE, "KbConnection close()", new Object[0]);
        if (this.queryExecutorT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.releaseTimer();
        this.queryExecutorT.close();
        this.openStackTraceT = null;
    }

    @Override
    public String nativeSQL(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        CachedQuery cachedQuery = this.queryExecutorT.createQuery(_sql, false, true, new String[0]);
        return cachedQuery.query.getNativeSql();
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        this.queryExecutorT.getWarnings();
        this.firstWarningT = null;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (this.queryExecutorT.getTransactionState() != TransactionState.IDLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Cannot change transaction read-only prop in the middle of a transaction.", new Object[0]), KSQLState.ACTIVE_SQL_TRANSACTION);
        }
        if (isReadOnly != this.isReadOnly && this.autoCommitT && this.isReadOnlyBehaviorT == EReadOnlyBehavior.always) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.execSQLUpdate(isReadOnly ? this.setSessionReadOnlyT : this.setSessionNotReadOnlyT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isReadOnly = isReadOnly;
        String info = "  setReadOnly = {0}";
        KBLOGGER.log(Level.FINE, "  setReadOnly = {0}", isReadOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return this.isReadOnly;
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        SQLWarning newWarnings = this.queryExecutorT.getWarnings();
        if (this.firstWarningT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.firstWarningT = newWarnings;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.firstWarningT.setNextWarning(newWarnings);
        }
        return this.firstWarningT;
    }

    @Override
    public boolean hintReadOnly() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.isReadOnly && this.isReadOnlyBehaviorT != EReadOnlyBehavior.ignore;
    }

    @Override
    public void setAutoCommit(boolean _autoCommit) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (this.autoCommitT == _autoCommit) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        if (!this.autoCommitT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.commit();
        }
        if (this.isReadOnly && this.isReadOnlyBehaviorT == EReadOnlyBehavior.always) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_autoCommit) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.autoCommitT = true;
                this.execSQLUpdate(this.setSessionReadOnlyT);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.execSQLUpdate(this.setSessionNotReadOnlyT);
            }
        }
        this.autoCommitT = _autoCommit;
        String info = "  setAutoCommit = {0}";
        KBLOGGER.log(Level.FINE, "  setAutoCommit = {0}", _autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return this.autoCommitT;
    }

    private void executeTransactionCommand(Query query) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _flags = 22;
        if (this.prepareThresholdNum == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _flags |= 1;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.getQueryExecutor().execute(query, null, new TransactionCommandHandler(), 0, 0, _flags);
        }
        catch (SQLException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (query.getSubqueries() != null || !this.queryExecutorT.willHealOnRetry(e)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw e;
            }
            query.close();
            this.getQueryExecutor().execute(query, null, new TransactionCommandHandler(), 0, 0, _flags);
        }
    }

    @Override
    public void commit() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (this.autoCommitT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (CompatibleDB.notPg(this.getCompatibleLevel())) {
                return;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Cannot commit when _autoCommit is enabled.";
            throw new KSQLException(GT.tr("Cannot commit when _autoCommit is enabled.", new Object[0]), KSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.queryExecutorT.getTransactionState() != TransactionState.IDLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.executeTransactionCommand(this.commitQueryT);
        }
    }

    protected void checkIsClosed() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isClosed()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "This _connection has been closed.";
            throw new KSQLException(GT.tr("This _connection has been closed.", new Object[0]), KSQLState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    @Override
    public void rollback() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (this.autoCommitT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Cannot rollback when _autoCommit is enabled.";
            throw new KSQLException(GT.tr("Cannot rollback when _autoCommit is enabled.", new Object[0]), KSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.queryExecutorT.getTransactionState() != TransactionState.IDLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.executeTransactionCommand(this.rollbackQueryT);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Rollback requested but no transaction in progress";
            KBLOGGER.log(Level.FINE, "Rollback requested but no transaction in progress", new Object[0]);
        }
    }

    @Override
    public TransactionState getTransactionState() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getTransactionState();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        String lev = null;
        ResultSet resultSet = this.execSQLQuery("SHOW TRANSACTION_ISOLATION");
        if (resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            lev = resultSet.getString(1);
        }
        resultSet.close();
        if (lev == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 2;
        }
        if ((lev = lev.toUpperCase(Locale.US)).equals("READ COMMITTED")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 2;
        }
        if (lev.equals("READ UNCOMMITTED")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 1;
        }
        if (lev.equals("REPEATABLE READ")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 4;
        }
        if (lev.equals("SERIALIZABLE")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 8;
        }
        return 2;
    }

    @Override
    public void setTransactionIsolation(int lev) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (this.queryExecutorT.getTransactionState() != TransactionState.IDLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Cannot change transaction isolation lev in the middle of a transaction.", new Object[0]), KSQLState.ACTIVE_SQL_TRANSACTION);
        }
        String isolationLevelName = this.getIsolationLevelName(lev);
        if (isolationLevelName == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Transaction isolation lev {0} not supported.";
            throw new KSQLException(GT.tr("Transaction isolation lev {0} not supported.", lev), KSQLState.NOT_IMPLEMENTED);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevelName;
        this.execSQLUpdate(isolationLevelSQL);
        String info = "  setTransactionIsolation = {0}";
        KBLOGGER.log(Level.FINE, "  setTransactionIsolation = {0}", isolationLevelName);
    }

    protected String getIsolationLevelName(int lev) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        switch (lev) {
            case 8: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return "SERIALIZABLE";
            }
            case 2: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return "READ COMMITTED";
            }
            case 4: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return "REPEATABLE READ";
            }
            case 1: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return "READ UNCOMMITTED";
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    @Override
    public void setCatalog(String catalogT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return this.queryExecutorT.getDatabase();
    }

    public boolean getHideUnprivilegedObjects() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.hideUnprivilegedObjectsT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.openStackTraceT != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBLOGGER.log(Level.WARNING, GT.tr("Finalizing a Connection that was never closed:", new Object[0]), this.openStackTraceT);
            }
            this.close();
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            super.finalize();
        }
    }

    public String getDBVersionNumber() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getServerVersion();
    }

    public int getServerMajorVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            StringTokenizer versionTokensT = new StringTokenizer(this.queryExecutorT.getServerVersion(), ".");
            return KbConnection.integerPart_(versionTokensT.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringTokenizer _versionTokens = new StringTokenizer(this.queryExecutorT.getServerVersion(), ".");
            _versionTokens.nextToken();
            return KbConnection.integerPart_(_versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
    }

    @Override
    public boolean haveMinimumServerVersion(int version) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getServerVersionNum() >= version;
    }

    @Override
    public Encoding getEncoding() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getEncoding();
    }

    @Override
    public boolean haveMinimumServerVersion(Version version) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.haveMinimumServerVersion(version.getVersionNum());
    }

    @Override
    public byte[] _encodeString(String strT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            return this.getEncoding().encode(strT);
        }
        catch (IOException ioException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Unable to translate data into the desired _encoding.";
            throw new KSQLException(GT.tr("Unable to translate data into the desired _encoding.", new Object[0]), KSQLState.DATA_ERROR, (Throwable)ioException);
        }
    }

    @Override
    public String escapeString(String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Utils.escapeLiteral(null, str, this.queryExecutorT.getStandardConformingStrings()).toString();
    }

    @Override
    public boolean getStandardConformingStrings() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getStandardConformingStrings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.isClosed();
    }

    @Override
    public void cancelQuery() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        this.queryExecutorT.sendQueryCancel();
    }

    @Override
    public KBNotification[] getNotifications() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getNotifications(-1);
    }

    @Override
    public int getPrepareThreshold() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.prepareThresholdNum;
    }

    @Override
    public KBNotification[] getNotifications(int _timeoutMillis) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        this.getQueryExecutor().processNotifies(_timeoutMillis);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBNotification[] notifications = this.queryExecutorT.getNotifications();
        return notifications.length == 0 ? null : notifications;
    }

    @Override
    public void setDefaultFetchSize(int fetchSizeT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (fetchSizeT < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Fetch size must be a _value greater to or equal to 0.";
            throw new KSQLException(GT.tr("Fetch size must be a _value greater to or equal to 0.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.defaultFetchSizeT = fetchSizeT;
        String info = "  setDefaultFetchSize = {0}";
        KBLOGGER.log(Level.FINE, "  setDefaultFetchSize = {0}", fetchSizeT);
    }

    @Override
    public int getDefaultFetchSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.defaultFetchSizeT;
    }

    @Override
    public void setPrepareThreshold(int newThresholdNum) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.prepareThresholdNum = newThresholdNum;
        String info = "  setPrepareThreshold = {0}";
        KBLOGGER.log(Level.FINE, "  setPrepareThreshold = {0}", newThresholdNum);
    }

    public boolean getForceBinary() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.forcebinaryT;
    }

    public void setTypeMapImpl(Map<String, Class<?>> stringClassMap) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._typemap = stringClassMap;
    }

    public void setForceBinary(boolean newVal) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.forcebinaryT = newVal;
        String info = "  setForceBinary = {0}";
        KBLOGGER.log(Level.FINE, "  setForceBinary = {0}", newVal);
    }

    public int getProtocolVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getProtocolVersion();
    }

    @Override
    public boolean getStringVarcharFlag() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._bindStringAsVarchar;
    }

    @Override
    public CopyManager getCopyAPI() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (this.copyManager == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.copyManager = new CopyManager(this);
        }
        return this.copyManager;
    }

    @Override
    public boolean binaryTransferSend(int oid) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.useBinaryForSend(oid);
    }

    @Override
    public int getBackendPID() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getBackendPID();
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.disableColumnSanitiserT;
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.disableColumnSanitiserT = disableColumnSanitiser;
        String info = "  setDisableColumnSanitiser = {0}";
        KBLOGGER.log(Level.FINE, "  setDisableColumnSanitiser = {0}", disableColumnSanitiser);
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getPreferQueryMode();
    }

    @Override
    public AutoSave getAutosave() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getAutoSave();
    }

    @Override
    public void setAutosave(AutoSave autoSave) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.queryExecutorT.setAutoSave(autoSave);
        String info = "  setAutosave = {0}";
        KBLOGGER.log(Level.FINE, "  setAutosave = {0}", autoSave.value());
    }

    protected void abort() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.queryExecutorT.abort();
    }

    private synchronized Timer getTimer() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._cancelTimer == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._cancelTimer = Driver.getSharedTimer().getTimer();
        }
        return this._cancelTimer;
    }

    private synchronized void releaseTimer() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._cancelTimer != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._cancelTimer = null;
            Driver.getSharedTimer().releaseTimer();
        }
    }

    @Override
    public void addTimerTask(TimerTask _timerTask, long milliSeconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Timer _timer = this.getTimer();
        _timer.schedule(_timerTask, milliSeconds);
    }

    @Override
    public void purgeTimerTas_keyStore() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Timer _timer = this._cancelTimer;
        if (_timer != null) {
            _timer.purge();
        }
    }

    @Override
    public String escapeIdentifier(String ident) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Utils.escapeIdentifier(null, ident).toString();
    }

    @Override
    public LruCache<FieldMetadata.Key, FieldMetadata> getFieldMetadataCache() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.fieldMetadataCacheT;
    }

    @Override
    public String escapeLiteral(String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Utils.escapeLiteral(null, str, this.queryExecutorT.getStandardConformingStrings()).toString();
    }

    @Override
    public KBReplicationConnection getReplicationAPI() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new KBReplicationConnectionImpl(this);
    }

    private void appendArray(StringBuilder stringBuilder, Object elements, char delimiter) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append('{');
        int nElementsT = Array.getLength(elements);
        for (int i = 0; i < nElementsT; ++i) {
            Object obj;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stringBuilder.append(delimiter);
            }
            if ((obj = Array.get(elements, i)) == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stringBuilder.append("NULL");
                continue;
            }
            if (obj.getClass().isArray()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                PrimitiveArraySupport<Object> _arraySupport = PrimitiveArraySupport.getArraySupport(obj);
                if (_arraySupport != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _arraySupport.appendArray(stringBuilder, delimiter, obj);
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.appendArray(stringBuilder, obj, delimiter);
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (CompatibleDB.notPg(this.getCompatibleLevel()) && obj instanceof Date) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                obj = new Timestamp(((Date)obj).getTime());
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String str = obj.toString();
            KbArray.escapeArrayElement(stringBuilder, str);
        }
        stringBuilder.append('}');
    }

    private static int integerPart_(String dS) {
        int end;
        int start;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (start = 0; start < dS.length() && !Character.isDigit(dS.charAt(start)); ++start) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        for (end = start; end < dS.length() && Character.isDigit(dS.charAt(end)); ++end) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        if (start == end) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Integer.parseInt(dS.substring(start, end));
    }

    @Override
    public Statement createStatement(int _resultSetType, int _resultSetConcurrency, int _resultSetHoldability) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return new KbStatement(this, _resultSetType, _resultSetConcurrency, _resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int _resultSetType, int _resultSetConcurrency, int _resultSetHoldability) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return new KbPreparedStatement(this, _sql, _resultSetType, _resultSetConcurrency, _resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String _sql, int _resultSetType, int _resultSetConcurrency, int _resultSetHoldability) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return new KbCallableStatement(this, _sql, _resultSetType, _resultSetConcurrency, _resultSetHoldability);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (this.metadata == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.metadata = new KbDatabaseMetaData(this);
        }
        return this.metadata;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setTypeMapImpl(map);
        String info = "  setTypeMap = {0}";
        KBLOGGER.log(Level.FINE, "  setTypeMap = {0}", map);
    }

    private static EReadOnlyBehavior getReadOnlyBehavior(String prop) {
        try {
            return EReadOnlyBehavior.valueOf(prop);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return EReadOnlyBehavior.valueOf(prop.toLowerCase(Locale.US));
            }
            catch (IllegalArgumentException illegalArgumentException1) {
                return EReadOnlyBehavior.transaction;
            }
        }
    }

    protected java.sql.Array makeArray(int oid, String _fieldString) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new KbArray((BaseConnection)this, oid, _fieldString);
    }

    protected Blob makeBlob(long oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new KbBlob(this, oid);
    }

    protected Clob makeClob(long oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new KbClob(this, oid);
    }

    protected SQLXML makeSQLXML() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new KbSQLXML(this);
    }

    @Override
    public Clob createClob() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (CompatibleDB.notPg(this.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            EsClob clob = new EsClob(new char[0], this.getEncoding().name());
            return clob;
        }
        throw Driver.notImplemented(this.getClass(), "createClob()");
    }

    @Override
    public Blob createBlob() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (CompatibleDB.notPg(this.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            EsBlob blob = new EsBlob(new byte[0]);
            return blob;
        }
        throw Driver.notImplemented(this.getClass(), "createBlob()");
    }

    @Override
    public NClob createNClob() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (CompatibleDB.notPg(this.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            EsNClob clob = new EsNClob(new char[0], this.getEncoding().name());
            return clob;
        }
        throw Driver.notImplemented(this.getClass(), "createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return this.makeSQLXML();
    }

    @Override
    public CachedQuery createQuery(String _sql, boolean escapeProcessing, boolean isParameterized, String ... _columnNames) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.createQuery(_sql, escapeProcessing, isParameterized, _columnNames);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (CompatibleDB.notPg(this.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (typeName == null || typeName.isEmpty()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String info = "Invalid argument typeName.";
                throw new KSQLException(GT.tr("Invalid argument typeName.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KbStruct struct = new KbStruct(this, typeName, attributes);
            return struct;
        }
        throw Driver.notImplemented(this.getClass(), "createStruct(String, Object[])");
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object elements) throws SQLException {
        String arrayString;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        TypeInfo typeInfo = this.getTypeInfo();
        int oid = typeInfo.getKBArrayType(typeName);
        char delimiter = typeInfo.getArrayDelimiter(oid);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Unable to find server array type for provided name {0}.";
            throw new KSQLException(GT.tr("Unable to find server array type for provided name {0}.", typeName), KSQLState.INVALID_NAME);
        }
        if (elements == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.makeArray(oid, null);
        }
        PrimitiveArraySupport<Object> _arraySupport = PrimitiveArraySupport.getArraySupport(elements);
        if (_arraySupport != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (oid == _arraySupport.getDefaultArrayTypeOid(typeInfo) && _arraySupport.supportBinaryRepresentation() && this.getPreferQueryMode() != PreferQueryMode.SIMPLE) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return new KbArray((BaseConnection)this, oid, _arraySupport.toBinaryRepresentation(this, elements));
            }
            arrayString = _arraySupport.toArrayString(delimiter, elements);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Class<?> clazz = elements.getClass();
            if (!clazz.isArray()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String info = "Invalid elements {0}";
                throw new KSQLException(GT.tr("Invalid elements {0}", elements), KSQLState.INVALID_PARAMETER_TYPE);
            }
            StringBuilder sbu = new StringBuilder();
            this.appendArray(sbu, elements, delimiter);
            arrayString = sbu.toString();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        return this.makeArray(oid, arrayString);
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        int oid = this.getTypeInfo().getKBArrayType(typeName);
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unable to find server array type for provided name {0}.", typeName), KSQLState.INVALID_NAME);
        }
        if (elements == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.makeArray(oid, null);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        char delimiter = this.getTypeInfo().getArrayDelimiter(oid);
        StringBuilder sbu = new StringBuilder();
        this.appendArray(sbu, elements, delimiter);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.makeArray(oid, sbu.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int _timeout) throws SQLException {
        boolean stmt2;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_timeout < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Invalid _timeout ({0}<0).";
            throw new KSQLException(GT.tr("Invalid _timeout ({0}<0).", _timeout), KSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.isClosed()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        int savedNetworkTimeOutT = this.getNetworkTimeout();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNetworkTimeout(null, _timeout * 1000);
            if (this.replicationConnectionT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Statement stmt2 = this.createStatement();
                stmt2.execute("IDENTIFY_SYSTEM");
                stmt2.close();
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.checkConnectionQueryT == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.checkConnectionQueryT = this.prepareStatement("");
                }
                this.checkConnectionQueryT.setQueryTimeout(_timeout);
                this.checkConnectionQueryT.executeUpdate();
            }
            stmt2 = true;
        }
        catch (Throwable throwable) {
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setNetworkTimeout(null, savedNetworkTimeOutT);
                throw throwable;
            }
            catch (SQLException sqlException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (KSQLState.IN_FAILED_SQL_TRANSACTION.getState().equals(sqlException.getSQLState())) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return true;
                }
                String info = "Validating _connection.";
                KBLOGGER.log(Level.FINE, GT.tr("Validating _connection.", new Object[0]), sqlException);
                return false;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setNetworkTimeout(null, savedNetworkTimeOutT);
        return stmt2;
    }

    @Override
    public void setClientInfo(String name, String _value) throws SQLClientInfoException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            this.checkIsClosed();
        }
        catch (SQLException cause) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException(GT.tr("This _connection has been closed.", new Object[0]), failures, (Throwable)cause);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.haveMinimumServerVersion(ServerVersion.v9_0) && "ApplicationName".equals(name)) {
            String oldValue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_value == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _value = "";
            }
            if (_value.equals(oldValue = this.queryExecutorT.getApplicationName())) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return;
            }
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                StringBuilder _sql = new StringBuilder("SET application_name = '");
                Utils.escapeLiteral(_sql, _value, this.getStandardConformingStrings());
                _sql.append("'");
                this.execSQLUpdate(_sql.toString());
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            catch (SQLException _sqle) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
                failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
                throw new SQLClientInfoException(GT.tr("Failed to set ClientInfo prop: {0}", "ApplicationName"), _sqle.getSQLState(), failures, (Throwable)_sqle);
            }
            if (KBLOGGER.isLoggable(Level.FINE)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String info = "  setClientInfo = {0} {1}";
                KBLOGGER.log(Level.FINE, "  setClientInfo = {0} {1}", name, _value);
            }
            this.clientInfoProps.put(name, _value);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.addWarning(new SQLWarning(GT.tr("ClientInfo prop not supported.", new Object[0]), KSQLState.NOT_IMPLEMENTED.getState()));
    }

    @Override
    public void setClientInfo(Properties propes) throws SQLClientInfoException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            this.checkIsClosed();
        }
        catch (SQLException cause) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            for (Map.Entry<Object, Object> e : propes.entrySet()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                failures.put((String)e.getKey(), ClientInfoStatus.REASON_UNKNOWN);
            }
            throw new SQLClientInfoException(GT.tr("This _connection has been closed.", new Object[0]), failures, (Throwable)cause);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
        for (String name : new String[]{"ApplicationName"}) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                this.setClientInfo(name, propes.getProperty(name, null));
            }
            catch (SQLClientInfoException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                failures.putAll(e.getFailedProperties());
            }
        }
        if (!failures.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLClientInfoException(GT.tr("One or more ClientInfo failed.", new Object[0]), KSQLState.NOT_IMPLEMENTED.getState(), failures);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        this.clientInfoProps.put("ApplicationName", this.queryExecutorT.getApplicationName());
        return this.clientInfoProps.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        this.clientInfoProps.put("ApplicationName", this.queryExecutorT.getApplicationName());
        return this.clientInfoProps;
    }

    public <T> T createQueryObject(Class<T> ifc) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        throw Driver.notImplemented(this.getClass(), "createQueryObject(Class<T>)");
    }

    @Override
    public boolean isWrapperFor(Class<?> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return clz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (clz.isAssignableFrom(this.getClass())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return clz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        Statement stm = this.createStatement();
        try {
            ResultSet resultSet;
            block8: {
                String string;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultSet = stm.executeQuery("select current_schema()");
                try {
                    if (resultSet.next()) break block8;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    string = null;
                }
                catch (Throwable throwable) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    resultSet.close();
                    throw throwable;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultSet.close();
                return string;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String string = resultSet.getString(1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            resultSet.close();
            return string;
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String schema) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        Statement stm = this.createStatement();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (schema == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stm.executeUpdate("SET SESSION search_path TO DEFAULT");
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                StringBuilder sbu = new StringBuilder();
                sbu.append("SET SESSION search_path TO '");
                Utils.escapeLiteral(sbu, schema, this.getStandardConformingStrings());
                sbu.append("'");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stm.executeUpdate(sbu.toString());
                String info = "  setSchema = {0}";
                KBLOGGER.log(Level.FINE, "  setSchema = {0}", schema);
            }
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stm.close();
        }
    }

    @Override
    public void abort(Executor exec) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (exec == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("exec is null");
        }
        if (this.isClosed()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        SQL_PERMISSION_ABORT_T.checkGuard(this);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        AbortCommand command = new AbortCommand();
        exec.execute(command);
    }

    @Override
    public void setNetworkTimeout(Executor exec, int millisecs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (millisecs < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Network _timeout must be a _value greater than or equal to 0.";
            throw new KSQLException(GT.tr("Network _timeout must be a _value greater than or equal to 0.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            securityManager.checkPermission(SQL_PERMISSION_NETWORK_TIMEOUT_T);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.queryExecutorT.setNetworkTimeout(millisecs);
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Unable to set network _timeout.";
            throw new KSQLException(GT.tr("Unable to set network _timeout.", new Object[0]), KSQLState.COMMUNICATION_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.queryExecutorT.getNetworkTimeout();
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Unable to get network _timeout.";
            throw new KSQLException(GT.tr("Unable to get network _timeout.", new Object[0]), KSQLState.COMMUNICATION_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        switch (holdability) {
            case 2: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.resultSetHoldability = holdability;
                break;
            }
            case 1: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.resultSetHoldability = holdability;
                break;
            }
            default: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String info = "Unknown ResultSet holdability setting: {0}.";
                throw new KSQLException(GT.tr("Unknown ResultSet holdability setting: {0}.", holdability), KSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        String info = "  setHoldability = {0}";
        KBLOGGER.log(Level.FINE, "  setHoldability = {0}", holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        return this.resultSetHoldability;
    }

    @Override
    public Savepoint setSavepoint(String savePointName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (this.getAutoCommit()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Cannot establish a savepoint in auto-commit mode.";
            throw new KSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), KSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        KSQLSavepoint savepointT = new KSQLSavepoint(savePointName);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement statement = this.createStatement();
        statement.executeUpdate("SAVEPOINT " + savepointT.getKBName());
        statement.close();
        return savepointT;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        if (this.getAutoCommit()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Cannot establish a savepoint in auto-commit mode.";
            throw new KSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), KSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        KSQLSavepoint savepointT = new KSQLSavepoint(this.savepointIdT++);
        String kbName = savepointT.getKBName();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement statement = this.createStatement();
        statement.executeUpdate("SAVEPOINT " + kbName);
        statement.close();
        return savepointT;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        KSQLSavepoint pgSavepoint = (KSQLSavepoint)savepoint;
        this.execSQLUpdate("ROLLBACK TO SAVEPOINT " + pgSavepoint.getKBName());
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        KSQLSavepoint pgSavepoint = (KSQLSavepoint)savepoint;
        this.execSQLUpdate("RELEASE SAVEPOINT " + pgSavepoint.getKBName());
        pgSavepoint.invalidate();
    }

    @Override
    public Statement createStatement(int _resultSetType, int _resultSetConcurrency) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        Statement tmpStatement = this.createStatement(_resultSetType, _resultSetConcurrency, this.getHoldability());
        return tmpStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int _resultSetType, int _resultSetConcurrency) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        PreparedStatement tmpStatement = this.prepareStatement(_sql, _resultSetType, _resultSetConcurrency, this.getHoldability());
        return tmpStatement;
    }

    @Override
    public CallableStatement prepareCall(String _sql, int _resultSetType, int _resultSetConcurrency) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        CallableStatement tmpCStatement = this.prepareCall(_sql, _resultSetType, _resultSetConcurrency, this.getHoldability());
        return tmpCStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int autoGeneratedKeys) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (autoGeneratedKeys != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.prepareStatement(_sql);
        }
        return this.prepareStatement(_sql, (String[])null);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int[] _columnIndexes) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_columnIndexes != null && _columnIndexes.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.prepareStatement(_sql);
        }
        this.checkIsClosed();
        String info = "Returning autogenerated keys is not supported.";
        throw new KSQLException(GT.tr("Returning autogenerated keys is not supported.", new Object[0]), KSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, String[] _columnNames) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_columnNames != null && _columnNames.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.prepareStatement(_sql);
        }
        CachedQuery cachedQuery = this.borrowReturningQuery(_sql, _columnNames);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbPreparedStatement pst = new KbPreparedStatement(this, cachedQuery, 1003, 1007, this.getHoldability());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Query query = cachedQuery.query;
        SqlCommand _sqlCommand = query.getSqlCommand();
        if (_sqlCommand != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            pst.wantsGeneratedKeysAlwaysT = _sqlCommand.isReturningKeywordPresent();
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        return pst;
    }

    @Override
    public final String getParameterStatus(String paramName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getParameterStatus(paramName);
    }

    @Override
    public final Map<String, String> getParameterStatuses() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getParameterStatuses();
    }

    public boolean useFetchSizeInAutoCommit() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.useFetchSizeInAutoCommit;
    }

    public boolean isNullConvertEmptyLob() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.nullConvertEmptyLob;
    }

    public void setNullConvertEmptyLob(boolean nullConvertEmptyLob) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.nullConvertEmptyLob = nullConvertEmptyLob;
    }

    public String getStructType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.structType;
    }

    public void setStructType(String structType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.structType = structType;
    }

    public String getRowIdType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.rowidType;
    }

    public void setRowIdType(String rowidType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.rowidType = rowidType;
    }

    public boolean isOptimizeBatchedDML() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.optimizeBatchedDML;
    }

    public void setOptimizeBatchedDML(boolean optimizeBatchedDML) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.optimizeBatchedDML = optimizeBatchedDML;
    }

    @Override
    public String getCompatibleLevel() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getCompatibleLevel();
    }

    public void setCompatibleLevel(String compatibleLevel) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.queryExecutorT.setCompatibleLevel(compatibleLevel);
    }

    public boolean isPgClassIsView() {
        return this.pgClassIsView;
    }

    public String getStoreCase() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.queryExecutorT.getStoreCase();
    }

    public void setStoreCase(String storeCase) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.mysql(this.getCompatibleLevel())) {
            storeCase = "original";
        } else if (!("lower".equals(storeCase) && "upper".equals(storeCase) && "original".equals(storeCase))) {
            storeCase = "lower";
        }
        this.queryExecutorT.setStoreCase(storeCase);
    }

    public String getHostIp() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._hostip;
    }

    public int getHostPort() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._hostport;
    }

    public String getHostIpst() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.KB_HOST.get(this.info);
    }

    public String getHostPorts() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KBProperty.KB_PORT.get(this.info);
    }

    public DispatchConnection getDispatchConn() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.dispatchConn;
    }

    public void setDispatchConn(DispatchConnection dispatchConn) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.dispatchConn = dispatchConn;
    }

    @Override
    public boolean isSlave() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.isSlave;
    }

    @Override
    public void setIsSlave(boolean isSlave) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isSlave = isSlave;
    }

    @Override
    public void setMasterConnection(Connection _conn) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.masterConnection = _conn;
    }

    @Override
    public Connection getMasterConnection() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.masterConnection == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this;
        }
        return this.masterConnection;
    }

    @Override
    public boolean isZeroResend() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.isResultSetZeroResend;
    }

    public String getOra_input_emptystr_isnull() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.ora_input_emptystr_isnull;
    }

    public boolean getHideRecycledObjects() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.hideRecycledObjects;
    }

    @Override
    public boolean isDatabaseSupportRowid() {
        return this.databaseSupportRowid;
    }

    public class AbortCommand
    implements Runnable {
        @Override
        public void run() {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KbConnection.this.abort();
        }
    }

    private class TransactionCommandHandler
    extends ResultHandlerBase {
        private TransactionCommandHandler() {
        }

        @Override
        public void handleCompletion() throws SQLException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            SQLWarning _warning = this.getWarning();
            if (_warning != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KbConnection.this.addWarning(_warning);
            }
            super.handleCompletion();
        }
    }

    private static enum EReadOnlyBehavior {
        ignore,
        transaction,
        always;

    }
}

