/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.KBNotification;
import com.kingbase8.KBProperty;
import com.kingbase8.core.BaseQueryKey;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.CachedQueryCreateAction;
import com.kingbase8.core.CallableQueryKey;
import com.kingbase8.core.Encoding;
import com.kingbase8.core.KBStream;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.QueryWithReturningColumnsKey;
import com.kingbase8.core.TransactionState;
import com.kingbase8.core.Utils;
import com.kingbase8.jdbc.AutoSave;
import com.kingbase8.jdbc.EscapeSyntaxCallMode;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LruCache;
import com.kingbase8.util.ServerErrorMessage;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;

public abstract class QueryExecutorBase
implements QueryExecutor {
    protected final KBStream kbStream;
    private final String user;
    private final String databaseT;
    private final int cancelSignalTimeout;
    private int _cancelPid;
    private int _cancelKey;
    private boolean isClosed = false;
    private String serVersion;
    private int serVersionNum = 0;
    private TransactionState transactionState;
    private final boolean reWriteBatchedInserts;
    private final boolean columnSanitiserDisabledT;
    private final EscapeSyntaxCallMode escapeSyntaxCallModeT;
    private final PreferQueryMode preferQueryModeT;
    private AutoSave _autoSave;
    private boolean flushCacheOnDeallocateT = true;
    protected final boolean logServerErrorDetail;
    private String compatibleLevel = "oracle";
    private String storeCase = "lower";
    private boolean standardConformingStrings = false;
    private SQLWarning _warnings;
    private final ArrayList<KBNotification> notifications = new ArrayList();
    private final LruCache<Object, CachedQuery> stmtCache;
    private final CachedQueryCreateAction cachedQueryCreateActionT;
    private final TreeMap<String, String> _parameterStatuses = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    protected QueryExecutorBase(KBStream kbStream, String user, String database, int cancelSignalTimeout, Properties info) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream = kbStream;
        this.user = user;
        this.databaseT = database;
        this.cancelSignalTimeout = cancelSignalTimeout;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.reWriteBatchedInserts = KBProperty.REWRITE_BATCHED_INSERTS.getBoolean(info);
        this.columnSanitiserDisabledT = KBProperty.DISABLE_COLUMN_SANITISER.getBoolean(info);
        String callMode = KBProperty.ESCAPE_SYNTAX_CALL_MODE.get(info);
        this.escapeSyntaxCallModeT = EscapeSyntaxCallMode.of(callMode);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String preferMode = KBProperty.PREFER_QUERY_MODE.get(info);
        this.preferQueryModeT = PreferQueryMode.of(preferMode);
        this._autoSave = AutoSave.of(KBProperty.AUTOSAVE.get(info));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.logServerErrorDetail = KBProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info);
        this.cachedQueryCreateActionT = new CachedQueryCreateAction(this);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.stmtCache = new LruCache<Object, CachedQuery>(Math.max(0, KBProperty.PREPARED_STATEMENT_CACHE_QUERIES.getInt(info)), Math.max(0, KBProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getInt(info) * 1024 * 1024), false, this.cachedQueryCreateActionT, new LruCache.EvictAction<CachedQuery>(){

            @Override
            public void evict(CachedQuery cachedQueryT) throws SQLException {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                cachedQueryT.query.close();
            }
        });
    }

    @Override
    public void setNetworkTimeout(int millisecsT) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.setNetworkTimeout(millisecsT);
    }

    protected abstract void sendCloseMessage() throws IOException;

    @Override
    public int getNetworkTimeout() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.kbStream.getNetworkTimeout();
    }

    @Override
    public String getDatabase() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.databaseT;
    }

    public void setBackendKeyData(int _cancelPid, int _cancelKey) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._cancelPid = _cancelPid;
        this._cancelKey = _cancelKey;
    }

    @Override
    public HostSpec getHostSpec() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.kbStream.getHostSpec();
    }

    @Override
    public int getBackendPID() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._cancelPid;
    }

    @Override
    public void abort() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.getSocket().close();
        }
        catch (IOException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        this.isClosed = true;
    }

    @Override
    public void close() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isClosed) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, " FE=> Terminate", new Object[0]);
            this.sendCloseMessage();
            this.kbStream.flush();
            this.kbStream.close();
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, "Discarding IOException on close:", ioe);
        }
        this.isClosed = true;
    }

    @Override
    public String getUser() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.user;
    }

    @Override
    public boolean isClosed() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendQueryCancel() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._cancelPid <= 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        KBStream _cancelStream = null;
        try {
            if (KBLOGGER.isLoggable(Level.FINEST)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBLOGGER.log(Level.FINEST, " FE=> CancelRequest(pid={0},c_key={1})", this._cancelPid, this._cancelKey);
            }
            _cancelStream = new KBStream(this.kbStream.getSocketFactory(), this.kbStream.getHostSpec(), this.cancelSignalTimeout, this.kbStream.isUseDispatch(), this.kbStream.getVersion(), this.kbStream.pCMV2);
            if (this.cancelSignalTimeout > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_cancelStream.isUseDispatch()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _cancelStream.getSocket().setSoTimeout(this.cancelSignalTimeout);
                    _cancelStream.setSocketTimeout(1);
                    KBLOGGER.log(Level.INFO, "socketTimeout is " + this.cancelSignalTimeout, new Object[0]);
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _cancelStream.getSocket().setSoTimeout(this.cancelSignalTimeout);
                }
            }
            _cancelStream.sendInteger4(16);
            _cancelStream.sendInteger2(1234);
            _cancelStream.sendInteger2(5678);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _cancelStream.sendInteger4(this._cancelPid);
            _cancelStream.sendInteger4(this._cancelKey);
            _cancelStream.flush();
            _cancelStream.receiveEOF();
        }
        catch (IOException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, "Ignoring exception on cancel request:", e);
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_cancelStream != null) {
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _cancelStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void addWarning(SQLWarning newWarning) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._warnings == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._warnings = newWarning;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._warnings.setNextWarning(newWarning);
        }
    }

    public synchronized void addNotification(KBNotification notification) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.notifications.add(notification);
    }

    @Override
    public synchronized KBNotification[] getNotifications() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBNotification[] array = this.notifications.toArray(new KBNotification[0]);
        this.notifications.clear();
        return array;
    }

    @Override
    public synchronized SQLWarning getWarnings() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLWarning chain = this._warnings;
        this._warnings = null;
        return chain;
    }

    @Override
    public String getServerVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.serVersion;
    }

    @Override
    public int getServerVersionNum() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.serVersionNum != 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.serVersionNum;
        }
        this.serVersionNum = Utils.parseServerVersionStr(this.serVersion);
        return this.serVersionNum;
    }

    public void setServerVersion(String serVersion) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.serVersion = serVersion;
    }

    public void setServerVersionNum(int serVersionNum) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.serVersionNum = serVersionNum;
    }

    public synchronized void setTransactionState(TransactionState state) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.transactionState = state;
    }

    public synchronized void setStandardConformingStrings(boolean _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.standardConformingStrings = _value;
    }

    @Override
    public synchronized boolean getStandardConformingStrings() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.standardConformingStrings;
    }

    @Override
    public synchronized TransactionState getTransactionState() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.transactionState;
    }

    public void setEncoding(Encoding _encoding) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.setEncoding(_encoding);
    }

    @Override
    public Encoding getEncoding() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.kbStream.getEncoding();
    }

    @Override
    public boolean isReWriteBatchedInsertsEnabled() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.reWriteBatchedInserts;
    }

    @Override
    public final CachedQuery borrowQuery(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.stmtCache.borrow(_sql);
    }

    @Override
    public final CachedQuery borrowCallableQuery(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.stmtCache.borrow(new CallableQueryKey(_sql));
    }

    @Override
    public final CachedQuery borrowReturningQuery(String _sql, String[] _columnNames) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.stmtCache.borrow(new QueryWithReturningColumnsKey(_sql, true, true, _columnNames));
    }

    @Override
    public CachedQuery borrowQueryByKey(Object _key) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.stmtCache.borrow(_key);
    }

    @Override
    public void releaseQuery(CachedQuery cachedQuery) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.stmtCache.put(cachedQuery._key, cachedQuery);
    }

    @Override
    public final Object createQueryKey(String _sql, boolean escapeProcessing, boolean isParameterized, String ... _columnNames) {
        Object _key;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_columnNames == null || _columnNames.length != 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _key = new QueryWithReturningColumnsKey(_sql, isParameterized, escapeProcessing, _columnNames);
        } else if (isParameterized) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _key = _sql;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _key = new BaseQueryKey(_sql, false, escapeProcessing);
        }
        return _key;
    }

    @Override
    public CachedQuery createQueryByKey(Object _key) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.cachedQueryCreateActionT.create(_key);
    }

    @Override
    public final CachedQuery createQuery(String _sql, boolean escapeProcessing, boolean isParameterized, String ... _columnNames) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object _key = this.createQueryKey(_sql, escapeProcessing, isParameterized, _columnNames);
        return this.createQueryByKey(_key);
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.columnSanitiserDisabledT;
    }

    @Override
    public AutoSave getAutoSave() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._autoSave;
    }

    @Override
    public void setAutoSave(AutoSave _autoSave) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._autoSave = _autoSave;
    }

    protected boolean willHealViaReparse(SQLException e) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (e == null || e.getSQLState() == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (KSQLState.INVALID_SQL_STATEMENT_NAME.getState().equals(e.getSQLState())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        if (!KSQLState.NOT_IMPLEMENTED.getState().equals(e.getSQLState())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (!(e instanceof KSQLException)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        KSQLException pe = (KSQLException)e;
        ServerErrorMessage serverErrorMessage = pe.getServerErrorMessage();
        if (serverErrorMessage == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String routine = pe.getServerErrorMessage().getRoutine();
        return "RevalidateCachedQuery".equals(routine) || "RevalidateCachedQueryInternal".equals(routine) || "RevalidateCachedPlan".equals(routine);
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.preferQueryModeT;
    }

    @Override
    public boolean willHealOnRetry(SQLException sqlException) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._autoSave == AutoSave.NEVER && this.getTransactionState() == TransactionState.FAILED) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        return this.willHealViaReparse(sqlException);
    }

    public boolean isFlushCacheOnDeallocate() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.flushCacheOnDeallocateT;
    }

    @Override
    public EscapeSyntaxCallMode getEscapeSyntaxCallMode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.escapeSyntaxCallModeT;
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean _flushCacheOnDeallocate) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.flushCacheOnDeallocateT = _flushCacheOnDeallocate;
    }

    protected boolean hasNotifications() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.notifications.size() > 0;
    }

    @Override
    public final Map<String, String> getParameterStatuses() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Collections.unmodifiableMap(this._parameterStatuses);
    }

    @Override
    public final String getParameterStatus(String parameterName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._parameterStatuses.get(parameterName);
    }

    protected void onParameterStatus(String parameterName, String _parameterStatus) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parameterName == null || parameterName.equals("")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("attempt to set GUC_REPORT _parameter with null or empty-string name");
        }
        this._parameterStatuses.put(parameterName, _parameterStatus);
    }

    @Override
    public String getCompatibleLevel() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.compatibleLevel;
    }

    @Override
    public void setCompatibleLevel(String compatibleLevel) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.compatibleLevel = compatibleLevel;
    }

    @Override
    public String getStoreCase() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.storeCase;
    }

    @Override
    public void setStoreCase(String storeCase) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.storeCase = storeCase;
    }
}

