/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.spring.cache;

import cloud.tianai.captcha.common.util.NamedThreadFactory;
import cloud.tianai.captcha.spring.cache.ExpiringMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConCurrentExpiringMap<K, V>
implements ExpiringMap<K, V> {
    private static final Logger log = LoggerFactory.getLogger(ConCurrentExpiringMap.class);
    private ConcurrentHashMap<K, ExpiringMap.TimeMapEntity<K, V>> storage;
    private SortedMap<Long, LinkedList<K>> sortedMap = new ConcurrentSkipListMap<Long, LinkedList<K>>();
    private final ScheduledExecutorService scheduledExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("expiring-map-expire"));
    public static final int LIMIT = 500;

    public ConCurrentExpiringMap() {
        this(128);
    }

    @Override
    public void init() {
        this.scheduledExecutor.scheduleAtFixedRate(new ExpireThread(), 5L, 5L, TimeUnit.SECONDS);
    }

    public ConCurrentExpiringMap(Integer initialCapacity) {
        this.storage = new ConcurrentHashMap(initialCapacity);
    }

    @Override
    public ExpiringMap.TimeMapEntity<K, V> put(K k, V v, Long expire, TimeUnit timeUnit) {
        ExpiringMap.TimeMapEntity<K, V> entity;
        if (expire == null || expire < 1L) {
            expire = DEFAULT_EXPIRE;
        }
        if (expire != null && expire > 0L) {
            entity = new ExpiringMap.TimeMapEntity<K, V>(k, v, timeUnit.toNanos(expire), System.nanoTime());
            this.sortedMap.computeIfAbsent(entity.getTimeout(), k1 -> new LinkedList()).add(k);
        } else {
            entity = new ExpiringMap.TimeMapEntity<K, V>(k, v, DEFAULT_EXPIRE, System.nanoTime());
        }
        ExpiringMap.TimeMapEntity<K, V> old = this.storage.put(k, entity);
        return old;
    }

    @Override
    public Optional<ExpiringMap.TimeMapEntity<K, V>> getData(K k) {
        return Optional.ofNullable(this.storage.get(k));
    }

    @Override
    public Long getExpire(K k) {
        return this.getData(k).map(ExpiringMap.TimeMapEntity::getExpire).orElse(DEFAULT_EXPIRE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean incr(K k, Long expire, TimeUnit timeUnit) {
        Optional<ExpiringMap.TimeMapEntity<K, V>> entityOptional = this.getData(k);
        if (!entityOptional.isPresent()) {
            return false;
        }
        K k2 = k;
        synchronized (k2) {
            ExpiringMap.TimeMapEntity<K, V> entity;
            entityOptional = this.getData(k);
            if (!entityOptional.isPresent()) {
                return false;
            }
            ExpiringMap.TimeMapEntity<K, V> newEntity = entity = entityOptional.get();
            newEntity.setExpire(entity.getExpire() + expire);
            if (expire != null && expire > 0L) {
                this.sortedMap.getOrDefault(k, new LinkedList()).add(k);
            }
            return true;
        }
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.storage.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Collection<ExpiringMap.TimeMapEntity<K, V>> values = this.storage.values();
        Optional<ExpiringMap.TimeMapEntity> any = values.stream().filter(v -> v.getValue().equals(value)).findAny();
        return any.isPresent();
    }

    @Override
    public V get(Object key) {
        ExpiringMap.TimeMapEntity<K, V> timeMapEntity = this.storage.get(key);
        if (this.isTimeout(timeMapEntity)) {
            this.removeData(key);
            return null;
        }
        return timeMapEntity.getValue();
    }

    protected boolean isTimeout(K key) {
        Optional<ExpiringMap.TimeMapEntity<K, V>> data = this.getData(key);
        return this.isTimeout((ExpiringMap.TimeMapEntity<K, V>)data.orElse(null));
    }

    protected boolean isTimeout(ExpiringMap.TimeMapEntity<K, V> timeMapEntity) {
        if (timeMapEntity == null || timeMapEntity.getExpire() < 1L) {
            return true;
        }
        long currentTimeMillis = System.nanoTime();
        long timeout = timeMapEntity.getTimeout();
        return timeout < currentTimeMillis;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, DEFAULT_EXPIRE, null).getValue();
    }

    @Override
    public V remove(Object key) {
        return this.removeData(key).map(ExpiringMap.TimeMapEntity::getValue).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<ExpiringMap.TimeMapEntity<K, V>> removeData(Object key) {
        Object object = key;
        synchronized (object) {
            ExpiringMap.TimeMapEntity<K, V> oldValue = this.storage.get(key);
            if (oldValue != null) {
                LinkedList ks;
                ExpiringMap.TimeMapEntity<K, V> entity = this.storage.remove(key);
                Long expire = oldValue.getExpire();
                if (expire != null && expire > 0L && (ks = (LinkedList)this.sortedMap.get(expire)) != null) {
                    ks.remove(key);
                }
                if (entity != null) {
                    return Optional.of(entity);
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        HashMap<K, ExpiringMap.TimeMapEntity<K, V>> copyStorage = new HashMap<K, ExpiringMap.TimeMapEntity<K, V>>(this.storage);
        this.storage.clear();
        this.sortedMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return ((Stream)this.storage.keySet().stream().parallel()).filter(k -> !this.isTimeout(k)).collect(Collectors.toSet());
    }

    @Override
    public Collection<V> values() {
        return this.storage.values().stream().map(ExpiringMap.TimeMapEntity::getValue).collect(Collectors.toSet());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new IllegalArgumentException("timemap not impl entrySet.");
    }

    private class ExpireThread
    implements Runnable {
        private ExpireThread() {
        }

        @Override
        public void run() {
            SortedMap expireMap = ConCurrentExpiringMap.this.sortedMap;
            int limit = 500;
            if (expireMap == null || expireMap.size() < 1) {
                return;
            }
            log.debug("storage-size: {}", (Object)ConCurrentExpiringMap.this.storage.size());
            log.debug("expire-size: {}", (Object)expireMap.size());
            int count = 0;
            LinkedList<Long> removeKeys = null;
            long currentTime = System.nanoTime();
            if (currentTime < (Long)expireMap.firstKey()) {
                return;
            }
            for (Map.Entry entry : expireMap.entrySet()) {
                Long expireAt = (Long)entry.getKey();
                LinkedList expireKeys = (LinkedList)entry.getValue();
                if (expireKeys == null || expireKeys.size() < 1) {
                    if (removeKeys == null) {
                        removeKeys = new LinkedList<Long>();
                    }
                    removeKeys.add(expireAt);
                    continue;
                }
                if (count >= limit) break;
                if (currentTime < expireAt) continue;
                Iterator iterator = expireKeys.iterator();
                while (iterator.hasNext()) {
                    Object key = iterator.next();
                    iterator.remove();
                    ConCurrentExpiringMap.this.get(key);
                    if (removeKeys == null) {
                        removeKeys = new LinkedList();
                    }
                    removeKeys.add(expireAt);
                    ++count;
                }
            }
            if (removeKeys != null && removeKeys.size() > 0) {
                for (Long removeKey : removeKeys) {
                    expireMap.remove(removeKey);
                }
            }
        }
    }
}

