/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse.response;

import cc.blynk.clickhouse.response.ByteFragment;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class StreamSplitter {
    private final InputStream delegate;
    private final byte sep;
    private byte[] buf;
    private int posRead;
    private int posNext;
    private int markedRead;
    private int markedNext;
    private boolean readOnce;
    private boolean closed;

    StreamSplitter(ByteFragment bf, byte sep) {
        this.delegate = bf.asStream();
        this.sep = sep;
        this.buf = new byte[bf.getLen()];
        this.readOnce = true;
    }

    StreamSplitter(InputStream delegate, byte sep, int bufLength) {
        this.delegate = delegate;
        this.sep = sep;
        this.buf = new byte[bufLength];
    }

    private static int indexOf(byte[] array, byte target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public ByteFragment next() throws IOException {
        int positionSep;
        int readBytes;
        if (this.posNext >= this.posRead && (readBytes = this.readFromStream()) <= 0) {
            return null;
        }
        while ((positionSep = StreamSplitter.indexOf(this.buf, this.sep, this.posNext, this.posRead)) < this.posNext) {
            int readBytes2 = this.readFromStream();
            if (readBytes2 > 0) continue;
            positionSep = this.posRead;
            break;
        }
        int fragmentStart = this.posNext;
        this.posNext = positionSep + 1;
        return new ByteFragment(this.buf, fragmentStart, positionSep - fragmentStart);
    }

    private int readFromStream() throws IOException {
        int read;
        if (this.readOnce) {
            if (this.posRead >= this.buf.length) {
                return -1;
            }
            int read2 = this.delegate.read(this.buf, this.posRead, this.buf.length - this.posRead);
            if (read2 > 0) {
                this.posRead += read2;
            }
            return read2;
        }
        if (this.posRead >= this.buf.length) {
            this.shiftOrResize();
        }
        if ((read = this.delegate.read(this.buf, this.posRead, this.buf.length - this.posRead)) > 0) {
            this.posRead += read;
        }
        return read;
    }

    private void shiftOrResize() {
        if (this.posNext > 0) {
            byte[] oldBuf = this.buf;
            this.buf = new byte[this.buf.length];
            System.arraycopy(oldBuf, this.posNext, this.buf, 0, oldBuf.length - this.posNext);
            this.posRead -= this.posNext;
            this.posNext = 0;
        } else {
            byte[] oldBuf = this.buf;
            this.buf = new byte[this.buf.length * 2];
            System.arraycopy(oldBuf, 0, this.buf, 0, oldBuf.length);
        }
    }

    public void close() throws IOException {
        this.closed = true;
        this.delegate.close();
    }

    boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        String bufStr = new String(this.buf, StandardCharsets.UTF_8).trim();
        return "StreamSplitter{delegate=" + this.delegate + ", sep=" + this.sep + ", buf=" + bufStr + ", posRead=" + this.posRead + ", posNext=" + this.posNext + ", readOnce=" + this.readOnce + '}';
    }

    void mark() {
        this.markedRead = this.posRead;
        this.markedNext = this.posNext;
    }

    void reset() {
        this.posRead = this.markedRead;
        this.posNext = this.markedNext;
    }
}

