/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse.response;

import cc.blynk.clickhouse.domain.ClickHouseDataType;
import java.util.TimeZone;

public final class ClickHouseColumnInfo {
    private static final String KEYWORD_NULLABLE = "Nullable";
    private static final String KEYWORD_LOW_CARDINALITY = "LowCardinality";
    private static final String KEYWORD_ARRAY = "Array";
    private ClickHouseDataType clickHouseDataType;
    private final String originalTypeName;
    private final String columnName;
    private boolean nullable;
    private boolean lowCardinality;
    private int arrayLevel;
    private ClickHouseDataType arrayBaseType;
    private TimeZone timeZone;
    private int precision;
    private int scale;

    public static ClickHouseColumnInfo parse(String typeInfo, String columnName) {
        int endIdx;
        ClickHouseColumnInfo column = new ClickHouseColumnInfo(typeInfo, columnName);
        int currIdx = 0;
        while (typeInfo.startsWith(KEYWORD_ARRAY, currIdx)) {
            ++column.arrayLevel;
            column.clickHouseDataType = ClickHouseDataType.Array;
            currIdx += KEYWORD_ARRAY.length() + 1;
        }
        if (typeInfo.startsWith(KEYWORD_LOW_CARDINALITY, currIdx)) {
            column.lowCardinality = true;
            currIdx += KEYWORD_LOW_CARDINALITY.length() + 1;
        }
        if (typeInfo.startsWith(KEYWORD_NULLABLE, currIdx)) {
            column.nullable = true;
            currIdx += KEYWORD_NULLABLE.length() + 1;
        }
        int n = endIdx = typeInfo.indexOf("(", currIdx) < 0 ? typeInfo.indexOf(")", currIdx) : typeInfo.indexOf("(", currIdx);
        if (endIdx < 0) {
            endIdx = typeInfo.length();
        }
        ClickHouseDataType dataType = ClickHouseDataType.fromTypeString(typeInfo.substring(currIdx, endIdx));
        if (column.arrayLevel > 0) {
            column.arrayBaseType = dataType;
        } else {
            column.clickHouseDataType = dataType;
        }
        column.precision = dataType.getDefaultPrecision();
        column.scale = dataType.getDefaultScale();
        currIdx = endIdx;
        if (endIdx == typeInfo.length() || !typeInfo.startsWith("(", currIdx)) {
            return column;
        }
        switch (dataType) {
            case DateTime: {
                String[] argsTZ = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                if (argsTZ.length != 1) break;
                column.timeZone = TimeZone.getTimeZone(argsTZ[0].replace("'", ""));
                break;
            }
            case Decimal: {
                String[] argsDecimal = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                if (argsDecimal.length != 2) break;
                column.precision = Integer.parseInt(argsDecimal[0]);
                column.scale = Integer.parseInt(argsDecimal[1]);
                break;
            }
            case Decimal32: 
            case Decimal64: 
            case Decimal128: {
                String[] argsScale = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                column.scale = Integer.parseInt(argsScale[0]);
                break;
            }
            case FixedString: {
                String[] argsPrecision = ClickHouseColumnInfo.splitArgs(typeInfo, currIdx);
                column.precision = Integer.parseInt(argsPrecision[0]);
                break;
            }
        }
        return column;
    }

    private static String[] splitArgs(String args, int currIdx) {
        return args.substring(args.indexOf("(", currIdx) + 1, args.indexOf(")", currIdx)).split("\\s*,\\s*");
    }

    private ClickHouseColumnInfo(String originalTypeName, String columnName) {
        this.originalTypeName = originalTypeName;
        this.columnName = columnName;
    }

    public ClickHouseDataType getClickHouseDataType() {
        return this.clickHouseDataType;
    }

    public String getOriginalTypeName() {
        return this.originalTypeName;
    }

    public String getCleanTypeName() {
        int start;
        if (!this.nullable && !this.lowCardinality) {
            return this.originalTypeName;
        }
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        int numParens = 0;
        if (this.lowCardinality) {
            start = this.originalTypeName.indexOf(KEYWORD_LOW_CARDINALITY);
            sb.append(this.originalTypeName, idx, start);
            ++numParens;
            idx = start + KEYWORD_LOW_CARDINALITY.length() + 1;
        }
        if (this.nullable) {
            start = this.originalTypeName.indexOf(KEYWORD_NULLABLE, idx);
            sb.append(this.originalTypeName, idx, start);
            ++numParens;
            idx = start + KEYWORD_NULLABLE.length() + 1;
        }
        sb.append(this.originalTypeName, idx, this.originalTypeName.length() - numParens);
        return sb.toString();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    boolean isLowCardinality() {
        return this.lowCardinality;
    }

    int getArrayLevel() {
        return this.arrayLevel;
    }

    public ClickHouseDataType getArrayBaseType() {
        return this.arrayBaseType;
    }

    TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }
}

