/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="UniformQuantizedConvolutionHybrid", inputsClass=Inputs.class)
public final class UniformQuantizedConvolutionHybrid<V extends TNumber>
extends RawOp
implements Operand<V> {
    public static final String OP_NAME = "UniformQuantizedConvolutionHybrid";
    private Output<V> output;

    public UniformQuantizedConvolutionHybrid(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <V extends TNumber> UniformQuantizedConvolutionHybrid<V> create(Scope scope, Operand<? extends TNumber> lhs, Operand<? extends TNumber> rhs, Operand<TFloat32> rhsScales, Operand<TInt32> rhsZeroPoints, Class<V> Tout, String padding, Long rhsQuantizationMinVal, Long rhsQuantizationMaxVal, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(lhs.asOutput());
        opBuilder.addInput(rhs.asOutput());
        opBuilder.addInput(rhsScales.asOutput());
        opBuilder.addInput(rhsZeroPoints.asOutput());
        opBuilder.setAttr("Tout", Operands.toDataType(Tout));
        opBuilder.setAttr("padding", padding);
        opBuilder.setAttr("rhs_quantization_min_val", rhsQuantizationMinVal);
        opBuilder.setAttr("rhs_quantization_max_val", rhsQuantizationMaxVal);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.windowStrides != null) {
                    long[] windowStridesArray = new long[opts.windowStrides.size()];
                    for (i = 0; i < windowStridesArray.length; ++i) {
                        windowStridesArray[i] = opts.windowStrides.get(i);
                    }
                    opBuilder.setAttr("window_strides", windowStridesArray);
                }
                if (opts.explicitPadding != null) {
                    long[] explicitPaddingArray = new long[opts.explicitPadding.size()];
                    for (i = 0; i < explicitPaddingArray.length; ++i) {
                        explicitPaddingArray[i] = opts.explicitPadding.get(i);
                    }
                    opBuilder.setAttr("explicit_padding", explicitPaddingArray);
                }
                if (opts.lhsDilation != null) {
                    long[] lhsDilationArray = new long[opts.lhsDilation.size()];
                    for (i = 0; i < lhsDilationArray.length; ++i) {
                        lhsDilationArray[i] = opts.lhsDilation.get(i);
                    }
                    opBuilder.setAttr("lhs_dilation", lhsDilationArray);
                }
                if (opts.rhsDilation != null) {
                    long[] rhsDilationArray = new long[opts.rhsDilation.size()];
                    for (i = 0; i < rhsDilationArray.length; ++i) {
                        rhsDilationArray[i] = opts.rhsDilation.get(i);
                    }
                    opBuilder.setAttr("rhs_dilation", rhsDilationArray);
                }
                if (opts.batchGroupCount != null) {
                    opBuilder.setAttr("batch_group_count", opts.batchGroupCount);
                }
                if (opts.featureGroupCount != null) {
                    opBuilder.setAttr("feature_group_count", opts.featureGroupCount);
                }
                if (opts.dimensionNumbers != null) {
                    opBuilder.setAttr("dimension_numbers", opts.dimensionNumbers);
                }
                if (opts.rhsQuantizationAxis == null) continue;
                opBuilder.setAttr("rhs_quantization_axis", opts.rhsQuantizationAxis);
            }
        }
        return new UniformQuantizedConvolutionHybrid<V>(opBuilder.build());
    }

    public static Options windowStrides(List<Long> windowStrides) {
        return new Options().windowStrides(windowStrides);
    }

    public static Options windowStrides(Long ... windowStrides) {
        return new Options().windowStrides(windowStrides);
    }

    public static Options explicitPadding(List<Long> explicitPadding) {
        return new Options().explicitPadding(explicitPadding);
    }

    public static Options explicitPadding(Long ... explicitPadding) {
        return new Options().explicitPadding(explicitPadding);
    }

    public static Options lhsDilation(List<Long> lhsDilation) {
        return new Options().lhsDilation(lhsDilation);
    }

    public static Options lhsDilation(Long ... lhsDilation) {
        return new Options().lhsDilation(lhsDilation);
    }

    public static Options rhsDilation(List<Long> rhsDilation) {
        return new Options().rhsDilation(rhsDilation);
    }

    public static Options rhsDilation(Long ... rhsDilation) {
        return new Options().rhsDilation(rhsDilation);
    }

    public static Options batchGroupCount(Long batchGroupCount) {
        return new Options().batchGroupCount(batchGroupCount);
    }

    public static Options featureGroupCount(Long featureGroupCount) {
        return new Options().featureGroupCount(featureGroupCount);
    }

    public static Options dimensionNumbers(String dimensionNumbers) {
        return new Options().dimensionNumbers(dimensionNumbers);
    }

    public static Options rhsQuantizationAxis(Long rhsQuantizationAxis) {
        return new Options().rhsQuantizationAxis(rhsQuantizationAxis);
    }

    public Output<V> output() {
        return this.output;
    }

    @Override
    public Output<V> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=UniformQuantizedConvolutionHybrid.class)
    public static class Inputs
    extends RawOpInputs<UniformQuantizedConvolutionHybrid<?>> {
        public final Operand<? extends TNumber> lhs;
        public final Operand<? extends TNumber> rhs;
        public final Operand<TFloat32> rhsScales;
        public final Operand<TInt32> rhsZeroPoints;
        public final DataType Tlhs;
        public final DataType Trhs;
        public final DataType Tout;
        public final long[] windowStrides;
        public final String padding;
        public final long[] explicitPadding;
        public final long[] lhsDilation;
        public final long[] rhsDilation;
        public final long batchGroupCount;
        public final long featureGroupCount;
        public final String dimensionNumbers;
        public final long rhsQuantizationAxis;
        public final long rhsQuantizationMinVal;
        public final long rhsQuantizationMaxVal;

        public Inputs(GraphOperation op) {
            super(new UniformQuantizedConvolutionHybrid(op), op, Arrays.asList("Tlhs", "Trhs", "Tout", "window_strides", "padding", "explicit_padding", "lhs_dilation", "rhs_dilation", "batch_group_count", "feature_group_count", "dimension_numbers", "rhs_quantization_axis", "rhs_quantization_min_val", "rhs_quantization_max_val"));
            int inputIndex = 0;
            this.lhs = op.input(inputIndex++);
            this.rhs = op.input(inputIndex++);
            this.rhsScales = op.input(inputIndex++);
            this.rhsZeroPoints = op.input(inputIndex++);
            this.Tlhs = op.attributes().getAttrType("Tlhs");
            this.Trhs = op.attributes().getAttrType("Trhs");
            this.Tout = op.attributes().getAttrType("Tout");
            this.windowStrides = op.attributes().getAttrIntList("window_strides");
            this.padding = op.attributes().getAttrString("padding");
            this.explicitPadding = op.attributes().getAttrIntList("explicit_padding");
            this.lhsDilation = op.attributes().getAttrIntList("lhs_dilation");
            this.rhsDilation = op.attributes().getAttrIntList("rhs_dilation");
            this.batchGroupCount = op.attributes().getAttrInt("batch_group_count");
            this.featureGroupCount = op.attributes().getAttrInt("feature_group_count");
            this.dimensionNumbers = op.attributes().getAttrString("dimension_numbers");
            this.rhsQuantizationAxis = op.attributes().getAttrInt("rhs_quantization_axis");
            this.rhsQuantizationMinVal = op.attributes().getAttrInt("rhs_quantization_min_val");
            this.rhsQuantizationMaxVal = op.attributes().getAttrInt("rhs_quantization_max_val");
        }
    }

    public static class Options {
        private List<Long> windowStrides;
        private List<Long> explicitPadding;
        private List<Long> lhsDilation;
        private List<Long> rhsDilation;
        private Long batchGroupCount;
        private Long featureGroupCount;
        private String dimensionNumbers;
        private Long rhsQuantizationAxis;

        private Options() {
        }

        public Options windowStrides(List<Long> windowStrides) {
            this.windowStrides = windowStrides;
            return this;
        }

        public Options windowStrides(Long ... windowStrides) {
            this.windowStrides = Arrays.asList(windowStrides);
            return this;
        }

        public Options explicitPadding(List<Long> explicitPadding) {
            this.explicitPadding = explicitPadding;
            return this;
        }

        public Options explicitPadding(Long ... explicitPadding) {
            this.explicitPadding = Arrays.asList(explicitPadding);
            return this;
        }

        public Options lhsDilation(List<Long> lhsDilation) {
            this.lhsDilation = lhsDilation;
            return this;
        }

        public Options lhsDilation(Long ... lhsDilation) {
            this.lhsDilation = Arrays.asList(lhsDilation);
            return this;
        }

        public Options rhsDilation(List<Long> rhsDilation) {
            this.rhsDilation = rhsDilation;
            return this;
        }

        public Options rhsDilation(Long ... rhsDilation) {
            this.rhsDilation = Arrays.asList(rhsDilation);
            return this;
        }

        public Options batchGroupCount(Long batchGroupCount) {
            this.batchGroupCount = batchGroupCount;
            return this;
        }

        public Options featureGroupCount(Long featureGroupCount) {
            this.featureGroupCount = featureGroupCount;
            return this;
        }

        public Options dimensionNumbers(String dimensionNumbers) {
            this.dimensionNumbers = dimensionNumbers;
            return this;
        }

        public Options rhsQuantizationAxis(Long rhsQuantizationAxis) {
            this.rhsQuantizationAxis = rhsQuantizationAxis;
            return this;
        }
    }
}

