/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TPUPartitionedInput", inputsClass=Inputs.class)
public final class PartitionedInput<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TPUPartitionedInput";
    private Output<T> output;

    public PartitionedInput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> PartitionedInput<T> create(Scope scope, Iterable<Operand<T>> inputs, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "PartitionedInput");
        opBuilder.addInputList(Operands.asOutputs(inputs));
        if (options != null) {
            for (Options opts : options) {
                if (opts.partitionDim == null) continue;
                opBuilder.setAttr("partition_dim", opts.partitionDim);
            }
        }
        return new PartitionedInput<T>(opBuilder.build());
    }

    public static Options partitionDim(Long partitionDim) {
        return new Options().partitionDim(partitionDim);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=PartitionedInput.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<PartitionedInput<T>> {
        public final Iterable<Operand<T>> inputs;
        public final DataType T;
        public final long partitionDim;

        public Inputs(GraphOperation op) {
            super(new PartitionedInput(op), op, Arrays.asList("T", "partition_dim"));
            int inputIndex = 0;
            int inputsLength = op.inputListLength("inputs");
            this.inputs = Arrays.asList((Operand[])op.inputList(inputIndex, inputsLength));
            inputIndex += inputsLength;
            this.T = op.attributes().getAttrType("T");
            this.partitionDim = op.attributes().getAttrInt("partition_dim");
        }
    }

    public static class Options {
        private Long partitionDim;

        private Options() {
        }

        public Options partitionDim(Long partitionDim) {
            this.partitionDim = partitionDim;
            return this;
        }
    }
}

